/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ContentsUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.LabelUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class IntersectingLocalChangesPanel {
    @NotNull
    private final BorderLayoutPanel myPanel;
    @NotNull
    private final List<FilePath> myFiles;
    @NotNull
    private final Project myProject;

    public IntersectingLocalChangesPanel(@NotNull Project project, @NotNull List<FilePath> files, @NotNull String text) {
        this.myProject = project;
        this.myFiles = files;
        this.myPanel = this.createPanel((JLabel)IntersectingLocalChangesPanel.createLabel(text), (JTree)this.createTree());
    }

    @NotNull
    private BorderLayoutPanel createPanel(@NotNull JLabel label, @NotNull JTree tree) {
        BorderLayoutPanel panel = JBUI.Panels.simplePanel();
        panel.setBackground(UIUtil.getTextFieldBackground());
        panel.addToTop((Component)label).addToCenter((Component)tree);
        new EditSourceAction().registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)panel);
        DataManager.registerDataProvider((JComponent)panel, dataId -> {
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                return ChangesUtil.getNavigatableArray((Project)this.myProject, UtilKt.stream((Object[])tree.getSelectionPaths()).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilePathsUnderStream).map(FilePath::getVirtualFile).filter(Objects::nonNull).distinct());
            }
            return null;
        });
        return panel;
    }

    @NotNull
    private SimpleTree createTree() {
        SimpleTree tree = new SimpleTree(TreeModelBuilder.buildFromFilePaths((Project)this.myProject, (ChangesGroupingPolicyFactory)NoneChangesGroupingFactory.INSTANCE, this.myFiles)){

            protected void configureUiHelper(@NotNull TreeUIHelper helper) {
                super.configureUiHelper(helper);
                helper.installEditSourceOnDoubleClick((JTree)((Object)this));
                helper.installEditSourceOnEnterKeyHandler((JTree)((Object)this));
            }
        };
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        tree.setCellRenderer((TreeCellRenderer)new ChangesBrowserNodeRenderer(this.myProject, BooleanGetter.TRUE, false));
        return tree;
    }

    @NotNull
    private static JBLabel createLabel(@NotNull String text) {
        JBLabel label = new JBLabel(text){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, (int)((double)size.height * 1.7));
            }
        };
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setBackground(UIUtil.getTextFieldBackground());
        label.setVerticalTextPosition(1);
        return label;
    }

    public static void showInVersionControlToolWindow(@NotNull Project project, @NotNull String title, @NotNull List<FilePath> files, @NotNull String prompt) {
        IntersectingLocalChangesPanel intersectingPanel = new IntersectingLocalChangesPanel(project, files, prompt);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)intersectingPanel.myPanel, title, true);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        ContentsUtil.addContent((ContentManager)toolWindow.getContentManager(), (Content)content, (boolean)true);
        toolWindow.activate(null);
    }
}

