/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

class RepositoryLoader
extends Loader {
    @NotNull
    private final Queue<Pair<RepositoryTreeNode, Expander>> myLoadQueue = ContainerUtil.newLinkedList();
    private boolean myQueueProcessorActive = false;

    RepositoryLoader(@NotNull SvnRepositoryCache cache) {
        super(cache);
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander afterRefreshExpander) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair data = Pair.create((Object)node, (Object)afterRefreshExpander);
        if (!this.myQueueProcessorActive) {
            this.startLoadTask((Pair<RepositoryTreeNode, Expander>)data);
            this.myQueueProcessorActive = true;
        } else {
            this.myLoadQueue.offer((Pair<RepositoryTreeNode, Expander>)data);
        }
    }

    private void setResults(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull List<DirectoryEntry> children) {
        this.myCache.put(((RepositoryTreeNode)data.first).getURL(), children);
        this.refreshNode((RepositoryTreeNode)data.first, children, (Expander)data.second);
    }

    private void setError(@NotNull Pair<RepositoryTreeNode, Expander> data, @NotNull String message) {
        this.myCache.put(((RepositoryTreeNode)data.first).getURL(), message);
        this.refreshNodeError((RepositoryTreeNode)data.first, message);
    }

    private void startNext() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<RepositoryTreeNode, Expander> data = this.myLoadQueue.poll();
        if (data == null) {
            this.myQueueProcessorActive = false;
            return;
        }
        if (((RepositoryTreeNode)data.first).isDisposed()) {
            this.startNext();
        } else {
            this.startLoadTask(data);
        }
    }

    private void startLoadTask(@NotNull Pair<RepositoryTreeNode, Expander> data) {
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)new LoadTask(data), (ProgressIndicator)new EmptyProgressIndicator());
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        return NodeLoadState.REFRESHED;
    }

    private class LoadTask
    extends Task.Backgroundable {
        @NotNull
        private final Pair<RepositoryTreeNode, Expander> myData;
        @NotNull
        private final List<DirectoryEntry> entries;
        @Nullable
        private String error;

        private LoadTask(Pair<RepositoryTreeNode, Expander> data) {
            super(((RepositoryTreeNode)data.first).getVcs().getProject(), "Loading Child Entries");
            this.entries = ContainerUtil.newArrayList();
            this.myData = data;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            RepositoryTreeNode node = (RepositoryTreeNode)this.myData.first;
            SvnVcs vcs = node.getVcs();
            Target target = Target.on(node.getURL());
            try {
                vcs.getFactoryFromSettings().createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, this.entries::add);
            }
            catch (VcsException e) {
                this.error = e.getMessage();
            }
        }

        public void onSuccess() {
            if (this.error != null) {
                RepositoryLoader.this.setError((Pair<RepositoryTreeNode, Expander>)this.myData, this.error);
            } else {
                RepositoryLoader.this.setResults((Pair<RepositoryTreeNode, Expander>)this.myData, ContainerUtil.sorted(this.entries, DirectoryEntry.CASE_INSENSITIVE_ORDER));
            }
            RepositoryLoader.this.startNext();
        }
    }
}

