/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public class SyntheticWorker {
    private final SvnRepositoryCache myCache = SvnRepositoryCache.getInstance();
    private final Url myUrl;

    public SyntheticWorker(Url url) {
        this.myUrl = url;
    }

    public void removeSelf() {
        Url parentUrl;
        try {
            parentUrl = SvnUtil.removePathTail(this.myUrl);
        }
        catch (SvnBindException e) {
            return;
        }
        List<DirectoryEntry> children = this.myCache.getChildren(parentUrl);
        if (children == null) {
            return;
        }
        Iterator<DirectoryEntry> iterator = children.iterator();
        while (iterator.hasNext()) {
            DirectoryEntry entry = iterator.next();
            if (!this.myUrl.equals(entry.getUrl())) continue;
            iterator.remove();
        }
        this.myCache.put(parentUrl, children);
    }

    public void addSyntheticChildToSelf(Url newUrl, Url repositoryUrl, String name, boolean isDir) {
        List<DirectoryEntry> children = this.myCache.getChildren(this.myUrl);
        if (children == null) {
            return;
        }
        children.add(SyntheticWorker.createSyntheticEntry(newUrl, repositoryUrl, name, isDir));
        Collections.sort(children, DirectoryEntry.CASE_INSENSITIVE_ORDER);
        this.myCache.put(this.myUrl, children);
    }

    public void copyTreeToSelf(RepositoryTreeNode node) {
        try {
            node.doOnSubtree(new Adder(SvnUtil.removePathTail(node.getURL()).toString().length(), this.myUrl));
        }
        catch (SvnBindException svnBindException) {
            // empty catch block
        }
    }

    public static void removeTreeOf(RepositoryTreeNode node) {
        node.doOnSubtree(new Remover());
    }

    public static DirectoryEntry createSyntheticEntry(Url newUrl, Url repositoryUrl, String name, boolean isDir) {
        return new DirectoryEntry(newUrl, repositoryUrl, name, NodeKind.from(isDir), CommitInfo.EMPTY, null);
    }

    private class Adder
    implements NotNullFunction<RepositoryTreeNode, Object> {
        private final int myOldPrefixLen;
        private final Url myNewParentUrl;

        private Adder(int oldPrefixLen, Url newParentUrl) {
            this.myOldPrefixLen = oldPrefixLen;
            this.myNewParentUrl = newParentUrl;
        }

        @NotNull
        public Object fun(RepositoryTreeNode repositoryTreeNode) {
            List<DirectoryEntry> children = SyntheticWorker.this.myCache.getChildren(repositoryTreeNode.getURL());
            if (children == null) {
                return Boolean.FALSE;
            }
            ArrayList<DirectoryEntry> newChildren = new ArrayList<DirectoryEntry>(children.size());
            try {
                for (DirectoryEntry child : children) {
                    newChildren.add(SyntheticWorker.createSyntheticEntry(this.convertUrl(child.getUrl()), child.getRepositoryRoot(), child.getName(), child.isDirectory()));
                }
                SyntheticWorker.this.myCache.put(this.convertUrl(repositoryTreeNode.getURL()), newChildren);
            }
            catch (SvnBindException svnBindException) {
                // empty catch block
            }
            return Boolean.FALSE;
        }

        @NotNull
        private Url convertUrl(@NotNull Url currentUrl) throws SvnBindException {
            return SvnUtil.append(this.myNewParentUrl, currentUrl.toString().substring(this.myOldPrefixLen), true);
        }
    }

    private static class Remover
    implements NotNullFunction<RepositoryTreeNode, Object> {
        private final SvnRepositoryCache myCache = SvnRepositoryCache.getInstance();

        private Remover() {
        }

        @NotNull
        public Object fun(RepositoryTreeNode repositoryTreeNode) {
            this.myCache.remove(repositoryTreeNode.getURL());
            return Boolean.FALSE;
        }
    }
}

