/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;

public class CmdHistoryClient
extends BaseSvnClient
implements HistoryClient {
    @Override
    public void doLog(@NotNull Target target, @NotNull Revision startRevision, @NotNull Revision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, @Nullable String[] revisionProperties, @Nullable LogEntryConsumer handler) throws VcsException {
        List<String> parameters = CmdHistoryClient.prepareCommand(target, startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.log, parameters, null);
        CmdHistoryClient.parseOutput(command, handler);
    }

    private static void parseOutput(@NotNull CommandExecutor command, @Nullable LogEntryConsumer handler) throws VcsException {
        try {
            LogInfo log = CommandUtil.parse(command.getOutput(), LogInfo.class);
            if (handler != null && log != null) {
                for (LogEntry.Builder entry : log.entries) {
                    CmdHistoryClient.iterateRecursively(entry, handler);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void iterateRecursively(@NotNull LogEntry.Builder entry, @NotNull LogEntryConsumer handler) throws SvnBindException {
        handler.consume(entry.build());
        for (LogEntry.Builder childEntry : entry.getChildEntries()) {
            CmdHistoryClient.iterateRecursively(childEntry, handler);
        }
        if (entry.hasChildren()) {
            handler.consume(LogEntry.EMPTY);
        }
    }

    private static List<String> prepareCommand(@NotNull Target target, @NotNull Revision startRevision, @NotNull Revision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit) {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, startRevision, endRevision);
        CommandUtil.put(parameters, stopOnCopy, "--stop-on-copy");
        CommandUtil.put(parameters, discoverChangedPaths, "--verbose");
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        if (limit > 0L) {
            parameters.add("--limit");
            parameters.add(String.valueOf(limit));
        }
        parameters.add("--xml");
        return parameters;
    }

    @XmlRootElement(name="log")
    public static class LogInfo {
        @XmlElement(name="logentry")
        public List<LogEntry.Builder> entries = ContainerUtil.newArrayList();
    }
}

