/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.history.SvnLazyPropertyContentRevision;
import org.jetbrains.idea.svn.properties.PropertyData;

public class SimplePropertyRevision
implements ContentRevision,
PropertyRevision {
    private final List<PropertyData> myProperty;
    private final FilePath myNewFilePath;
    private final String myRevision;

    @Override
    @Nullable
    public List<PropertyData> getProperties() {
        return this.myProperty;
    }

    public SimplePropertyRevision(List<PropertyData> property, FilePath newFilePath, String revision) {
        this.myProperty = property;
        this.myNewFilePath = newFilePath;
        this.myRevision = revision;
    }

    @Nullable
    public String getContent() {
        return SvnLazyPropertyContentRevision.toSortedStringPresentation(this.myProperty);
    }

    @NotNull
    public FilePath getFile() {
        return this.myNewFilePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return new VcsRevisionNumber(){

            public String asString() {
                return SimplePropertyRevision.this.myRevision;
            }

            public int compareTo(VcsRevisionNumber o) {
                return 0;
            }
        };
    }
}

