/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;

public class SvnMergeSourceTracker
implements ThrowableConsumer<LogEntry, SvnBindException> {
    private int myMergeLevel;
    private final ThrowableConsumer<? super Pair<LogEntry, Integer>, ? extends SvnBindException> myConsumer;

    public SvnMergeSourceTracker(@NotNull ThrowableConsumer<? super Pair<LogEntry, Integer>, ? extends SvnBindException> consumer) {
        this.myConsumer = consumer;
        this.myMergeLevel = -1;
    }

    public void consume(@NotNull LogEntry logEntry) throws SvnBindException {
        if (logEntry.getRevision() < 0L) {
            --this.myMergeLevel;
            return;
        }
        this.myConsumer.consume((Object)new Pair((Object)logEntry, (Object)this.myMergeLevel));
        if (logEntry.hasChildren()) {
            ++this.myMergeLevel;
        }
    }
}

