/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;

public class WcInfoLoader {
    @NotNull
    private final SvnVcs myVcs;
    @Nullable
    private final RepositoryLocation myLocation;

    public WcInfoLoader(@NotNull SvnVcs vcs, @Nullable RepositoryLocation location) {
        this.myVcs = vcs;
        this.myLocation = location;
    }

    @NotNull
    public List<WCInfoWithBranches> loadRoots() {
        ArrayList result = ContainerUtil.newArrayList();
        for (WCInfo info2 : this.myVcs.getAllWcInfos()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)this.createInfo(info2));
        }
        return result;
    }

    @Nullable
    public WCInfoWithBranches reloadInfo(@NotNull WCInfoWithBranches info2) {
        File file = info2.getRootInfo().getIoFile();
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((VirtualFile)info2.getRootInfo().getVirtualFile()));
        return rootInfo != null ? this.createInfo(new WCInfo(rootInfo, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this.myVcs, file))) : null;
    }

    @Nullable
    private WCInfoWithBranches createInfo(@NotNull WCInfo info2) {
        if (!info2.getFormat().supportsMergeInfo()) {
            return null;
        }
        String url = info2.getUrl().toString();
        if (this.myLocation != null && !this.myLocation.toPresentableString().startsWith(url) && !url.startsWith(this.myLocation.toPresentableString())) {
            return null;
        }
        if (!SvnUtil.checkRepositoryVersion15(this.myVcs, info2.getUrl())) {
            return null;
        }
        RootUrlInfo rootForUrl = this.myVcs.getSvnFileUrlMapping().getWcRootForUrl(info2.getUrl());
        return rootForUrl != null ? this.createInfoWithBranches(info2, rootForUrl) : null;
    }

    @NotNull
    private WCInfoWithBranches createInfoWithBranches(@NotNull WCInfo info2, @NotNull RootUrlInfo rootUrlInfo) {
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject()).get(rootUrlInfo.getVirtualFile());
        Ref workingCopyBranch = Ref.create();
        ArrayList branches = ContainerUtil.newArrayList();
        Url trunk = configuration.getTrunk();
        if (trunk != null) {
            WcInfoLoader.add(info2.getUrl(), trunk, branches, (Ref<WCInfoWithBranches.Branch>)workingCopyBranch);
        }
        for (Url branchUrl : configuration.getBranchLocations()) {
            for (SvnBranchItem branchItem : configuration.getBranches(branchUrl)) {
                WcInfoLoader.add(info2.getUrl(), branchItem.getUrl(), branches, (Ref<WCInfoWithBranches.Branch>)workingCopyBranch);
            }
        }
        Collections.sort(branches, Comparator.comparing(branch -> branch.getUrl().toDecodedString()));
        return new WCInfoWithBranches(info2, branches, rootUrlInfo.getRoot(), (WCInfoWithBranches.Branch)workingCopyBranch.get());
    }

    private static void add(@NotNull Url url, @NotNull Url branchUrl, @NotNull List<WCInfoWithBranches.Branch> branches, @NotNull Ref<WCInfoWithBranches.Branch> workingCopyBranch) {
        WCInfoWithBranches.Branch branch = new WCInfoWithBranches.Branch(branchUrl);
        if (!SvnUtil.isAncestor(branchUrl, url)) {
            branches.add(branch);
        } else {
            workingCopyBranch.set((Object)branch);
        }
    }
}

