/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public class ChangeListsMergerFactory
implements MergerFactory {
    @NotNull
    protected final List<CommittedChangeList> myChangeLists;
    private final boolean myRecordOnly;
    private final boolean myInvertRange;
    private final boolean myGroupSequentialChangeLists;

    public ChangeListsMergerFactory(@NotNull List<? extends CommittedChangeList> changeLists, boolean recordOnly, boolean invertRange, boolean groupSequentialChangeLists) {
        this.myChangeLists = ContainerUtil.newArrayList(changeLists);
        this.myRecordOnly = recordOnly;
        this.myInvertRange = invertRange;
        this.myGroupSequentialChangeLists = groupSequentialChangeLists;
    }

    @Override
    public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, Url currentBranchUrl, String branchName) {
        return new Merger(vcs, this.myChangeLists, target, handler, currentBranchUrl, branchName, this.myRecordOnly, this.myInvertRange, this.myGroupSequentialChangeLists);
    }
}

