/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchMapperManager;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;

public class IntegratedSelectedOptionsDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JCheckBox myDryRunCheckbox;
    private JList myWorkingCopiesList;
    private JComponent myToolbar;
    private JLabel mySourceInfoLabel;
    private JLabel myTargetInfoLabel;
    private JLabel myWcListTitleLabel;
    private JCheckBox myIgnoreWhitespacesCheckBox;
    private final Project myProject;
    @NotNull
    private final Url mySelectedBranchUrl;
    private final SvnVcs myVcs;
    private final String mySelectedRepositoryUUID;
    private DefaultActionGroup myGroup;
    private boolean myMustSelectBeforeOk = true;

    public IntegratedSelectedOptionsDialog(Project project, Url currentBranch, @NotNull Url selectedBranchUrl) {
        super(project, true);
        this.myProject = project;
        this.mySelectedBranchUrl = selectedBranchUrl;
        this.$$$setupUI$$$();
        this.myVcs = SvnVcs.getInstance(this.myProject);
        this.mySelectedRepositoryUUID = SvnUtil.getRepositoryUUID(this.myVcs, currentBranch);
        this.setTitle(SvnBundle.message("action.Subversion.integrate.changes.dialog.title", new Object[0]));
        this.init();
        this.myWorkingCopiesList.setModel(new DefaultListModel());
        this.myWorkingCopiesList.addListSelectionListener(e -> this.setOKActionEnabled(!this.myMustSelectBeforeOk || this.myWorkingCopiesList.getSelectedIndex() != -1));
        this.setOKActionEnabled(!this.myMustSelectBeforeOk || this.myWorkingCopiesList.getSelectedIndex() != -1);
        ArrayList<WorkingCopyInfo> workingCopyInfoList = new ArrayList<WorkingCopyInfo>();
        Set<String> workingCopies = SvnBranchMapperManager.getInstance().get(this.mySelectedBranchUrl);
        if (workingCopies != null) {
            for (String workingCopy : workingCopies) {
                workingCopyInfoList.add(new WorkingCopyInfo(workingCopy, this.underProject(new File(workingCopy))));
            }
        }
        Collections.sort(workingCopyInfoList, WorkingCopyInfoComparator.getInstance());
        for (WorkingCopyInfo info2 : workingCopyInfoList) {
            ((DefaultListModel)this.myWorkingCopiesList.getModel()).addElement(info2);
        }
        if (!workingCopyInfoList.isEmpty()) {
            this.myWorkingCopiesList.setSelectedIndex(0);
        }
        SvnConfiguration svnConfig = this.myVcs.getSvnConfiguration();
        this.myDryRunCheckbox.setSelected(svnConfig.isMergeDryRun());
        this.myIgnoreWhitespacesCheckBox.setSelected(svnConfig.isIgnoreSpacesInMerge());
        this.mySourceInfoLabel.setText(SvnBundle.message("action.Subversion.integrate.changes.branch.info.source.label.text", currentBranch));
        this.myTargetInfoLabel.setText(SvnBundle.message("action.Subversion.integrate.changes.branch.info.target.label.text", selectedBranchUrl.toDecodedString()));
        String addText = SvnBundle.message("action.Subversion.integrate.changes.dialog.add.wc.text", new Object[0]);
        DumbAwareAction addAction = new DumbAwareAction(addText, addText, IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, IntegratedSelectedOptionsDialog.this.myWorkingCopiesList);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VirtualFile vFile = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)IntegratedSelectedOptionsDialog.this.myProject, null);
                if (vFile != null) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                    if (IntegratedSelectedOptionsDialog.this.hasDuplicate(file)) {
                        return;
                    }
                    String repositoryUUID = SvnUtil.getRepositoryUUID(IntegratedSelectedOptionsDialog.this.myVcs, file);
                    if (IntegratedSelectedOptionsDialog.this.mySelectedRepositoryUUID != null && !IntegratedSelectedOptionsDialog.this.mySelectedRepositoryUUID.equals(repositoryUUID)) {
                        if (0 == Messages.showOkCancelDialog((String)(repositoryUUID == null ? SvnBundle.message("action.Subversion.integrate.changes.message.not.under.control.text", new Object[0]) : SvnBundle.message("action.Subversion.integrate.changes.message.another.wc.text", new Object[0])), (String)IntegratedSelectedOptionsDialog.this.getTitle(), (Icon)UIUtil.getWarningIcon())) {
                            IntegratedSelectedOptionsDialog.this.onOkToAdd(file);
                        }
                    } else {
                        IntegratedSelectedOptionsDialog.this.onOkToAdd(file);
                    }
                }
            }
        };
        this.myGroup.add((AnAction)addAction);
        String removeText = SvnBundle.message("action.Subversion.integrate.changes.dialog.remove.wc.text", new Object[0]);
        this.myGroup.add((AnAction)new DumbAwareAction(removeText, removeText, PlatformIcons.DELETE_ICON){
            {
                this.registerCustomShortcutSet(CommonShortcuts.getDelete(), IntegratedSelectedOptionsDialog.this.myWorkingCopiesList);
            }

            public void update(@NotNull AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                int idx = IntegratedSelectedOptionsDialog.this.myWorkingCopiesList == null ? -1 : IntegratedSelectedOptionsDialog.this.myWorkingCopiesList.getSelectedIndex();
                presentation.setEnabled(idx != -1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                int idx = IntegratedSelectedOptionsDialog.this.myWorkingCopiesList.getSelectedIndex();
                if (idx != -1) {
                    DefaultListModel model = (DefaultListModel)IntegratedSelectedOptionsDialog.this.myWorkingCopiesList.getModel();
                    WorkingCopyInfo info2 = (WorkingCopyInfo)model.get(idx);
                    model.removeElementAt(idx);
                    SvnBranchMapperManager.getInstance().remove(IntegratedSelectedOptionsDialog.this.mySelectedBranchUrl, new File(info2.getLocalPath()));
                }
            }
        });
    }

    public void setSelectedWcPath(String path) {
        ListModel model = this.myWorkingCopiesList.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            WorkingCopyInfo info2 = (WorkingCopyInfo)model.getElementAt(i);
            if (!info2.getLocalPath().equals(path)) continue;
            this.myWorkingCopiesList.setSelectedValue(info2, true);
            return;
        }
    }

    public void selectWcopyRootOnly() {
        this.myMustSelectBeforeOk = false;
        this.setTitle(SvnBundle.message("dialog.Subversion.select.working.copy.title", new Object[0]));
        this.myIgnoreWhitespacesCheckBox.setVisible(false);
        this.myDryRunCheckbox.setVisible(false);
        this.myWcListTitleLabel.setText(SvnBundle.message("dialog.Subversion.select.working.copy.wcopy.list.title", new Object[0]));
    }

    private void createUIComponents() {
        this.myGroup = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SvnIntegratedSelectedOptionsDialog", (ActionGroup)this.myGroup, false);
        this.myToolbar = actionToolbar.getComponent();
    }

    private boolean hasDuplicate(File file) {
        DefaultListModel model = (DefaultListModel)this.myWorkingCopiesList.getModel();
        String path = file.getAbsolutePath();
        for (int i = 0; i < model.getSize(); ++i) {
            WorkingCopyInfo info2 = (WorkingCopyInfo)model.getElementAt(i);
            if (!path.equals(info2.getLocalPath())) continue;
            return true;
        }
        return false;
    }

    private void onOkToAdd(File file) {
        WorkingCopyInfo info2 = new WorkingCopyInfo(file.getAbsolutePath(), this.underProject(file));
        DefaultListModel model = (DefaultListModel)this.myWorkingCopiesList.getModel();
        model.addElement(info2);
        this.myWorkingCopiesList.setSelectedValue(info2, true);
        SvnBranchMapperManager.getInstance().put(this.mySelectedBranchUrl, file);
    }

    private boolean underProject(File file) {
        return (Boolean)ReadAction.compute(() -> {
            VirtualFile vf = SvnUtil.getVirtualFile(file.getAbsolutePath());
            return vf == null || ((FileIndexFacade)ServiceManager.getService((Project)this.myProject, FileIndexFacade.class)).isInContent(vf);
        });
    }

    public WorkingCopyInfo getSelectedWc() {
        return (WorkingCopyInfo)this.myWorkingCopiesList.getSelectedValue();
    }

    public void saveOptions() {
        SvnConfiguration svnConfig = this.myVcs.getSvnConfiguration();
        svnConfig.setMergeDryRun(this.myDryRunCheckbox.isSelected());
        svnConfig.setIgnoreSpacesInMerge(this.myIgnoreWhitespacesCheckBox.isSelected());
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @Nullable
    private static Url realTargetUrl(@NotNull SvnVcs vcs, @NotNull WorkingCopyInfo info2, @NotNull Url targetBranchUrl) {
        Info svnInfo = vcs.getInfo(info2.getLocalPath());
        Url url = svnInfo != null ? svnInfo.getUrl() : null;
        return url != null && SvnUtil.isAncestor(targetBranchUrl, url) ? url : null;
    }

    @Nullable
    public static Pair<WorkingCopyInfo, Url> selectWorkingCopy(Project project, Url currentBranch, @NotNull Url targetBranch, boolean showIntegrationParameters, String selectedLocalBranchPath, String dialogTitle) {
        IntegratedSelectedOptionsDialog dialog = new IntegratedSelectedOptionsDialog(project, currentBranch, targetBranch);
        if (!showIntegrationParameters) {
            dialog.selectWcopyRootOnly();
        }
        if (selectedLocalBranchPath != null) {
            dialog.setSelectedWcPath(selectedLocalBranchPath);
        }
        if (dialogTitle != null) {
            dialog.setTitle(dialogTitle);
        }
        if (dialog.showAndGet()) {
            StoreUtil.saveDocumentsAndProjectSettings((Project)project);
            dialog.saveOptions();
            WorkingCopyInfo info2 = dialog.getSelectedWc();
            if (info2 != null) {
                File file = new File(info2.getLocalPath());
                if (!file.exists() || !file.isDirectory()) {
                    Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.target.not.dir.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
                    return null;
                }
                Url targetUrl = IntegratedSelectedOptionsDialog.realTargetUrl(SvnVcs.getInstance(project), info2, targetBranch);
                if (targetUrl == null) {
                    Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.not.versioned.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
                    return null;
                }
                return Pair.create((Object)info2, (Object)targetUrl);
            }
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myWorkingCopiesList = jBList;
        jBList.setMinimumSize(new Dimension(100, 100));
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myDryRunCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.update.switch.configurable.try.merge.without.changes"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreWhitespacesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.ignore.whitespace.when.merge.text"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWcListTitleLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.integrate.changes.select.working.copy.text"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.myToolbar;
        jPanel.add((Component)jComponent, new GridConstraints(4, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        this.mySourceInfoLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetInfoLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 0, 0, new Dimension(2, 3), null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class WorkingCopyInfoComparator
    implements Comparator<WorkingCopyInfo> {
        private static final WorkingCopyInfoComparator instance = new WorkingCopyInfoComparator();

        public static WorkingCopyInfoComparator getInstance() {
            return instance;
        }

        private WorkingCopyInfoComparator() {
        }

        @Override
        public int compare(WorkingCopyInfo o1, WorkingCopyInfo o2) {
            return o1.getLocalPath().compareTo(o2.getLocalPath());
        }
    }
}

