/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Intersection {
    @NotNull
    private final Map<String, String> myListComments = ContainerUtil.newHashMap();
    @NotNull
    private final Map<String, List<Change>> myChangesByLists = ContainerUtil.newHashMap();

    public void add(@NotNull LocalChangeList list, @NotNull Change change) {
        this.myChangesByLists.computeIfAbsent(list.getName(), key -> ContainerUtil.newArrayList()).add(change);
        this.myListComments.put(list.getName(), (String)ObjectUtils.notNull((Object)list.getComment(), (Object)list.getName()));
    }

    @NotNull
    public String getComment(@NotNull String listName) {
        return this.myListComments.get(listName);
    }

    @NotNull
    public Map<String, List<Change>> getChangesByLists() {
        return this.myChangesByLists;
    }

    public boolean isEmpty() {
        return this.myChangesByLists.isEmpty();
    }

    @NotNull
    public List<Change> getAllChanges() {
        return ContainerUtil.concat(this.myChangesByLists.values());
    }

    public static boolean isEmpty(@Nullable Intersection intersection) {
        return intersection == null || intersection.isEmpty();
    }
}

