/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.UrlDescriptor;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;

public class SvnBranchPointsCalculator {
    private static final Logger LOG = Logger.getInstance(SvnBranchPointsCalculator.class);
    @NotNull
    private final SmallMapSerializer<Url, TreeMap<String, BranchCopyData>> myPersistentMap;
    @NotNull
    private final Object myPersistenceLock = new Object();
    @NotNull
    private final SvnVcs myVcs;

    public SvnBranchPointsCalculator(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        File directory = new File(new File(PathManager.getSystemPath(), "vcs"), "svn_copy_sources");
        directory.mkdirs();
        File file = new File(directory, this.myVcs.getProject().getLocationHash());
        this.myPersistentMap = new SmallMapSerializer<Url, TreeMap<String, BranchCopyData>>(file, UrlDescriptor.DECODED_URL_DESCRIPTOR, new BranchDataExternalizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WrapperInvertor getBestHit(@NotNull Url repoUrl, @NotNull Url sourceUrl, @NotNull Url targetUrl) {
        Object object = this.myPersistenceLock;
        synchronized (object) {
            WrapperInvertor result = null;
            TreeMap<String, BranchCopyData> map = this.myPersistentMap.get(repoUrl);
            if (map != null) {
                BranchCopyData sourceData = SvnBranchPointsCalculator.getBranchData(map, sourceUrl);
                BranchCopyData targetData = SvnBranchPointsCalculator.getBranchData(map, targetUrl);
                if (sourceData != null && targetData != null) {
                    boolean inverted = sourceData.getTargetRevision() > targetData.getTargetRevision();
                    result = new WrapperInvertor(inverted, inverted ? sourceData : targetData);
                } else if (sourceData != null) {
                    result = new WrapperInvertor(true, sourceData);
                } else if (targetData != null) {
                    result = new WrapperInvertor(false, targetData);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.myPersistenceLock;
        synchronized (object) {
            this.myPersistentMap.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(@NotNull Url repoUrl, @NotNull BranchCopyData data) {
        Object object = this.myPersistenceLock;
        synchronized (object) {
            TreeMap map = this.myPersistentMap.get(repoUrl);
            if (map == null) {
                map = ContainerUtil.newTreeMap();
            }
            map.put(data.getTarget().toString(), data);
            this.myPersistentMap.put(repoUrl, map);
            this.myPersistentMap.force();
        }
    }

    @Nullable
    private static BranchCopyData getBranchData(@NotNull NavigableMap<String, BranchCopyData> map, @NotNull Url url) {
        Map.Entry<String, BranchCopyData> branchData = map.floorEntry(url.toString());
        return branchData != null && url.toString().startsWith(branchData.getKey()) ? branchData.getValue() : null;
    }

    @Nullable
    public WrapperInvertor calculateCopyPoint(@NotNull Url repoUrl, @NotNull Url sourceUrl, @NotNull Url targetUrl) throws VcsException {
        CopyData copyData;
        WrapperInvertor result = this.getBestHit(repoUrl, sourceUrl, targetUrl);
        if (result == null && (copyData = new FirstInBranch(this.myVcs, repoUrl, targetUrl, sourceUrl).run()) != null) {
            BranchCopyData branchCopyData = copyData.isTrunkSupposedCorrect() ? new BranchCopyData(sourceUrl, copyData.getCopySourceRevision(), targetUrl, copyData.getCopyTargetRevision()) : new BranchCopyData(targetUrl, copyData.getCopySourceRevision(), sourceUrl, copyData.getCopyTargetRevision());
            this.persist(repoUrl, branchCopyData);
            result = new WrapperInvertor(!copyData.isTrunkSupposedCorrect(), branchCopyData);
        }
        SvnBranchPointsCalculator.logCopyData(repoUrl, sourceUrl, targetUrl, result);
        return result;
    }

    private static void logCopyData(@NotNull Url repoUrl, @NotNull Url sourceUrl, @NotNull Url targetUrl, @Nullable WrapperInvertor inverter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("repoURL: " + repoUrl.toDecodedString() + ", sourceUrl:" + sourceUrl.toDecodedString() + ", targetUrl: " + targetUrl.toDecodedString() + ", inverter: " + inverter);
        }
    }

    public static class BranchCopyData {
        @NotNull
        private final Url mySource;
        @NotNull
        private final Url myTarget;
        private final long mySourceRevision;
        private final long myTargetRevision;

        public BranchCopyData(@NotNull Url source, long sourceRevision, @NotNull Url target, long targetRevision) {
            this.mySource = source;
            this.mySourceRevision = sourceRevision;
            this.myTarget = target;
            this.myTargetRevision = targetRevision;
        }

        public String toString() {
            return "source: " + this.mySource + "@" + this.mySourceRevision + " target: " + this.myTarget + "@" + this.myTargetRevision;
        }

        @NotNull
        public Url getSource() {
            return this.mySource;
        }

        public long getSourceRevision() {
            return this.mySourceRevision;
        }

        @NotNull
        public Url getTarget() {
            return this.myTarget;
        }

        public long getTargetRevision() {
            return this.myTargetRevision;
        }

        public BranchCopyData invertSelf() {
            return new BranchCopyData(this.myTarget, this.myTargetRevision, this.mySource, this.mySourceRevision);
        }
    }

    public static class WrapperInvertor {
        private final BranchCopyData myWrapped;
        private final boolean myInvertedSense;

        public WrapperInvertor(boolean invertedSense, BranchCopyData wrapped) {
            this.myInvertedSense = invertedSense;
            this.myWrapped = wrapped;
        }

        public boolean isInvertedSense() {
            return this.myInvertedSense;
        }

        public BranchCopyData getWrapped() {
            return this.myWrapped;
        }

        public BranchCopyData getTrue() {
            return this.myInvertedSense ? this.myWrapped.invertSelf() : this.myWrapped;
        }

        public BranchCopyData inverted() {
            return this.myWrapped.invertSelf();
        }

        public String toString() {
            return "inverted: " + this.myInvertedSense + " wrapped: " + this.myWrapped.toString();
        }
    }

    private static class BranchDataExternalizer
    implements DataExternalizer<TreeMap<String, BranchCopyData>> {
        private BranchDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull TreeMap<String, BranchCopyData> value) throws IOException {
            out.writeInt(value.size());
            for (Map.Entry<String, BranchCopyData> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                BranchDataExternalizer.save(out, entry.getValue());
            }
        }

        private static void save(@NotNull DataOutput out, @NotNull BranchCopyData value) throws IOException {
            UrlDescriptor.ENCODED_URL_DESCRIPTOR.save(out, value.getSource());
            UrlDescriptor.ENCODED_URL_DESCRIPTOR.save(out, value.getTarget());
            out.writeLong(value.getSourceRevision());
            out.writeLong(value.getTargetRevision());
        }

        @NotNull
        public TreeMap<String, BranchCopyData> read(@NotNull DataInput in) throws IOException {
            TreeMap result = ContainerUtil.newTreeMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result.put(in.readUTF(), BranchDataExternalizer.readCopyPoint(in));
            }
            return result;
        }

        @NotNull
        private static BranchCopyData readCopyPoint(@NotNull DataInput in) throws IOException {
            Url source = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read(in);
            Url target = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read(in);
            long sourceRevision = in.readLong();
            long targetRevision = in.readLong();
            return new BranchCopyData(source, sourceRevision, target, targetRevision);
        }
    }
}

