/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.rollback.ChangesAfterPathComparator;
import org.jetbrains.idea.svn.rollback.ChangesChecker;
import org.jetbrains.idea.svn.rollback.Reverter;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public String getRollbackOperationName() {
        return SvnBundle.message("action.name.revert", new Object[0]);
    }

    public void rollbackChanges(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        listener2.indeterminate();
        for (Map.Entry entry : SvnUtil.splitChangesIntoWc(this.mySvnVcs, changes).entrySet()) {
            List sortedChanges = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), (Comparator)ChangesAfterPathComparator.getInstance());
            this.rollbackGroupForWc(sortedChanges, exceptions, listener2);
        }
    }

    private void rollbackGroupForWc(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        UnversionedAndNotTouchedFilesGroupCollector collector = new UnversionedAndNotTouchedFilesGroupCollector();
        ChangesChecker checker2 = new ChangesChecker(this.mySvnVcs, collector);
        checker2.gather(changes);
        exceptions.addAll(checker2.getExceptions());
        Reverter reverter = new Reverter(this.mySvnVcs, listener2, exceptions);
        reverter.moveRenamesToTmp(collector);
        reverter.revert(checker2.getForAdds(), true);
        reverter.revert(checker2.getForDeletes(), true);
        reverter.revert(checker2.getForEdits(), false);
        reverter.moveGroup();
        for (Couple<File> pair : collector.getToBeDeleted()) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> filePaths, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        for (FilePath filePath : filePaths) {
            listener2.accept(filePath);
            try {
                this.revertFileOrDir(filePath);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    private void revertFileOrDir(@NotNull FilePath filePath) throws VcsException {
        File file = filePath.getIOFile();
        Info info2 = this.mySvnVcs.getInfo(file);
        if (info2 != null) {
            if (info2.isFile()) {
                this.doRevert(file, false);
            } else if ("add".equals(info2.getSchedule()) || this.mySvnVcs.getWorkingCopyFormat(file).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
                this.doRevert(file, true);
            } else {
                this.mySvnVcs.getFactory(file).createUpdateClient().doUpdate(file, Revision.HEAD, Depth.INFINITY, false, false);
            }
        } else {
            throw new VcsException("Can not get 'svn info' for " + file.getPath());
        }
    }

    private void doRevert(@NotNull File path, boolean recursive) throws VcsException {
        this.mySvnVcs.getFactory(path).createRevertClient().revert(Collections.singletonList(path), Depth.allOrFiles(recursive), null);
    }

    public static boolean isMoveRenameReplace(@NotNull Change c) {
        if (c.getAfterRevision() == null || c.getBeforeRevision() == null) {
            return false;
        }
        return c.isIsReplaced() || c.isMoved() || c.isRenamed() || !Comparing.equal((Object)c.getBeforeRevision().getFile(), (Object)c.getAfterRevision().getFile());
    }
}

