/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class CCorePlugin
extends Plugin {
    private static CCorePlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.core.CCorePluginResources");
        }
        catch (MissingResourceException x) {
            fgResourceBundle = null;
        }
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
        catch (NullPointerException e) {
            return "#" + key + "#";
        }
    }

    public static CCorePlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(Throwable e) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            if (status.getException() != null) {
                CCorePlugin.log(status);
            } else {
                CCorePlugin.log(CCorePlugin.createStatus("Error", e));
            }
        } else {
            String msg = e.getMessage();
            if (msg == null) {
                CCorePlugin.log("Error", e);
            } else {
                CCorePlugin.log("Error: " + msg, e);
            }
        }
    }

    public static void log(String message, Throwable e) {
        Throwable nestedException;
        if (e instanceof CModelException && (nestedException = ((CModelException)((Object)e)).getException()) != null) {
            e = nestedException;
        }
        CCorePlugin.log(CCorePlugin.createStatus(message, e));
    }

    public static IStatus createStatus(String msg, Throwable e) {
        return new Status(4, "org.eclipse.cdt.core", msg, e);
    }

    public static void log(IStatus status) {
        CCorePlugin.getDefault().getLog().log(status);
    }
}

