/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.Serializable;
import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.internal.core.Messages;

public class Addr32
implements Serializable,
IAddress {
    public static final Addr32 ZERO = new Addr32(0L);
    public static final Addr32 MAX = new Addr32(0xFFFFFFFFL);
    public static final BigInteger MAX_OFFSET = BigInteger.valueOf(0xFFFFFFFFL);
    private final long address;

    public Addr32(byte[] addrBytes) {
        if (addrBytes.length != 4) {
            throw new NumberFormatException("Invalid address array");
        }
        this.address = ((long)addrBytes[0] << 24 & 0xFF000000L) + ((long)addrBytes[1] << 16 & 0xFF0000L) + ((long)addrBytes[2] << 8 & 0xFF00L) + ((long)addrBytes[3] & 0xFFL);
    }

    public Addr32(long rawaddress) {
        this(rawaddress, true);
    }

    public Addr32(long rawaddress, boolean truncate) {
        if (rawaddress > 0xFFFFFFFFL || rawaddress < 0L) {
            if (truncate) {
                rawaddress &= 0xFFFFFFFFL;
            } else {
                throw new NumberFormatException(Messages.Addr_valueOutOfRange);
            }
        }
        this.address = rawaddress;
    }
}

