/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.Serializable;
import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.internal.core.Messages;

public class Addr64
implements Serializable,
IAddress {
    public static final Addr64 ZERO = new Addr64("0");
    public static final Addr64 MAX = new Addr64("ffffffffffffffff", 16);
    public static final BigInteger MAX_OFFSET = new BigInteger("ffffffffffffffff", 16);
    private final BigInteger address;

    public Addr64(byte[] addrBytes) {
        this.address = this.checkAddress(new BigInteger(1, addrBytes), true);
    }

    public Addr64(BigInteger rawaddress, boolean truncate) {
        this.address = this.checkAddress(rawaddress, truncate);
    }

    public Addr64(String addr) {
        this(addr, true);
    }

    public Addr64(String addr, boolean truncate) {
        addr = addr.toLowerCase();
        this.address = addr.startsWith("0x") ? this.checkAddress(new BigInteger(addr.substring(2), 16), truncate) : this.checkAddress(new BigInteger(addr, 10), truncate);
    }

    public Addr64(String addr, int radix) {
        this(addr, radix, true);
    }

    public Addr64(String addr, int radix, boolean truncate) {
        this(new BigInteger(addr, radix), truncate);
    }

    private BigInteger checkAddress(BigInteger addr, boolean truncate) {
        if (addr.signum() == -1) {
            throw new IllegalArgumentException("Invalid Address, must be positive value");
        }
        if (addr.bitLength() > 64) {
            if (truncate) {
                return addr.and(MAX.getValue());
            }
            throw new NumberFormatException(Messages.Addr_valueOutOfRange);
        }
        return addr;
    }

    public BigInteger getValue() {
        return this.address;
    }
}

