/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class PE {
    public static final String NL = System.getProperty("line.separator", "\n");
    RandomAccessFile rfile;
    String filename;
    DOSHeader dosHeader;
    Coff.FileHeader fileHeader;
    Coff.SectionHeader[] scnhdrs;
    byte[] stringTable;

    public Coff.SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            RandomAccessFile accessFile = this.getRandomAccessFile();
            this.scnhdrs = new Coff.SectionHeader[this.fileHeader.f_nscns];
            long offset = 0L;
            if (this.dosHeader != null) {
                offset = this.dosHeader.e_lfanew + 4;
            }
            offset += (long)(20 + this.fileHeader.f_opthdr);
            int i = 0;
            while (i < this.scnhdrs.length) {
                this.scnhdrs[i] = new Coff.SectionHeader(accessFile, offset);
                ++i;
                offset += 40L;
            }
        }
        return this.scnhdrs;
    }

    public byte[] getStringTable() throws IOException {
        if (this.stringTable == null) {
            if (this.fileHeader.f_nsyms > 0) {
                RandomAccessFile accessFile = this.getRandomAccessFile();
                long symbolsize = 18 * this.fileHeader.f_nsyms;
                long offset = (long)this.fileHeader.f_symptr + symbolsize;
                accessFile.seek(offset);
                byte[] bytes = new byte[4];
                accessFile.readFully(bytes);
                int str_len = ReadMemoryAccess.getIntLE(bytes);
                if (str_len > 4 && (long)str_len < accessFile.length()) {
                    this.stringTable = new byte[str_len -= 4];
                    accessFile.seek(offset + 4L);
                    accessFile.readFully(this.stringTable);
                } else {
                    this.stringTable = new byte[0];
                }
            } else {
                this.stringTable = new byte[0];
            }
        }
        return this.stringTable;
    }

    RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.rfile == null) {
            this.rfile = new RandomAccessFile(this.filename, "r");
        }
        return this.rfile;
    }

    public String getStringTableEntry(int offset) throws IOException {
        byte[] bytes = this.getStringTable();
        int i = offset -= 4;
        while (i < bytes.length) {
            if (bytes[i] == 0) {
                return new String(bytes, offset, i - offset);
            }
            ++i;
        }
        return "";
    }

    public static class DOSHeader {
        int e_lfanew;
    }
}

