/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import sun.misc.SharedSecrets;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstructorAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.scope.ConstructorScope;

public final class Constructor<T>
extends Executable {
    private Class<T> clazz;
    private int slot;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient ConstructorRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private volatile ConstructorAccessor constructorAccessor;
    private Constructor<T> root;

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ConstructorScope.make(this));
    }

    @Override
    ConstructorRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = ConstructorRepository.make(this.getSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    @Override
    Executable getRoot() {
        return this.root;
    }

    Constructor(Class<T> clazz, Class<?>[] classArray, Class<?>[] classArray2, int n, int n2, String string, byte[] byArray, byte[] byArray2) {
        this.clazz = clazz;
        this.parameterTypes = classArray;
        this.exceptionTypes = classArray2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string;
        this.annotations = byArray;
        this.parameterAnnotations = byArray2;
    }

    Constructor<T> copy() {
        if (this.root != null) {
            throw new IllegalArgumentException("Can not copy a non-root Constructor");
        }
        Constructor<T> constructor = new Constructor<T>(this.clazz, this.parameterTypes, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations);
        constructor.root = this;
        constructor.constructorAccessor = this.constructorAccessor;
        return constructor;
    }

    @Override
    boolean hasGenericInformation() {
        return this.getSignature() != null;
    }

    @Override
    byte[] getAnnotationBytes() {
        return this.annotations;
    }

    public Class<T> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        if (this.getSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return super.getGenericParameterTypes();
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return super.getGenericExceptionTypes();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Constructor) {
            Constructor constructor = (Constructor)object;
            if (this.getDeclaringClass() == constructor.getDeclaringClass()) {
                return this.equalParamTypes(this.parameterTypes, constructor.parameterTypes);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        return this.sharedToString(Modifier.constructorModifiers(), false, this.parameterTypes, this.exceptionTypes);
    }

    @Override
    void specificToStringHeader(StringBuilder stringBuilder) {
        stringBuilder.append(this.getDeclaringClass().getTypeName());
    }

    @Override
    public String toGenericString() {
        return this.sharedToGenericString(Modifier.constructorModifiers(), false);
    }

    @Override
    void specificToGenericStringHeader(StringBuilder stringBuilder) {
        this.specificToStringHeader(stringBuilder);
    }

    @CallerSensitive
    public T newInstance(Object ... objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object;
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            object = Reflection.getCallerClass();
            this.checkAccess((Class<?>)object, this.clazz, null, this.modifiers);
        }
        if ((this.clazz.getModifiers() & 0x4000) != 0) {
            throw new IllegalArgumentException("Cannot reflectively create enum objects");
        }
        object = this.constructorAccessor;
        if (object == null) {
            object = this.acquireConstructorAccessor();
        }
        Object object2 = object.newInstance(objectArray);
        return (T)object2;
    }

    @Override
    public boolean isVarArgs() {
        return super.isVarArgs();
    }

    @Override
    public boolean isSynthetic() {
        return super.isSynthetic();
    }

    private ConstructorAccessor acquireConstructorAccessor() {
        ConstructorAccessor constructorAccessor = null;
        if (this.root != null) {
            constructorAccessor = this.root.getConstructorAccessor();
        }
        if (constructorAccessor != null) {
            this.constructorAccessor = constructorAccessor;
        } else {
            constructorAccessor = reflectionFactory.newConstructorAccessor(this);
            this.setConstructorAccessor(constructorAccessor);
        }
        return constructorAccessor;
    }

    ConstructorAccessor getConstructorAccessor() {
        return this.constructorAccessor;
    }

    void setConstructorAccessor(ConstructorAccessor constructorAccessor) {
        this.constructorAccessor = constructorAccessor;
        if (this.root != null) {
            this.root.setConstructorAccessor(constructorAccessor);
        }
    }

    int getSlot() {
        return this.slot;
    }

    String getSignature() {
        return this.signature;
    }

    byte[] getRawAnnotations() {
        return this.annotations;
    }

    byte[] getRawParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return super.getAnnotation(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return super.getDeclaredAnnotations();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.sharedGetParameterAnnotations(this.parameterTypes, this.parameterAnnotations);
    }

    @Override
    boolean handleParameterNumberMismatch(int n, int n2) {
        Class<T> clazz = this.getDeclaringClass();
        if (clazz.isEnum() || clazz.isAnonymousClass() || clazz.isLocalClass()) {
            return false;
        }
        if (clazz.isMemberClass() && (clazz.getModifiers() & 8) == 0 && n + 1 == n2) {
            return true;
        }
        throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
    }

    @Override
    public AnnotatedType getAnnotatedReturnType() {
        return this.getAnnotatedReturnType0(this.getDeclaringClass());
    }

    @Override
    public AnnotatedType getAnnotatedReceiverType() {
        if (this.getDeclaringClass().getEnclosingClass() == null) {
            return super.getAnnotatedReceiverType();
        }
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getDeclaringClass().getEnclosingClass(), TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
    }
}

