/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Objects;
import sun.misc.SharedSecrets;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.repository.ConstructorRepository;

public abstract class Executable
extends AccessibleObject
implements Member,
GenericDeclaration {
    private volatile transient boolean hasRealParameterData;
    private volatile transient Parameter[] parameters;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    Executable() {
    }

    abstract byte[] getAnnotationBytes();

    abstract Executable getRoot();

    abstract boolean hasGenericInformation();

    abstract ConstructorRepository getGenericInfo();

    boolean equalParamTypes(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length == classArray2.length) {
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == classArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    Annotation[][] parseParameterAnnotations(byte[] byArray) {
        return AnnotationParser.parseParameterAnnotations(byArray, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
    }

    void separateWithCommas(Class<?>[] classArray, StringBuilder stringBuilder) {
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(classArray[i].getTypeName());
            if (i >= classArray.length - 1) continue;
            stringBuilder.append(",");
        }
    }

    void printModifiersIfNonzero(StringBuilder stringBuilder, int n, boolean bl) {
        int n2 = this.getModifiers() & n;
        if (n2 != 0 && !bl) {
            stringBuilder.append(Modifier.toString(n2)).append(' ');
        } else {
            int n3 = n2 & 7;
            if (n3 != 0) {
                stringBuilder.append(Modifier.toString(n3)).append(' ');
            }
            if (bl) {
                stringBuilder.append("default ");
            }
            if ((n2 &= 0xFFFFFFF8) != 0) {
                stringBuilder.append(Modifier.toString(n2)).append(' ');
            }
        }
    }

    String sharedToString(int n, boolean bl, Class<?>[] classArray, Class<?>[] classArray2) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.printModifiersIfNonzero(stringBuilder, n, bl);
            this.specificToStringHeader(stringBuilder);
            stringBuilder.append('(');
            this.separateWithCommas(classArray, stringBuilder);
            stringBuilder.append(')');
            if (classArray2.length > 0) {
                stringBuilder.append(" throws ");
                this.separateWithCommas(classArray2, stringBuilder);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    abstract void specificToStringHeader(StringBuilder var1);

    String sharedToGenericString(int n, boolean bl) {
        try {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            this.printModifiersIfNonzero(stringBuilder, n, bl);
            TypeVariable<?>[] typeVariableArray = this.getTypeParameters();
            if (typeVariableArray.length > 0) {
                boolean bl2 = true;
                stringBuilder.append('<');
                TypeVariable<?>[] typeVariableArray2 = typeVariableArray;
                n2 = typeVariableArray2.length;
                for (int i = 0; i < n2; ++i) {
                    TypeVariable<?> typeVariable = typeVariableArray2[i];
                    if (!bl2) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(typeVariable.toString());
                    bl2 = false;
                }
                stringBuilder.append("> ");
            }
            this.specificToGenericStringHeader(stringBuilder);
            stringBuilder.append('(');
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                String string = typeArray[i].getTypeName();
                if (this.isVarArgs() && i == typeArray.length - 1) {
                    string = string.replaceFirst("\\[\\]$", "...");
                }
                stringBuilder.append(string);
                if (i >= typeArray.length - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (n2 = 0; n2 < typeArray2.length; ++n2) {
                    stringBuilder.append(typeArray2[n2] instanceof Class ? ((Class)typeArray2[n2]).getName() : typeArray2[n2].toString());
                    if (n2 >= typeArray2.length - 1) continue;
                    stringBuilder.append(',');
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    abstract void specificToGenericStringHeader(StringBuilder var1);

    @Override
    public abstract Class<?> getDeclaringClass();

    @Override
    public abstract String getName();

    @Override
    public abstract int getModifiers();

    @Override
    public abstract TypeVariable<?>[] getTypeParameters();

    public abstract Class<?>[] getParameterTypes();

    public int getParameterCount() {
        throw new AbstractMethodError();
    }

    public Type[] getGenericParameterTypes() {
        if (this.hasGenericInformation()) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    Type[] getAllGenericParameterTypes() {
        boolean bl = this.hasGenericInformation();
        if (!bl) {
            return this.getParameterTypes();
        }
        boolean bl2 = this.hasRealParameterData();
        Type[] typeArray = this.getGenericParameterTypes();
        Class<?>[] classArray = this.getParameterTypes();
        Type[] typeArray2 = new Type[classArray.length];
        Parameter[] parameterArray = this.getParameters();
        int n = 0;
        if (bl2) {
            for (int i = 0; i < typeArray2.length; ++i) {
                Parameter parameter = parameterArray[i];
                if (parameter.isSynthetic() || parameter.isImplicit()) {
                    typeArray2[i] = classArray[i];
                    continue;
                }
                typeArray2[i] = typeArray[n];
                ++n;
            }
        } else {
            return typeArray.length == classArray.length ? typeArray : classArray;
        }
        return typeArray2;
    }

    public Parameter[] getParameters() {
        return (Parameter[])this.privateGetParameters().clone();
    }

    private Parameter[] synthesizeAllParams() {
        int n = this.getParameterCount();
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = new Parameter("arg" + i, 0, this, i);
        }
        return parameterArray;
    }

    private void verifyParameters(Parameter[] parameterArray) {
        if (this.getParameterTypes().length != parameterArray.length) {
            throw new MalformedParametersException("Wrong number of parameters in MethodParameters attribute");
        }
        for (Parameter parameter : parameterArray) {
            String string = parameter.getRealName();
            int n = parameter.getModifiers();
            if (string != null && (string.isEmpty() || string.indexOf(46) != -1 || string.indexOf(59) != -1 || string.indexOf(91) != -1 || string.indexOf(47) != -1)) {
                throw new MalformedParametersException("Invalid parameter name \"" + string + "\"");
            }
            if (n == (n & 0x9010)) continue;
            throw new MalformedParametersException("Invalid parameter modifiers");
        }
    }

    private Parameter[] privateGetParameters() {
        Parameter[] parameterArray = this.parameters;
        if (parameterArray == null) {
            try {
                parameterArray = this.getParameters0();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedParametersException("Invalid constant pool index");
            }
            if (parameterArray == null) {
                this.hasRealParameterData = false;
                parameterArray = this.synthesizeAllParams();
            } else {
                this.hasRealParameterData = true;
                this.verifyParameters(parameterArray);
            }
            this.parameters = parameterArray;
        }
        return parameterArray;
    }

    boolean hasRealParameterData() {
        if (this.parameters == null) {
            this.privateGetParameters();
        }
        return this.hasRealParameterData;
    }

    private native Parameter[] getParameters0();

    native byte[] getTypeAnnotationBytes0();

    byte[] getTypeAnnotationBytes() {
        return this.getTypeAnnotationBytes0();
    }

    public abstract Class<?>[] getExceptionTypes();

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.hasGenericInformation() && (typeArray = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public abstract String toGenericString();

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public abstract Annotation[][] getParameterAnnotations();

    Annotation[][] sharedGetParameterAnnotations(Class<?>[] classArray, byte[] byArray) {
        int n = classArray.length;
        if (byArray == null) {
            return new Annotation[n][0];
        }
        Annotation[][] annotationArray = this.parseParameterAnnotations(byArray);
        if (annotationArray.length != n && this.handleParameterNumberMismatch(annotationArray.length, n)) {
            Annotation[][] annotationArrayArray = new Annotation[annotationArray.length + 1][];
            System.arraycopy(annotationArray, 0, annotationArrayArray, 1, annotationArray.length);
            annotationArrayArray[0] = new Annotation[0];
            annotationArray = annotationArrayArray;
        }
        return annotationArray;
    }

    abstract boolean handleParameterNumberMismatch(int var1, int var2);

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)((Annotation)clazz.cast(this.declaredAnnotations().get(clazz)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            Executable executable = this.getRoot();
            this.declaredAnnotations = executable != null ? executable.declaredAnnotations() : AnnotationParser.parseAnnotations(this.getAnnotationBytes(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    public abstract AnnotatedType getAnnotatedReturnType();

    AnnotatedType getAnnotatedReturnType0(Type type) {
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), type, TypeAnnotation.TypeAnnotationTarget.METHOD_RETURN);
    }

    public AnnotatedType getAnnotatedReceiverType() {
        if (Modifier.isStatic(this.getModifiers())) {
            return null;
        }
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getDeclaringClass(), TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
    }

    public AnnotatedType[] getAnnotatedParameterTypes() {
        return TypeAnnotationParser.buildAnnotatedTypes(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getAllGenericParameterTypes(), TypeAnnotation.TypeAnnotationTarget.METHOD_FORMAL_PARAMETER);
    }

    public AnnotatedType[] getAnnotatedExceptionTypes() {
        return TypeAnnotationParser.buildAnnotatedTypes(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getGenericExceptionTypes(), TypeAnnotation.TypeAnnotationTarget.THROWS);
    }
}

