/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.awt.AppContext;
import sun.swing.DefaultLookup;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    private static BasicCursor textCursor = new BasicCursor(2);
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();
    private static final TransferHandler defaultTransferHandler = new TextTransferHandler();
    private final DragListener dragListener = BasicTextUI.getDragListener();
    private static final Position.Bias[] discardBias = new Position.Bias[1];
    private DefaultCaret dropCaret;

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(string, keymap2);
            String string2 = this.getPropertyPrefix();
            Object object = DefaultLookup.get(this.editor, this, string2 + ".keyBindings");
            if (object != null && object instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])object;
                JTextComponent.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.updateBackground((JTextComponent)propertyChangeEvent.getSource());
        }
    }

    private void updateBackground(JTextComponent jTextComponent) {
        if (this instanceof SynthUI || jTextComponent instanceof JTextArea) {
            return;
        }
        Color color = jTextComponent.getBackground();
        if (color instanceof UIResource) {
            String string = this.getPropertyPrefix();
            Color color2 = DefaultLookup.getColor(jTextComponent, this, string + ".disabledBackground", null);
            Color color3 = DefaultLookup.getColor(jTextComponent, this, string + ".inactiveBackground", null);
            Color color4 = DefaultLookup.getColor(jTextComponent, this, string + ".background", null);
            if ((jTextComponent instanceof JTextArea || jTextComponent instanceof JEditorPane) && color != color2 && color != color3 && color != color4) {
                return;
            }
            Color color5 = null;
            if (!jTextComponent.isEnabled()) {
                color5 = color2;
            }
            if (color5 == null && !jTextComponent.isEditable()) {
                color5 = color3;
            }
            if (color5 == null) {
                color5 = color4;
            }
            if (color5 != null && color5 != color) {
                jTextComponent.setBackground(color5);
            }
        }
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
        Insets insets;
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        String string = this.getPropertyPrefix();
        Font font = this.editor.getFont();
        if (font == null || font instanceof UIResource) {
            this.editor.setFont(UIManager.getFont(string + ".font"));
        }
        if ((color6 = this.editor.getBackground()) == null || color6 instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(string + ".background"));
        }
        if ((color5 = this.editor.getForeground()) == null || color5 instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(string + ".foreground"));
        }
        if ((color4 = this.editor.getCaretColor()) == null || color4 instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(string + ".caretForeground"));
        }
        if ((color3 = this.editor.getSelectionColor()) == null || color3 instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(string + ".selectionBackground"));
        }
        if ((color2 = this.editor.getSelectedTextColor()) == null || color2 instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(string + ".selectionForeground"));
        }
        if ((color = this.editor.getDisabledTextColor()) == null || color instanceof UIResource) {
            this.editor.setDisabledTextColor(UIManager.getColor(string + ".inactiveForeground"));
        }
        if ((border = this.editor.getBorder()) == null || border instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(string + ".border"));
        }
        if ((insets = this.editor.getMargin()) == null || insets instanceof UIResource) {
            this.editor.setMargin(UIManager.getInsets(string + ".margin"));
        }
        this.updateCursor();
    }

    private void installDefaults2() {
        TransferHandler transferHandler;
        Highlighter highlighter;
        this.editor.addMouseListener(this.dragListener);
        this.editor.addMouseMotionListener(this.dragListener);
        String string = this.getPropertyPrefix();
        Caret caret = this.editor.getCaret();
        if (caret == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.editor.setCaret(caret);
            int n = DefaultLookup.getInt(this.getComponent(), this, string + ".caretBlinkRate", 500);
            caret.setBlinkRate(n);
        }
        if ((highlighter = this.editor.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.editor.setHighlighter(this.createHighlighter());
        }
        if ((transferHandler = this.editor.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.editor.setTransferHandler(this.getTransferHandler());
        }
    }

    protected void uninstallDefaults() {
        this.editor.removeMouseListener(this.dragListener);
        this.editor.removeMouseMotionListener(this.dragListener);
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
        if (this.editor.getTransferHandler() instanceof UIResource) {
            this.editor.setTransferHandler(null);
        }
        if (this.editor.getCursor() instanceof UIResource) {
            this.editor.setCursor(null);
        }
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        this.editor.setKeymap(this.createKeymap());
        InputMap inputMap = this.getInputMap();
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    InputMap getInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)DefaultLookup.get(this.editor, this, this.getPropertyPrefix() + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        return inputMapUIResource;
    }

    void updateFocusAcceleratorBinding(boolean bl) {
        char c = this.editor.getFocusAccelerator();
        if (bl || c != '\u0000') {
            InputMap inputMap = SwingUtilities.getUIInputMap(this.editor, 2);
            if (inputMap == null && c != '\u0000') {
                inputMap = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, inputMap);
                ActionMap actionMap = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, actionMap);
            }
            if (inputMap != null) {
                inputMap.clear();
                if (c != '\u0000') {
                    inputMap.put(KeyStroke.getKeyStroke((int)c, BasicLookAndFeel.getFocusAcceleratorKeyMask()), "requestFocus");
                }
            }
        }
    }

    void updateFocusTraversalKeys() {
        EditorKit editorKit = this.getEditorKit(this.editor);
        if (editorKit != null && editorKit instanceof DefaultEditorKit) {
            Set<AWTKeyStroke> set = this.editor.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> set2 = this.editor.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
            HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(set2);
            if (this.editor.isEditable()) {
                hashSet.remove(KeyStroke.getKeyStroke(9, 0));
                hashSet2.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                hashSet.add(KeyStroke.getKeyStroke(9, 0));
                hashSet2.add(KeyStroke.getKeyStroke(9, 1));
            }
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysForward", hashSet);
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysBackward", hashSet2);
        }
    }

    private void updateCursor() {
        if (!this.editor.isCursorSet() || this.editor.getCursor() instanceof UIResource) {
            BasicCursor basicCursor = this.editor.isEditable() ? textCursor : null;
            this.editor.setCursor(basicCursor);
        }
    }

    TransferHandler getTransferHandler() {
        return defaultTransferHandler;
    }

    ActionMap getActionMap() {
        Action action;
        String string = this.getPropertyPrefix() + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        if (this.getEditorKit(this.editor) instanceof DefaultEditorKit && actionMap != null && (action = actionMap.get("insert-break")) != null && action instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper textActionWrapper = new TextActionWrapper((TextAction)action);
            actionMapUIResource.put(textActionWrapper.getValue("Name"), textActionWrapper);
        }
        if (actionMap != null) {
            actionMapUIResource.setParent(actionMap);
        }
        return actionMapUIResource;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        for (Action action : this.editor.getActions()) {
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.editor.getBackground());
        graphics.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.painted = false;
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected void paintSafely(Graphics graphics) {
        Rectangle rectangle;
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (this.editor.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        if ((rectangle = this.getVisibleEditorRect()) != null) {
            this.rootView.paint(graphics, rectangle);
        }
        if (caret != null) {
            caret.paint(graphics);
        }
        if (this.dropCaret != null) {
            this.dropCaret.paint(graphics);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            LookAndFeel.installProperty(this.editor, "opaque", Boolean.TRUE);
            LookAndFeel.installProperty(this.editor, "autoscrolls", Boolean.TRUE);
            this.installDefaults();
            this.installDefaults2();
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners();
            this.installKeyboardActions();
            LayoutManager layoutManager = this.editor.getLayout();
            if (layoutManager == null || layoutManager instanceof UIResource) {
                this.editor.setLayout(this.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
        this.updateBackground(this.editor);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        jComponent.removeAll();
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager instanceof UIResource) {
            jComponent.setLayout(null);
        }
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.editor = null;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paint(Graphics graphics, JComponent jComponent) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.paintSafely(graphics);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            } else if (dimension.width == 0 && dimension.height == 0) {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            dimension.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = this.editor.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    @Override
    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    @Override
    @Deprecated
    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        return (Rectangle)this.modelToView(jTextComponent, n, bias, false);
    }

    @Override
    public Rectangle2D modelToView2D(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        return this.modelToView(jTextComponent, n, bias, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle2D modelToView(JTextComponent jTextComponent, int n, Position.Bias bias, boolean bl) throws BadLocationException {
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n, rectangle, bias);
                if (shape != null) {
                    Rectangle2D rectangle2D = bl ? shape.getBounds2D() : shape.getBounds();
                    return rectangle2D;
                }
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, discardBias);
    }

    @Override
    @Deprecated
    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        return this.viewToModel(jTextComponent, point.x, point.y, biasArray);
    }

    @Override
    public int viewToModel2D(JTextComponent jTextComponent, Point2D point2D, Position.Bias[] biasArray) {
        return this.viewToModel(jTextComponent, (float)point2D.getX(), (float)point2D.getY(), biasArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int viewToModel(JTextComponent jTextComponent, float f, float f2, Position.Bias[] biasArray) {
        int n = -1;
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n = this.rootView.viewToModel(f, f2, rectangle, biasArray);
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (this.painted) {
                Rectangle rectangle = this.getVisibleEditorRect();
                if (rectangle != null) {
                    this.rootView.setSize(rectangle.width, rectangle.height);
                }
                int n3 = this.rootView.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
                return n3;
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return -1;
    }

    @Override
    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        Rectangle rectangle;
        if (this.painted && (rectangle = this.getVisibleEditorRect()) != null) {
            Document document = jTextComponent.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n, bias, n2, bias2, rectangle);
                Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.editor.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
    }

    @Override
    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    @Override
    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipText(JTextComponent jTextComponent, Point point) {
        if (!this.painted) {
            return null;
        }
        Document document = this.editor.getDocument();
        String string = null;
        Rectangle rectangle = this.getVisibleEditorRect();
        if (rectangle != null) {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                string = this.rootView.getToolTipText(point.x, point.y, rectangle);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
        return string;
    }

    @Override
    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DragListener getDragListener() {
        Class<DragListener> clazz = DragListener.class;
        synchronized (DragListener.class) {
            DragListener dragListener = (DragListener)AppContext.getAppContext().get(DragListener.class);
            if (dragListener == null) {
                dragListener = new DragListener();
                AppContext.getAppContext().put(DragListener.class, dragListener);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return dragListener;
        }
    }

    static class TextTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;
        private boolean modeBetween = false;
        private boolean isDrop = false;
        private int dropAction = 2;
        private Position.Bias dropBias;

        TextTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    String string = dataFlavorArray[i].getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                        return dataFlavorArray[i];
                    }
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavorArray[i];
                        continue;
                    }
                    if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == String.class) {
                        dataFlavor2 = dataFlavorArray[i];
                        continue;
                    }
                    if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                    dataFlavor3 = dataFlavorArray[i];
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                String string = dataFlavorArray[i].getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavorArray[i];
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == String.class) {
                    dataFlavor2 = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i];
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
            if (bl) {
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                int n3 = n2 - n;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n3 > 0) {
                    document.remove(n, n3);
                }
                editorKit.read(reader, document, n);
            } else {
                int n;
                char[] cArray = new char[1024];
                boolean bl2 = false;
                StringBuffer stringBuffer = null;
                while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n);
                    }
                    int n4 = 0;
                    block5: for (int i = 0; i < n; ++i) {
                        switch (cArray[i]) {
                            case '\r': {
                                if (bl2) {
                                    if (i == 0) {
                                        stringBuffer.append('\n');
                                        continue block5;
                                    }
                                    cArray[i - 1] = 10;
                                    continue block5;
                                }
                                bl2 = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!bl2) continue block5;
                                if (i > n4 + 1) {
                                    stringBuffer.append(cArray, n4, i - n4 - 1);
                                }
                                bl2 = false;
                                n4 = i;
                                continue block5;
                            }
                            default: {
                                if (!bl2) continue block5;
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i - 1] = 10;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (n4 >= n) continue;
                    if (bl2) {
                        if (n4 >= n - 1) continue;
                        stringBuffer.append(cArray, n4, n - n4 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n4, n - n4);
                }
                if (bl2) {
                    stringBuffer.append('\n');
                }
                jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
            }
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            if (jComponent instanceof JPasswordField && jComponent.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                return 0;
            }
            return ((JTextComponent)jComponent).isEditable() ? 3 : 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            this.exportComp = (JTextComponent)jComponent;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (this.shouldRemove && n == 2) {
                TextTransferable textTransferable = (TextTransferable)transferable;
                textTransferable.removeText();
            }
            this.exportComp = null;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            this.isDrop = transferSupport.isDrop();
            if (this.isDrop) {
                this.modeBetween = ((JTextComponent)transferSupport.getComponent()).getDropMode() == DropMode.INSERT;
                this.dropBias = ((JTextComponent.DropLocation)transferSupport.getDropLocation()).getBias();
                this.dropAction = transferSupport.getDropAction();
            }
            try {
                boolean bl = super.importData(transferSupport);
                return bl;
            }
            finally {
                this.isDrop = false;
                this.modeBetween = false;
                this.dropBias = null;
                this.dropAction = 2;
            }
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            int n;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            int n2 = n = this.modeBetween ? jTextComponent.getDropLocation().getIndex() : jTextComponent.getCaretPosition();
            if (this.dropAction == 2 && jTextComponent == this.exportComp && n >= this.p0 && n <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean bl = false;
            DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
            if (dataFlavor != null) {
                try {
                    Caret caret;
                    Object object;
                    boolean bl2 = false;
                    if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl2 = true;
                    }
                    if ((object = jTextComponent.getInputContext()) != null) {
                        ((InputContext)object).endComposition();
                    }
                    Reader reader = dataFlavor.getReaderForText(transferable);
                    if (this.modeBetween) {
                        caret = jTextComponent.getCaret();
                        if (caret instanceof DefaultCaret) {
                            ((DefaultCaret)caret).setDot(n, this.dropBias);
                        } else {
                            jTextComponent.setCaretPosition(n);
                        }
                    }
                    this.handleReaderImport(reader, jTextComponent, bl2);
                    if (this.isDrop) {
                        jTextComponent.requestFocus();
                        caret = jTextComponent.getCaret();
                        if (caret instanceof DefaultCaret) {
                            int n3 = caret.getDot();
                            Position.Bias bias = ((DefaultCaret)caret).getDotBias();
                            ((DefaultCaret)caret).setDot(n, this.dropBias);
                            ((DefaultCaret)caret).moveDot(n3, bias);
                        } else {
                            jTextComponent.select(n, jTextComponent.getCaretPosition());
                        }
                    }
                    bl = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl;
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
        }

        static class TextTransferable
        extends BasicTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            TextTransferable(JTextComponent jTextComponent, int n, int n2) {
                super(null, null);
                this.c = jTextComponent;
                Document document = jTextComponent.getDocument();
                try {
                    this.p0 = document.createPosition(n);
                    this.p1 = document.createPosition(n2);
                    this.plainData = jTextComponent.getSelectedText();
                    if (jTextComponent instanceof JEditorPane) {
                        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                        this.mimeType = jEditorPane.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith("text/html")) {
                            this.htmlData = stringWriter.toString();
                        } else {
                            this.richText = stringWriter.toString();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document document = this.c.getDocument();
                        document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            @Override
            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return dataFlavorArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            @Override
            protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return this.richText;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
    }

    static class DragListener
    extends MouseInputAdapter
    implements DragRecognitionSupport.BeforeDrag {
        private boolean dragStarted;

        DragListener() {
        }

        @Override
        public void dragStarting(MouseEvent mouseEvent) {
            this.dragStarted = true;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.getDragEnabled()) {
                this.dragStarted = false;
                if (this.isDragPossible(mouseEvent) && DragRecognitionSupport.mousePressed(mouseEvent)) {
                    mouseEvent.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.getDragEnabled()) {
                if (this.dragStarted) {
                    mouseEvent.consume();
                }
                DragRecognitionSupport.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.getDragEnabled() && (this.dragStarted || DragRecognitionSupport.mouseDragged(mouseEvent, this))) {
                mouseEvent.consume();
            }
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            int n;
            Caret caret;
            int n2;
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.isEnabled() && (n2 = (caret = jTextComponent.getCaret()).getDot()) != (n = caret.getMark())) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n3 = jTextComponent.viewToModel(point);
                int n4 = Math.min(n2, n);
                int n5 = Math.max(n2, n);
                if (n3 >= n4 && n3 < n5) {
                    return true;
                }
            }
            return false;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTextUI.this.editor.requestFocus();
        }

        @Override
        public boolean isEnabled() {
            return BasicTextUI.this.editor.isEditable();
        }
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public TextActionWrapper(TextAction textAction) {
            super((String)textAction.getValue("Name"));
            this.action = null;
            this.action = textAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }

        @Override
        public boolean isEnabled() {
            return BasicTextUI.this.editor == null || BasicTextUI.this.editor.isEditable() ? this.action.isEnabled() : false;
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable<Component, Object> constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                    this.i18nView = false;
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                    if ("document" == string) {
                        BasicTextUI.this.setView(null);
                        BasicTextUI.this.propertyChange(propertyChangeEvent);
                        BasicTextUI.this.modelChanged();
                        return;
                    }
                }
                BasicTextUI.this.modelChanged();
            }
            if ("focusAccelerator" == string) {
                BasicTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation" == string) {
                BasicTextUI.this.modelChanged();
            } else if ("font" == string) {
                BasicTextUI.this.modelChanged();
            } else if ("dropLocation" == string) {
                this.dropIndexChanged();
            } else if ("editable" == string) {
                BasicTextUI.this.updateCursor();
                BasicTextUI.this.modelChanged();
            }
            if (string.equals("graphicsConfiguration")) {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = object != null ? ((GraphicsConfiguration)object).getDefaultTransform() : new AffineTransform();
                AffineTransform affineTransform3 = affineTransform = object2 != null ? ((GraphicsConfiguration)object2).getDefaultTransform() : new AffineTransform();
                if (affineTransform2.getScaleX() != affineTransform.getScaleX() || affineTransform2.getScaleY() != affineTransform.getScaleY()) {
                    this.forwardPreferenceChangeToView(BasicTextUI.this.rootView);
                }
            }
            BasicTextUI.this.propertyChange(propertyChangeEvent);
        }

        private void forwardPreferenceChangeToView(View view) {
            if (view.getViewCount() == 0) {
                view.preferenceChanged(null, true, true);
                return;
            }
            for (int i = 0; i < view.getViewCount(); ++i) {
                this.forwardPreferenceChangeToView(view.getView(i));
            }
        }

        private void dropIndexChanged() {
            if (BasicTextUI.this.editor.getDropMode() == DropMode.USE_SELECTION) {
                return;
            }
            JTextComponent.DropLocation dropLocation = BasicTextUI.this.editor.getDropLocation();
            if (dropLocation == null) {
                if (BasicTextUI.this.dropCaret != null) {
                    BasicTextUI.this.dropCaret.deinstall(BasicTextUI.this.editor);
                    BasicTextUI.this.editor.repaint(BasicTextUI.this.dropCaret);
                    BasicTextUI.this.dropCaret = null;
                }
            } else {
                if (BasicTextUI.this.dropCaret == null) {
                    BasicTextUI.this.dropCaret = new BasicCaret();
                    BasicTextUI.this.dropCaret.install(BasicTextUI.this.editor);
                    BasicTextUI.this.dropCaret.setVisible(true);
                }
                BasicTextUI.this.dropCaret.setDot(dropLocation.getIndex(), dropLocation.getBias());
            }
        }

        @Override
        public final void insertUpdate(DocumentEvent documentEvent) {
            Boolean bl;
            Document document = documentEvent.getDocument();
            Object object = document.getProperty("i18n");
            if (object instanceof Boolean && (bl = (Boolean)object) != this.i18nView) {
                this.i18nView = bl;
                BasicTextUI.this.modelChanged();
                return;
            }
            bl = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.insertUpdate(documentEvent, (Shape)((Object)bl), BasicTextUI.this.rootView.getViewFactory());
        }

        @Override
        public final void removeUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.removeUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        @Override
        public final void changedUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.changedUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (this.constraints != null) {
                this.constraints.remove(component);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Rectangle rectangle;
            if (this.constraints != null && !this.constraints.isEmpty() && (rectangle = BasicTextUI.this.getVisibleEditorRect()) != null) {
                Document document = BasicTextUI.this.editor.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                try {
                    BasicTextUI.this.rootView.setSize(rectangle.width, rectangle.height);
                    Enumeration<Component> enumeration = this.constraints.keys();
                    while (enumeration.hasMoreElements()) {
                        Component component = enumeration.nextElement();
                        View view = (View)this.constraints.get(component);
                        Shape shape = this.calculateViewPosition(rectangle, view);
                        if (shape == null) continue;
                        Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                        component.setBounds(rectangle2);
                    }
                }
                finally {
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                }
            }
        }

        Shape calculateViewPosition(Shape shape, View view) {
            int n = view.getStartOffset();
            View view2 = null;
            View view3 = BasicTextUI.this.rootView;
            while (view3 != null && view3 != view) {
                int n2 = ((View)view3).getViewIndex(n, Position.Bias.Forward);
                shape = ((View)view3).getChildAllocation(n2, shape);
                view2 = ((View)view3).getView(n2);
                view3 = view2;
            }
            return view2 != null ? shape : null;
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            if (object instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(component, object);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View view) {
            View view2 = this.view;
            this.view = null;
            if (view2 != null) {
                view2.setParent(null);
            }
            if (view != null) {
                view.setParent(this);
            }
            this.view = view;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        @Override
        public float getMinimumSpan(int n) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n);
            }
            return 10.0f;
        }

        @Override
        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            BasicTextUI.this.editor.revalidate();
        }

        @Override
        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        @Override
        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public int getViewIndex(int n, Position.Bias bias) {
            return 0;
        }

        @Override
        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        @Override
        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            return -1;
        }

        @Override
        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (n < -1) {
                throw new BadLocationException("invalid position", n);
            }
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        @Override
        public Document getDocument() {
            return BasicTextUI.this.editor.getDocument();
        }

        @Override
        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        @Override
        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BasicTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int n, float f, Shape shape) {
            throw new Error("Can't break root view");
        }

        @Override
        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        @Override
        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        @Override
        public Container getContainer() {
            return BasicTextUI.this.editor;
        }

        @Override
        public ViewFactory getViewFactory() {
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.editor);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return BasicTextUI.this;
        }
    }

    static class BasicCursor
    extends Cursor
    implements UIResource {
        BasicCursor(int n) {
            super(n);
        }

        BasicCursor(String string) {
            super(string);
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

