/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import sun.util.logging.PlatformLogger;

public class WindowStateMachine {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.WindowStateMachine");
    private static WindowStateMachine machine = new WindowStateMachine();
    private Map<WindowInfo, State> waitingWindows = new LinkedHashMap<WindowInfo, State>();

    public static WindowStateMachine get() {
        return machine;
    }

    public void waitForNotifyAfterRaise(Long l) {
        focusLog.finer("Window: " + Long.toHexString(l), new Throwable());
        this.waitingWindows.put(new WindowInfo(l, System.nanoTime()), State.RAISED_AND_WAITING_FOR_MAP_NOTIFY);
    }

    public void waitForNotifyAfterMap(Long l) {
        this.waitingWindows.put(new WindowInfo(l, System.nanoTime()), State.MAPPED_AND_WAITING_FOR_MAP_NOTIFY);
    }

    public void notify(Long l) {
        List<WindowInfo> list = this.waitingWindows.entrySet().stream().filter(entry -> ((WindowInfo)entry.getKey()).id == l).map(Map.Entry::getKey).collect(Collectors.toList());
        focusLog.finer("Remove " + list.size() + "windows");
        list.forEach(windowInfo -> this.waitingWindows.remove(windowInfo));
    }

    public boolean isWaitingForWindowShow() {
        double d = 3.0E9;
        List<WindowInfo> list = this.waitingWindows.entrySet().stream().filter(entry -> {
            long l = System.nanoTime() - ((WindowInfo)entry.getKey()).time;
            focusLog.finer("Window has been kept " + l);
            return (double)l > d;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        focusLog.finer("Remove " + list.size() + "windows by timout");
        list.forEach(windowInfo -> this.waitingWindows.remove(windowInfo));
        return !this.waitingWindows.isEmpty();
    }

    public void clear() {
        this.waitingWindows.clear();
    }

    public String toString() {
        return "Window state machine: " + this.waitingWindows.entrySet().stream().collect(StringBuilder::new, (stringBuilder, entry) -> stringBuilder.append(Long.toHexString(((WindowInfo)entry.getKey()).id)).append(" : ").append(entry.getValue()).append("; "), StringBuilder::append);
    }

    class WindowInfo {
        private long id;
        private long time;

        public WindowInfo(long l, long l2) {
            this.id = l;
            this.time = l2;
        }
    }

    private static enum State {
        RAISED_AND_WAITING_FOR_MAP_NOTIFY,
        MAPPED_AND_WAITING_FOR_MAP_NOTIFY;

    }
}

