/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sun.awt.datatransfer.ClassLoaderObjectInputStream;
import sun.awt.datatransfer.ClassLoaderObjectOutputStream;

public class TransferableProxy
implements Transferable {
    protected final Transferable transferable;
    protected final boolean isLocal;

    public TransferableProxy(Transferable transferable, boolean bl) {
        this.transferable = transferable;
        this.isLocal = bl;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.transferable.getTransferDataFlavors();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.transferable.isDataFlavorSupported(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Object object = this.transferable.getTransferData(dataFlavor);
        if (object != null && this.isLocal && dataFlavor.isFlavorSerializedObjectType()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ClassLoaderObjectOutputStream classLoaderObjectOutputStream = new ClassLoaderObjectOutputStream(byteArrayOutputStream);
            classLoaderObjectOutputStream.writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            try {
                ClassLoaderObjectInputStream classLoaderObjectInputStream = new ClassLoaderObjectInputStream(byteArrayInputStream, classLoaderObjectOutputStream.getClassLoaderMap());
                object = classLoaderObjectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException().initCause(classNotFoundException);
            }
        }
        return object;
    }

    public Transferable getDelegate() {
        return this.transferable;
    }
}

