/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.font.CreatedFontTracker;
import sun.font.FileFontStrike;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;
import sun.font.SunFontManager;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public abstract class FileFont
extends PhysicalFont {
    protected boolean useJavaRasterizer = true;
    protected int fileSize;
    protected FontScaler scaler;
    protected boolean checkedNatives;
    protected boolean useNatives;
    protected NativeFont[] nativeFonts;
    protected char[] glyphToCharMap;

    FileFont(String string, Object object) throws FontFormatException {
        super(string, object);
    }

    @Override
    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (!this.checkedNatives) {
            this.checkUseNatives();
        }
        return new FileFontStrike(this, fontStrikeDesc);
    }

    protected boolean checkUseNatives() {
        this.checkedNatives = true;
        return this.useNatives;
    }

    protected abstract void close();

    byte getSupportedCharset() {
        return 1;
    }

    abstract ByteBuffer readBlock(int var1, int var2);

    @Override
    public boolean canDoStyle(int n) {
        return true;
    }

    void setFileToRemove(File file, CreatedFontTracker createdFontTracker) {
        Disposer.addObjectRecord(this, new CreatedFontFileDisposerRecord(file, createdFontTracker));
    }

    static void setFileToRemove(Object object, File file, CreatedFontTracker createdFontTracker) {
        Disposer.addObjectRecord(object, new CreatedFontFileDisposerRecord(file, createdFontTracker));
    }

    synchronized void deregisterFontAndClearStrikeCache() {
        SunFontManager sunFontManager = SunFontManager.getInstance();
        sunFontManager.deRegisterBadFont(this);
        for (Reference reference : this.strikeCache.values()) {
            FileFontStrike fileFontStrike;
            if (reference == null || (fileFontStrike = (FileFontStrike)reference.get()) == null || fileFontStrike.pScalerContext == 0L) continue;
            this.scaler.invalidateScalerContext(fileFontStrike.pScalerContext);
        }
        if (this.scaler != null) {
            this.scaler.dispose();
        }
        this.scaler = FontScaler.getNullScaler();
    }

    @Override
    StrikeMetrics getFontMetrics(long l) {
        try {
            return this.getScaler().getFontMetrics(l);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getFontMetrics(l);
        }
    }

    @Override
    float getGlyphAdvance(long l, int n) {
        try {
            return this.getScaler().getGlyphAdvance(l, n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphAdvance(l, n);
        }
    }

    @Override
    void getGlyphMetrics(long l, int n, Point2D.Float float_) {
        try {
            this.getScaler().getGlyphMetrics(l, n, float_);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            this.getGlyphMetrics(l, n, float_);
        }
    }

    @Override
    long getGlyphImage(long l, int n) {
        try {
            return this.getScaler().getGlyphImage(l, n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphImage(l, n);
        }
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(long l, int n) {
        try {
            return this.getScaler().getGlyphOutlineBounds(l, n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphOutlineBounds(l, n);
        }
    }

    @Override
    GeneralPath getGlyphOutline(long l, int n, float f, float f2) {
        try {
            return this.getScaler().getGlyphOutline(l, n, f, f2);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphOutline(l, n, f, f2);
        }
    }

    @Override
    GeneralPath getGlyphVectorOutline(long l, int[] nArray, int n, float f, float f2) {
        try {
            return this.getScaler().getGlyphVectorOutline(l, nArray, n, f, f2);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphVectorOutline(l, nArray, n, f, f2);
        }
    }

    protected abstract FontScaler getScaler();

    @Override
    protected long getUnitsPerEm() {
        return this.getScaler().getUnitsPerEm();
    }

    protected String getPublicFileName() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return this.platName;
        }
        boolean bl = true;
        try {
            securityManager.checkPropertyAccess("java.io.tmpdir");
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        if (bl) {
            return this.platName;
        }
        final File file = new File(this.platName);
        Boolean bl2 = Boolean.FALSE;
        try {
            bl2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    File file2 = new File(System.getProperty("java.io.tmpdir"));
                    try {
                        String string = file2.getCanonicalPath();
                        String string2 = file.getCanonicalPath();
                        return string2 == null || string2.startsWith(string);
                    }
                    catch (IOException iOException) {
                        return Boolean.TRUE;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            bl2 = Boolean.TRUE;
        }
        return bl2 != false ? "temp file" : this.platName;
    }

    private static class CreatedFontFileDisposerRecord
    implements DisposerRecord {
        File fontFile = null;
        CreatedFontTracker tracker;

        private CreatedFontFileDisposerRecord(File file, CreatedFontTracker createdFontTracker) {
            this.fontFile = file;
            this.tracker = createdFontTracker;
        }

        @Override
        public void dispose() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (fontFile != null) {
                        try {
                            if (tracker != null) {
                                tracker.subBytes((int)fontFile.length());
                            }
                            fontFile.delete();
                            SunFontManager.getInstance().tmpFontFiles.remove(fontFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
    }
}

