/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontScalerException;
import sun.font.NullFontScaler;
import sun.font.StrikeMetrics;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public abstract class FontScaler
implements DisposerRecord {
    private static FontScaler nullScaler = null;
    private static Constructor<FontScaler> scalerConstructor = null;
    protected WeakReference<Font2D> font = null;
    protected long nativeScaler = 0L;
    protected boolean disposed = false;

    public static FontScaler getScaler(Font2D font2D, int n, boolean bl, int n2) {
        FontScaler fontScaler = null;
        try {
            Object[] objectArray = new Object[]{font2D, n, bl, n2};
            fontScaler = scalerConstructor.newInstance(objectArray);
            Disposer.addObjectRecord(font2D, fontScaler);
        }
        catch (Throwable throwable) {
            fontScaler = nullScaler;
            FontManager fontManager = FontManagerFactory.getInstance();
            fontManager.deRegisterBadFont(font2D);
        }
        return fontScaler;
    }

    public static synchronized FontScaler getNullScaler() {
        if (nullScaler == null) {
            nullScaler = new NullFontScaler();
        }
        return nullScaler;
    }

    abstract StrikeMetrics getFontMetrics(long var1) throws FontScalerException;

    abstract float getGlyphAdvance(long var1, int var3) throws FontScalerException;

    abstract void getGlyphMetrics(long var1, int var3, Point2D.Float var4) throws FontScalerException;

    abstract long getGlyphImage(long var1, int var3) throws FontScalerException;

    abstract Rectangle2D.Float getGlyphOutlineBounds(long var1, int var3) throws FontScalerException;

    abstract GeneralPath getGlyphOutline(long var1, int var3, float var4, float var5) throws FontScalerException;

    abstract GeneralPath getGlyphVectorOutline(long var1, int[] var3, int var4, float var5, float var6) throws FontScalerException;

    @Override
    public void dispose() {
    }

    abstract int getNumGlyphs() throws FontScalerException;

    abstract int getMissingGlyphCode() throws FontScalerException;

    abstract int getGlyphCode(char var1) throws FontScalerException;

    abstract long getLayoutTableCache() throws FontScalerException;

    abstract Point2D.Float getGlyphPoint(long var1, int var3, int var4) throws FontScalerException;

    abstract long getUnitsPerEm();

    abstract long createScalerContext(double[] var1, int var2, int var3, float var4, float var5, boolean var6);

    abstract void invalidateScalerContext(long var1);

    static {
        Class<Object> clazz = null;
        Class[] classArray = new Class[]{Font2D.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE};
        try {
            clazz = Class.forName("sun.font.FreetypeFontScaler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = NullFontScaler.class;
        }
        try {
            scalerConstructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

