/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;

public class ScaledBlit
extends GraphicsPrimitive {
    public static final String methodSignature = "ScaledBlit(...)".toString();
    public static final int primTypeID = ScaledBlit.makePrimTypeID();
    private static RenderCache blitcache = new RenderCache(20);

    public static ScaledBlit locate(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return (ScaledBlit)GraphicsPrimitiveMgr.locate(primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public static ScaledBlit getFromCache(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        Object object = blitcache.get(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            return (ScaledBlit)object;
        }
        ScaledBlit scaledBlit = ScaledBlit.locate(surfaceType, compositeType, surfaceType2);
        if (scaledBlit != null) {
            blitcache.put(surfaceType, compositeType, surfaceType2, scaledBlit);
        }
        return scaledBlit;
    }

    protected ScaledBlit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public ScaledBlit(long l, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(l, methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public native void Scale(SurfaceData var1, SurfaceData var2, Composite var3, Region var4, int var5, int var6, int var7, int var8, double var9, double var11, double var13, double var15);

    @Override
    public GraphicsPrimitive makePrimitive(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return null;
    }

    @Override
    public GraphicsPrimitive traceWrap() {
        return new TraceScaledBlit(this);
    }

    static {
        GraphicsPrimitiveMgr.registerGeneral(new ScaledBlit(null, null, null));
    }

    private static class TraceScaledBlit
    extends ScaledBlit {
        ScaledBlit target;

        public TraceScaledBlit(ScaledBlit scaledBlit) {
            super(scaledBlit.getSourceType(), scaledBlit.getCompositeType(), scaledBlit.getDestType());
            this.target = scaledBlit;
        }

        @Override
        public GraphicsPrimitive traceWrap() {
            return this;
        }

        @Override
        public void Scale(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4) {
            if ((traceflags & 8) == 0) {
                TraceScaledBlit.tracePrimitive(this.target);
            }
            long l = System.nanoTime();
            this.target.Scale(surfaceData, surfaceData2, composite, region, n, n2, n3, n4, d, d2, d3, d4);
            TraceScaledBlit.tracePrimitiveTime(this.target, System.nanoTime() - l);
        }
    }
}

