/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.awt.geom.PathConsumer2D;

final class CollinearSimplifier
implements PathConsumer2D {
    private static final int STATE_PREV_LINE = 0;
    private static final int STATE_PREV_POINT = 1;
    private static final int STATE_EMPTY = 2;
    private static final float EPS = 0.001f;
    private PathConsumer2D delegate;
    private int state;
    private float px1;
    private float py1;
    private float pdx;
    private float pdy;
    private float px2;
    private float py2;

    CollinearSimplifier() {
    }

    public CollinearSimplifier init(PathConsumer2D pathConsumer2D) {
        this.delegate = pathConsumer2D;
        this.state = 2;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.delegate.pathDone();
        this.state = 2;
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.delegate.closePath();
        this.state = 2;
    }

    @Override
    public long getNativeConsumer() {
        return 0L;
    }

    @Override
    public void quadTo(float f, float f2, float f3, float f4) {
        this.emitStashedLine();
        this.delegate.quadTo(f, f2, f3, f4);
        this.state = 1;
        this.px1 = f3;
        this.py1 = f4;
    }

    @Override
    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.emitStashedLine();
        this.delegate.curveTo(f, f2, f3, f4, f5, f6);
        this.state = 1;
        this.px1 = f5;
        this.py1 = f6;
    }

    @Override
    public void moveTo(float f, float f2) {
        this.emitStashedLine();
        this.delegate.moveTo(f, f2);
        this.state = 1;
        this.px1 = f;
        this.py1 = f2;
    }

    @Override
    public void lineTo(float f, float f2) {
        if (this.state == 0) {
            float f3 = f - this.px2;
            float f4 = f2 - this.py2;
            if (f4 == 0.0f && this.pdy == 0.0f && this.pdx * f3 >= 0.0f || this.pdy * f4 != 0.0f && this.pdx * f4 - this.pdy * f3 == 0.0f) {
                this.px2 = f;
                this.py2 = f2;
            } else {
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.pdx = f3;
                this.pdy = f4;
                this.px2 = f;
                this.py2 = f2;
            }
        } else if (this.state == 1) {
            this.state = 0;
            this.pdx = f - this.px1;
            this.pdy = f2 - this.py1;
            this.px2 = f;
            this.py2 = f2;
        } else if (this.state == 2) {
            this.delegate.lineTo(f, f2);
            this.state = 1;
            this.px1 = f;
            this.py1 = f2;
        }
    }

    private void emitStashedLine() {
        if (this.state == 0) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }
}

