/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.DPathConsumer2D;

final class DCollinearSimplifier
implements DPathConsumer2D {
    private static final int STATE_PREV_LINE = 0;
    private static final int STATE_PREV_POINT = 1;
    private static final int STATE_EMPTY = 2;
    private static final double EPS = 0.001;
    private DPathConsumer2D delegate;
    private int state;
    private double px1;
    private double py1;
    private double pdx;
    private double pdy;
    private double px2;
    private double py2;

    DCollinearSimplifier() {
    }

    public DCollinearSimplifier init(DPathConsumer2D dPathConsumer2D) {
        this.delegate = dPathConsumer2D;
        this.state = 2;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.delegate.pathDone();
        this.state = 2;
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.delegate.closePath();
        this.state = 2;
    }

    @Override
    public long getNativeConsumer() {
        return 0L;
    }

    @Override
    public void quadTo(double d, double d2, double d3, double d4) {
        this.emitStashedLine();
        this.delegate.quadTo(d, d2, d3, d4);
        this.state = 1;
        this.px1 = d3;
        this.py1 = d4;
    }

    @Override
    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.emitStashedLine();
        this.delegate.curveTo(d, d2, d3, d4, d5, d6);
        this.state = 1;
        this.px1 = d5;
        this.py1 = d6;
    }

    @Override
    public void moveTo(double d, double d2) {
        this.emitStashedLine();
        this.delegate.moveTo(d, d2);
        this.state = 1;
        this.px1 = d;
        this.py1 = d2;
    }

    @Override
    public void lineTo(double d, double d2) {
        if (this.state == 0) {
            double d3 = d - this.px2;
            double d4 = d2 - this.py2;
            if (d4 == 0.0 && this.pdy == 0.0 && this.pdx * d3 >= 0.0 || this.pdy * d4 != 0.0 && this.pdx * d4 - this.pdy * d3 == 0.0) {
                this.px2 = d;
                this.py2 = d2;
            } else {
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.pdx = d3;
                this.pdy = d4;
                this.px2 = d;
                this.py2 = d2;
            }
        } else if (this.state == 1) {
            this.state = 0;
            this.pdx = d - this.px1;
            this.pdy = d2 - this.py1;
            this.px2 = d;
            this.py2 = d2;
        } else if (this.state == 2) {
            this.delegate.lineTo(d, d2);
            this.state = 1;
            this.px1 = d;
            this.py1 = d2;
        }
    }

    private void emitStashedLine() {
        if (this.state == 0) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }
}

