/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.ReentrantContextProvider;
import sun.java2d.ReentrantContextProviderCLQ;
import sun.java2d.ReentrantContextProviderTL;
import sun.java2d.marlin.DPathConsumer2D;
import sun.java2d.marlin.DRenderer;
import sun.java2d.marlin.DRendererContext;
import sun.java2d.marlin.DTransformingPathConsumer2D;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinProperties;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.Version;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.security.action.GetPropertyAction;

public final class DMarlinRenderingEngine
extends RenderingEngine
implements MarlinConst {
    static final boolean DISABLE_2ND_STROKER_CLIPPING = true;
    static final boolean DO_TRACE_PATH = false;
    static final boolean DO_CLIP;
    static final boolean DO_CLIP_FILL = true;
    static final boolean DO_CLIP_RUNTIME_ENABLE;
    private static final float MIN_PEN_SIZE;
    static final double UPPER_BND = 1.7014117331926443E38;
    static final double LOWER_BND = -1.7014117331926443E38;
    private static final boolean USE_THREAD_LOCAL;
    static final int REF_TYPE;
    private static final ReentrantContextProvider<DRendererContext> RDR_CTX_PROVIDER;
    private static boolean SETTINGS_LOGGED;

    public DMarlinRenderingEngine() {
        DMarlinRenderingEngine.logSettings(DMarlinRenderingEngine.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape createStrokedShape(Shape shape, float f, int n, int n2, float f2, float[] fArray, float f3) {
        DRendererContext dRendererContext = DMarlinRenderingEngine.getRendererContext();
        try {
            Path2D.Double double_ = dRendererContext.getPath2D();
            this.strokeTo(dRendererContext, shape, null, f, NormMode.OFF, n, n2, f2, fArray, f3, dRendererContext.transformerPC2D.wrapPath2D(double_));
            Path2D.Double double_2 = new Path2D.Double(double_);
            return double_2;
        }
        finally {
            DMarlinRenderingEngine.returnRendererContext(dRendererContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void strokeTo(Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, boolean bl3, PathConsumer2D pathConsumer2D) {
        NormMode normMode = bl2 ? (bl3 ? NormMode.ON_WITH_AA : NormMode.ON_NO_AA) : NormMode.OFF;
        DRendererContext dRendererContext = DMarlinRenderingEngine.getRendererContext();
        try {
            this.strokeTo(dRendererContext, shape, affineTransform, basicStroke, bl, normMode, bl3, dRendererContext.p2dAdapter.init(pathConsumer2D));
        }
        finally {
            DMarlinRenderingEngine.returnRendererContext(dRendererContext);
        }
    }

    void strokeTo(DRendererContext dRendererContext, Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, NormMode normMode, boolean bl2, DPathConsumer2D dPathConsumer2D) {
        double d = bl ? (bl2 ? this.userSpaceLineWidth(affineTransform, MIN_PEN_SIZE) : this.userSpaceLineWidth(affineTransform, 1.0)) : (double)basicStroke.getLineWidth();
        this.strokeTo(dRendererContext, shape, affineTransform, d, normMode, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase(), dPathConsumer2D);
    }

    private double userSpaceLineWidth(AffineTransform affineTransform, double d) {
        double d2;
        if (affineTransform == null) {
            d2 = 1.0;
        } else if ((affineTransform.getType() & 0x24) != 0) {
            d2 = Math.sqrt(affineTransform.getDeterminant());
        } else {
            double d3 = affineTransform.getScaleX();
            double d4 = affineTransform.getShearX();
            double d5 = affineTransform.getShearY();
            double d6 = affineTransform.getScaleY();
            double d7 = d3 * d3 + d5 * d5;
            double d8 = 2.0 * (d3 * d4 + d5 * d6);
            double d9 = d4 * d4 + d6 * d6;
            double d10 = Math.sqrt(d8 * d8 + (d7 - d9) * (d7 - d9));
            double d11 = (d7 + d9 + d10) / 2.0;
            d2 = Math.sqrt(d11);
        }
        return d / d2;
    }

    void strokeTo(DRendererContext dRendererContext, Shape shape, AffineTransform affineTransform, double d, NormMode normMode, int n, int n2, float f, float[] fArray, float f2, DPathConsumer2D dPathConsumer2D) {
        AffineTransform affineTransform2 = null;
        int n3 = -1;
        boolean bl = false;
        double[] dArray = null;
        if (fArray != null) {
            bl = true;
            n3 = fArray.length;
            dArray = dRendererContext.dasher.copyDashArray(fArray);
        }
        if (affineTransform != null && !affineTransform.isIdentity()) {
            double d2 = affineTransform.getScaleX();
            double d3 = affineTransform.getShearX();
            double d4 = affineTransform.getShearY();
            double d5 = affineTransform.getScaleY();
            double d6 = d2 * d5 - d4 * d3;
            if (Math.abs(d6) <= 9.9E-324) {
                dPathConsumer2D.moveTo(0.0, 0.0);
                dPathConsumer2D.pathDone();
                return;
            }
            if (DMarlinRenderingEngine.nearZero(d2 * d3 + d4 * d5) && DMarlinRenderingEngine.nearZero(d2 * d2 + d4 * d4 - (d3 * d3 + d5 * d5))) {
                double d7 = Math.sqrt(d2 * d2 + d4 * d4);
                if (dArray != null) {
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5 = n4++;
                        dArray[n5] = dArray[n5] * d7;
                    }
                    f2 = (float)((double)f2 * d7);
                }
                d *= d7;
            } else {
                affineTransform2 = affineTransform;
            }
        } else {
            affineTransform = null;
        }
        DTransformingPathConsumer2D dTransformingPathConsumer2D = dRendererContext.transformerPC2D;
        if (USE_SIMPLIFIER) {
            dPathConsumer2D = dRendererContext.simplifier.init(dPathConsumer2D);
        }
        dPathConsumer2D = dTransformingPathConsumer2D.deltaTransformConsumer(dPathConsumer2D, affineTransform2);
        dPathConsumer2D = dRendererContext.stroker.init(dPathConsumer2D, d, n, n2, f, dArray == null);
        dRendererContext.monotonizer.init(d);
        if (dArray != null) {
            dPathConsumer2D = dRendererContext.dasher.init(dPathConsumer2D, dArray, n3, f2, bl);
            dRendererContext.stroker.disableClipping();
        } else if (dRendererContext.doClip && n != 0) {
            dPathConsumer2D = dTransformingPathConsumer2D.detectClosedPath(dPathConsumer2D);
        }
        dPathConsumer2D = dTransformingPathConsumer2D.inverseDeltaTransformConsumer(dPathConsumer2D, affineTransform2);
        PathIterator pathIterator = normMode.getNormalizingPathIterator(dRendererContext, shape.getPathIterator(affineTransform));
        DMarlinRenderingEngine.pathTo(dRendererContext, pathIterator, dPathConsumer2D);
    }

    private static boolean nearZero(double d) {
        return Math.abs(d) < 2.0 * Math.ulp(d);
    }

    private static void pathTo(DRendererContext dRendererContext, PathIterator pathIterator, DPathConsumer2D dPathConsumer2D) {
        if (USE_PATH_SIMPLIFIER) {
            dPathConsumer2D = dRendererContext.pathSimplifier.init(dPathConsumer2D);
        }
        dRendererContext.dirty = true;
        DMarlinRenderingEngine.pathToLoop(dRendererContext.double6, pathIterator, dPathConsumer2D);
        dRendererContext.dirty = false;
    }

    private static void pathToLoop(double[] dArray, PathIterator pathIterator, DPathConsumer2D dPathConsumer2D) {
        boolean bl = false;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    if (!(dArray[0] < 1.7014117331926443E38) || !(dArray[0] > -1.7014117331926443E38) || !(dArray[1] < 1.7014117331926443E38) || !(dArray[1] > -1.7014117331926443E38)) break;
                    dPathConsumer2D.moveTo(dArray[0], dArray[1]);
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(dArray[0] < 1.7014117331926443E38) || !(dArray[0] > -1.7014117331926443E38) || !(dArray[1] < 1.7014117331926443E38) || !(dArray[1] > -1.7014117331926443E38)) break;
                    if (bl) {
                        dPathConsumer2D.lineTo(dArray[0], dArray[1]);
                        break;
                    }
                    dPathConsumer2D.moveTo(dArray[0], dArray[1]);
                    bl = true;
                    break;
                }
                case 2: {
                    if (!(dArray[2] < 1.7014117331926443E38) || !(dArray[2] > -1.7014117331926443E38) || !(dArray[3] < 1.7014117331926443E38) || !(dArray[3] > -1.7014117331926443E38)) break;
                    if (bl) {
                        if (dArray[0] < 1.7014117331926443E38 && dArray[0] > -1.7014117331926443E38 && dArray[1] < 1.7014117331926443E38 && dArray[1] > -1.7014117331926443E38) {
                            dPathConsumer2D.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                            break;
                        }
                        dPathConsumer2D.lineTo(dArray[2], dArray[3]);
                        break;
                    }
                    dPathConsumer2D.moveTo(dArray[2], dArray[3]);
                    bl = true;
                    break;
                }
                case 3: {
                    if (!(dArray[4] < 1.7014117331926443E38) || !(dArray[4] > -1.7014117331926443E38) || !(dArray[5] < 1.7014117331926443E38) || !(dArray[5] > -1.7014117331926443E38)) break;
                    if (bl) {
                        if (dArray[0] < 1.7014117331926443E38 && dArray[0] > -1.7014117331926443E38 && dArray[1] < 1.7014117331926443E38 && dArray[1] > -1.7014117331926443E38 && dArray[2] < 1.7014117331926443E38 && dArray[2] > -1.7014117331926443E38 && dArray[3] < 1.7014117331926443E38 && dArray[3] > -1.7014117331926443E38) {
                            dPathConsumer2D.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                            break;
                        }
                        dPathConsumer2D.lineTo(dArray[4], dArray[5]);
                        break;
                    }
                    dPathConsumer2D.moveTo(dArray[4], dArray[5]);
                    bl = true;
                    break;
                }
                case 4: {
                    if (!bl) break;
                    dPathConsumer2D.closePath();
                    break;
                }
            }
            pathIterator.next();
        }
        dPathConsumer2D.pathDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AATileGenerator getAATileGenerator(Shape shape, AffineTransform affineTransform, Region region, BasicStroke basicStroke, boolean bl, boolean bl2, int[] nArray) {
        MarlinTileGenerator marlinTileGenerator = null;
        DRenderer dRenderer = null;
        DRendererContext dRendererContext = DMarlinRenderingEngine.getRendererContext();
        try {
            NormMode normMode;
            double[] dArray;
            if (DO_CLIP || DO_CLIP_RUNTIME_ENABLE && MarlinProperties.isDoClipAtRuntime()) {
                dArray = dRendererContext.clipRect;
                double d = DRenderer.RDR_OFFSET_X;
                double d2 = DRenderer.RDR_OFFSET_Y;
                dArray[0] = (double)region.getLoY() - 0.001 + d2;
                dArray[1] = (double)(region.getLoY() + region.getHeight()) + 0.001 + d2;
                dArray[2] = (double)region.getLoX() - 0.001 + d;
                dArray[3] = (double)(region.getLoX() + region.getWidth()) + 0.001 + d;
                if (MarlinConst.DO_LOG_CLIP) {
                    MarlinUtils.logInfo("clipRect (clip): " + Arrays.toString(dRendererContext.clipRect));
                }
                dRendererContext.doClip = true;
            }
            dArray = affineTransform != null && !affineTransform.isIdentity() ? affineTransform : null;
            NormMode normMode2 = normMode = bl2 ? NormMode.ON_WITH_AA : NormMode.OFF;
            if (basicStroke == null) {
                PathIterator pathIterator = normMode.getNormalizingPathIterator(dRendererContext, shape.getPathIterator((AffineTransform)dArray));
                DPathConsumer2D dPathConsumer2D = dRenderer = dRendererContext.renderer.init(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), pathIterator.getWindingRule());
                if (dRendererContext.doClip) {
                    dPathConsumer2D = dRendererContext.transformerPC2D.pathClipper(dPathConsumer2D);
                }
                DMarlinRenderingEngine.pathTo(dRendererContext, pathIterator, dPathConsumer2D);
            } else {
                dRenderer = dRendererContext.renderer.init(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), 1);
                this.strokeTo(dRendererContext, shape, (AffineTransform)dArray, basicStroke, bl, normMode, true, dRenderer);
            }
            if (dRenderer.endRendering()) {
                marlinTileGenerator = dRendererContext.ptg.init();
                marlinTileGenerator.getBbox(nArray);
                dRenderer = null;
            }
        }
        finally {
            if (dRenderer != null) {
                dRenderer.dispose();
            }
        }
        return marlinTileGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AATileGenerator getAATileGenerator(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Region region, int[] nArray) {
        double d9;
        double d10;
        double d11;
        double d12;
        boolean bl;
        boolean bl2 = bl = d7 > 0.0 && d8 > 0.0;
        if (bl) {
            d12 = d3 * d7;
            d11 = d4 * d7;
            d10 = d5 * d8;
            d9 = d6 * d8;
            d -= (d12 + d10) / 2.0;
            d2 -= (d11 + d9) / 2.0;
            d3 += d12;
            d4 += d11;
            d5 += d10;
            d6 += d9;
            if (d7 > 1.0 && d8 > 1.0) {
                bl = false;
            }
        } else {
            d9 = 0.0;
            d10 = 0.0;
            d11 = 0.0;
            d12 = 0.0;
        }
        MarlinTileGenerator marlinTileGenerator = null;
        DRenderer dRenderer = null;
        DRendererContext dRendererContext = DMarlinRenderingEngine.getRendererContext();
        try {
            dRenderer = dRendererContext.renderer.init(region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), 0);
            dRenderer.moveTo(d, d2);
            dRenderer.lineTo(d + d3, d2 + d4);
            dRenderer.lineTo(d + d3 + d5, d2 + d4 + d6);
            dRenderer.lineTo(d + d5, d2 + d6);
            dRenderer.closePath();
            if (bl) {
                dRenderer.moveTo(d += d12 + d10, d2 += d11 + d9);
                dRenderer.lineTo(d + (d3 -= 2.0 * d12), d2 + (d4 -= 2.0 * d11));
                dRenderer.lineTo(d + d3 + (d5 -= 2.0 * d10), d2 + d4 + (d6 -= 2.0 * d9));
                dRenderer.lineTo(d + d5, d2 + d6);
                dRenderer.closePath();
            }
            dRenderer.pathDone();
            if (dRenderer.endRendering()) {
                marlinTileGenerator = dRendererContext.ptg.init();
                marlinTileGenerator.getBbox(nArray);
                dRenderer = null;
            }
        }
        finally {
            if (dRenderer != null) {
                dRenderer.dispose();
            }
        }
        return marlinTileGenerator;
    }

    @Override
    public float getMinimumAAPenSize() {
        return MIN_PEN_SIZE;
    }

    private static void logSettings(String string) {
        String string2;
        if (SETTINGS_LOGGED) {
            return;
        }
        SETTINGS_LOGGED = true;
        switch (REF_TYPE) {
            default: {
                string2 = "hard";
                break;
            }
            case 1: {
                string2 = "soft";
                break;
            }
            case 2: {
                string2 = "weak";
            }
        }
        MarlinUtils.logInfo("===============================================================================");
        MarlinUtils.logInfo("Marlin software rasterizer           = ENABLED");
        MarlinUtils.logInfo("Version                              = [" + Version.getVersion() + "]");
        MarlinUtils.logInfo("sun.java2d.renderer                  = " + string);
        MarlinUtils.logInfo("sun.java2d.renderer.useThreadLocal   = " + USE_THREAD_LOCAL);
        MarlinUtils.logInfo("sun.java2d.renderer.useRef           = " + string2);
        MarlinUtils.logInfo("sun.java2d.renderer.edges            = " + MarlinConst.INITIAL_EDGES_COUNT);
        MarlinUtils.logInfo("sun.java2d.renderer.pixelWidth       = " + MarlinConst.INITIAL_PIXEL_WIDTH);
        MarlinUtils.logInfo("sun.java2d.renderer.pixelHeight      = " + MarlinConst.INITIAL_PIXEL_HEIGHT);
        MarlinUtils.logInfo("sun.java2d.renderer.profile          = " + (MarlinProperties.isProfileQuality() ? "quality" : "speed"));
        MarlinUtils.logInfo("sun.java2d.renderer.subPixel_log2_X  = " + MarlinConst.SUBPIXEL_LG_POSITIONS_X);
        MarlinUtils.logInfo("sun.java2d.renderer.subPixel_log2_Y  = " + MarlinConst.SUBPIXEL_LG_POSITIONS_Y);
        MarlinUtils.logInfo("sun.java2d.renderer.tileSize_log2    = " + MarlinConst.TILE_H_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.tileWidth_log2   = " + MarlinConst.TILE_W_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.blockSize_log2   = " + MarlinConst.BLOCK_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.forceRLE         = " + MarlinProperties.isForceRLE());
        MarlinUtils.logInfo("sun.java2d.renderer.forceNoRLE       = " + MarlinProperties.isForceNoRLE());
        MarlinUtils.logInfo("sun.java2d.renderer.useTileFlags     = " + MarlinProperties.isUseTileFlags());
        MarlinUtils.logInfo("sun.java2d.renderer.useTileFlags.useHeuristics = " + MarlinProperties.isUseTileFlagsWithHeuristics());
        MarlinUtils.logInfo("sun.java2d.renderer.rleMinWidth      = " + MarlinCache.RLE_MIN_WIDTH);
        MarlinUtils.logInfo("sun.java2d.renderer.useSimplifier    = " + MarlinConst.USE_SIMPLIFIER);
        MarlinUtils.logInfo("sun.java2d.renderer.usePathSimplifier= " + MarlinConst.USE_PATH_SIMPLIFIER);
        MarlinUtils.logInfo("sun.java2d.renderer.pathSimplifier.pixTol = " + MarlinProperties.getPathSimplifierPixelTolerance());
        MarlinUtils.logInfo("sun.java2d.renderer.clip             = " + MarlinProperties.isDoClip());
        MarlinUtils.logInfo("sun.java2d.renderer.clip.runtime.enable = " + MarlinProperties.isDoClipRuntimeFlag());
        MarlinUtils.logInfo("sun.java2d.renderer.clip.subdivider  = " + MarlinProperties.isDoClipSubdivider());
        MarlinUtils.logInfo("sun.java2d.renderer.clip.subdivider.minLength = " + MarlinProperties.getSubdividerMinLength());
        MarlinUtils.logInfo("sun.java2d.renderer.doStats          = " + MarlinConst.DO_STATS);
        MarlinUtils.logInfo("sun.java2d.renderer.doMonitors       = false");
        MarlinUtils.logInfo("sun.java2d.renderer.doChecks         = " + MarlinConst.DO_CHECKS);
        MarlinUtils.logInfo("sun.java2d.renderer.useLogger        = " + MarlinConst.USE_LOGGER);
        MarlinUtils.logInfo("sun.java2d.renderer.logCreateContext = " + MarlinConst.LOG_CREATE_CONTEXT);
        MarlinUtils.logInfo("sun.java2d.renderer.logUnsafeMalloc  = " + MarlinConst.LOG_UNSAFE_MALLOC);
        MarlinUtils.logInfo("sun.java2d.renderer.curve_len_err    = " + MarlinProperties.getCurveLengthError());
        MarlinUtils.logInfo("sun.java2d.renderer.cubic_dec_d2     = " + MarlinProperties.getCubicDecD2());
        MarlinUtils.logInfo("sun.java2d.renderer.cubic_inc_d1     = " + MarlinProperties.getCubicIncD1());
        MarlinUtils.logInfo("sun.java2d.renderer.quad_dec_d2      = " + MarlinProperties.getQuadDecD2());
        MarlinUtils.logInfo("Renderer settings:");
        MarlinUtils.logInfo("CUB_DEC_BND  = " + DRenderer.CUB_DEC_BND);
        MarlinUtils.logInfo("CUB_INC_BND  = " + DRenderer.CUB_INC_BND);
        MarlinUtils.logInfo("QUAD_DEC_BND = " + DRenderer.QUAD_DEC_BND);
        MarlinUtils.logInfo("INITIAL_EDGES_CAPACITY               = " + MarlinConst.INITIAL_EDGES_CAPACITY);
        MarlinUtils.logInfo("INITIAL_CROSSING_COUNT               = " + DRenderer.INITIAL_CROSSING_COUNT);
        MarlinUtils.logInfo("===============================================================================");
    }

    static DRendererContext getRendererContext() {
        DRendererContext dRendererContext = RDR_CTX_PROVIDER.acquire();
        return dRendererContext;
    }

    static void returnRendererContext(DRendererContext dRendererContext) {
        dRendererContext.dispose();
        RDR_CTX_PROVIDER.release(dRendererContext);
    }

    static {
        String string;
        DO_CLIP = MarlinProperties.isDoClip();
        DO_CLIP_RUNTIME_ENABLE = MarlinProperties.isDoClipRuntimeFlag();
        MIN_PEN_SIZE = 1.0f / MIN_SUBPIXELS;
        USE_THREAD_LOCAL = MarlinProperties.isUseThreadLocal();
        switch (string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.renderer.useRef", "soft"))) {
            default: {
                REF_TYPE = 1;
                break;
            }
            case "weak": {
                REF_TYPE = 2;
                break;
            }
            case "hard": {
                REF_TYPE = 0;
            }
        }
        RDR_CTX_PROVIDER = USE_THREAD_LOCAL ? new ReentrantContextProviderTL<DRendererContext>(REF_TYPE){

            @Override
            protected DRendererContext newContext() {
                return DRendererContext.createContext();
            }
        } : new ReentrantContextProviderCLQ<DRendererContext>(REF_TYPE){

            @Override
            protected DRendererContext newContext() {
                return DRendererContext.createContext();
            }
        };
        SETTINGS_LOGGED = !ENABLE_LOGS;
    }

    static abstract class NormalizingPathIterator
    implements PathIterator {
        private PathIterator src;
        private double curx_adjust;
        private double cury_adjust;
        private double movx_adjust;
        private double movy_adjust;
        private final double[] tmp;

        NormalizingPathIterator(double[] dArray) {
            this.tmp = dArray;
        }

        final NormalizingPathIterator init(PathIterator pathIterator) {
            this.src = pathIterator;
            return this;
        }

        final void dispose() {
            this.src = null;
        }

        @Override
        public final int currentSegment(double[] dArray) {
            double d;
            double d2;
            int n;
            int n2 = this.src.currentSegment(dArray);
            switch (n2) {
                case 0: 
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 4: {
                    this.curx_adjust = this.movx_adjust;
                    this.cury_adjust = this.movy_adjust;
                    return n2;
                }
                default: {
                    throw new InternalError("Unrecognized curve type");
                }
            }
            double d3 = dArray[n];
            dArray[n] = d2 = this.normCoord(d3);
            d2 -= d3;
            d3 = dArray[n + 1];
            dArray[n + 1] = d = this.normCoord(d3);
            d -= d3;
            switch (n2) {
                case 0: {
                    this.movx_adjust = d2;
                    this.movy_adjust = d;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    dArray[0] = dArray[0] + (this.curx_adjust + d2) / 2.0;
                    dArray[1] = dArray[1] + (this.cury_adjust + d) / 2.0;
                    break;
                }
                case 3: {
                    dArray[0] = dArray[0] + this.curx_adjust;
                    dArray[1] = dArray[1] + this.cury_adjust;
                    dArray[2] = dArray[2] + d2;
                    dArray[3] = dArray[3] + d;
                    break;
                }
            }
            this.curx_adjust = d2;
            this.cury_adjust = d;
            return n2;
        }

        abstract double normCoord(double var1);

        @Override
        public final int currentSegment(float[] fArray) {
            double[] dArray = this.tmp;
            int n = this.currentSegment(dArray);
            for (int i = 0; i < 6; ++i) {
                fArray[i] = (float)dArray[i];
            }
            return n;
        }

        @Override
        public final int getWindingRule() {
            return this.src.getWindingRule();
        }

        @Override
        public final boolean isDone() {
            if (this.src.isDone()) {
                this.dispose();
                return true;
            }
            return false;
        }

        @Override
        public final void next() {
            this.src.next();
        }

        static final class NearestPixelQuarter
        extends NormalizingPathIterator {
            NearestPixelQuarter(double[] dArray) {
                super(dArray);
            }

            @Override
            double normCoord(double d) {
                return Math.floor(d + 0.25) + 0.25;
            }
        }

        static final class NearestPixelCenter
        extends NormalizingPathIterator {
            NearestPixelCenter(double[] dArray) {
                super(dArray);
            }

            @Override
            double normCoord(double d) {
                return Math.floor(d) + 0.5;
            }
        }
    }

    private static enum NormMode {
        ON_WITH_AA{

            @Override
            PathIterator getNormalizingPathIterator(DRendererContext dRendererContext, PathIterator pathIterator) {
                return dRendererContext.nPCPathIterator.init(pathIterator);
            }
        }
        ,
        ON_NO_AA{

            @Override
            PathIterator getNormalizingPathIterator(DRendererContext dRendererContext, PathIterator pathIterator) {
                return dRendererContext.nPQPathIterator.init(pathIterator);
            }
        }
        ,
        OFF{

            @Override
            PathIterator getNormalizingPathIterator(DRendererContext dRendererContext, PathIterator pathIterator) {
                return pathIterator;
            }
        };


        abstract PathIterator getNormalizingPathIterator(DRendererContext var1, PathIterator var2);
    }
}

