/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.logging.Level;
import java.util.logging.Logger;
import sun.java2d.marlin.MarlinConst;

public final class MarlinUtils {
    private static final Logger LOG = MarlinConst.USE_LOGGER ? Logger.getLogger("sun.java2d.marlin") : null;

    private MarlinUtils() {
    }

    public static void logInfo(String string) {
        if (MarlinConst.USE_LOGGER) {
            LOG.info(string);
        } else if (MarlinConst.ENABLE_LOGS) {
            System.out.print("INFO: ");
            System.out.println(string);
        }
    }

    public static void logException(String string, Throwable throwable) {
        if (MarlinConst.USE_LOGGER) {
            LOG.log(Level.WARNING, string, throwable);
        } else if (MarlinConst.ENABLE_LOGS) {
            System.out.print("WARNING: ");
            System.out.println(string);
            throwable.printStackTrace(System.err);
        }
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = threadGroup.getParent();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        return threadGroup;
    }
}

