/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;
import sun.misc.Unsafe;

final class OffHeapArray {
    static final Unsafe UNSAFE = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

        @Override
        public Unsafe run() {
            Unsafe unsafe = null;
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                throw new InternalError("Unable to get sun.misc.Unsafe instance", exception);
            }
            return unsafe;
        }
    });
    static final int SIZE_INT = 4;
    long address;
    long length;
    int used;
    private static final ReferenceQueue<Object> REF_QUEUE;
    private static final Vector<OffHeapReference> REF_LIST;

    OffHeapArray(Object object, long l) {
        this.address = UNSAFE.allocateMemory(l);
        this.length = l;
        this.used = 0;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory =   " + l + " to addr = " + this.address);
        }
        REF_LIST.add(new OffHeapReference(object, this));
    }

    void resize(long l) {
        this.address = UNSAFE.reallocateMemory(this.address, l);
        this.length = l;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + l + " to addr = " + this.address);
        }
    }

    void free() {
        UNSAFE.freeMemory(this.address);
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.freeMemory =       " + this.length + " at addr = " + this.address);
        }
        this.address = 0L;
    }

    void fill(byte by) {
        UNSAFE.setMemory(this.address, this.length, by);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread thread = new Thread(MarlinUtils.getRootThreadGroup(), new OffHeapDisposer(), "MarlinRenderer Disposer");
                thread.setContextClassLoader(null);
                thread.setDaemon(true);
                thread.setPriority(8);
                thread.start();
                return null;
            }
        });
        REF_QUEUE = new ReferenceQueue();
        REF_LIST = new Vector(32);
    }

    static final class OffHeapDisposer
    implements Runnable {
        OffHeapDisposer() {
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                try {
                    OffHeapReference offHeapReference = (OffHeapReference)REF_QUEUE.remove();
                    offHeapReference.dispose();
                    REF_LIST.remove(offHeapReference);
                }
                catch (InterruptedException interruptedException) {
                    MarlinUtils.logException("OffHeapDisposer interrupted:", interruptedException);
                }
            }
        }
    }

    static final class OffHeapReference
    extends PhantomReference<Object> {
        private final OffHeapArray array;

        OffHeapReference(Object object, OffHeapArray offHeapArray) {
            super(object, REF_QUEUE);
            this.array = offHeapArray;
        }

        void dispose() {
            this.array.free();
        }
    }
}

