/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotatedTypeFactory;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotation;

public final class TypeAnnotationParser {
    private static final TypeAnnotation[] EMPTY_TYPE_ANNOTATION_ARRAY = new TypeAnnotation[0];
    private static final byte CLASS_TYPE_PARAMETER = 0;
    private static final byte METHOD_TYPE_PARAMETER = 1;
    private static final byte CLASS_EXTENDS = 16;
    private static final byte CLASS_TYPE_PARAMETER_BOUND = 17;
    private static final byte METHOD_TYPE_PARAMETER_BOUND = 18;
    private static final byte FIELD = 19;
    private static final byte METHOD_RETURN = 20;
    private static final byte METHOD_RECEIVER = 21;
    private static final byte METHOD_FORMAL_PARAMETER = 22;
    private static final byte THROWS = 23;
    private static final byte LOCAL_VARIABLE = 64;
    private static final byte RESOURCE_VARIABLE = 65;
    private static final byte EXCEPTION_PARAMETER = 66;
    private static final byte INSTANCEOF = 67;
    private static final byte NEW = 68;
    private static final byte CONSTRUCTOR_REFERENCE = 69;
    private static final byte METHOD_REFERENCE = 70;
    private static final byte CAST = 71;
    private static final byte CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    private static final byte METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    private static final byte CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    private static final byte METHOD_REFERENCE_TYPE_ARGUMENT = 75;

    public static AnnotatedType buildAnnotatedType(byte[] byArray, ConstantPool constantPool, AnnotatedElement annotatedElement, Class<?> clazz, Type type, TypeAnnotation.TypeAnnotationTarget typeAnnotationTarget) {
        TypeAnnotation[] typeAnnotationArray = TypeAnnotationParser.parseTypeAnnotations(byArray, constantPool, annotatedElement, clazz);
        ArrayList<TypeAnnotation> arrayList = new ArrayList<TypeAnnotation>(typeAnnotationArray.length);
        for (TypeAnnotation typeAnnotation : typeAnnotationArray) {
            TypeAnnotation.TypeAnnotationTargetInfo typeAnnotationTargetInfo = typeAnnotation.getTargetInfo();
            if (typeAnnotationTargetInfo.getTarget() != typeAnnotationTarget) continue;
            arrayList.add(typeAnnotation);
        }
        TypeAnnotation[] typeAnnotationArray2 = arrayList.toArray(EMPTY_TYPE_ANNOTATION_ARRAY);
        return AnnotatedTypeFactory.buildAnnotatedType(type, TypeAnnotation.LocationInfo.BASE_LOCATION, typeAnnotationArray2, typeAnnotationArray2, annotatedElement);
    }

    public static AnnotatedType[] buildAnnotatedTypes(byte[] byArray, ConstantPool constantPool, AnnotatedElement annotatedElement, Class<?> clazz, Type[] typeArray, TypeAnnotation.TypeAnnotationTarget typeAnnotationTarget) {
        Constructor constructor;
        Class clazz2;
        Object object;
        TypeAnnotation[] typeAnnotationArray;
        int n = typeArray.length;
        Object[] objectArray = new AnnotatedType[n];
        Arrays.fill(objectArray, AnnotatedTypeFactory.EMPTY_ANNOTATED_TYPE);
        ArrayList[] arrayListArray = new ArrayList[n];
        TypeAnnotation[] typeAnnotationArray2 = typeAnnotationArray = TypeAnnotationParser.parseTypeAnnotations(byArray, constantPool, annotatedElement, clazz);
        int n2 = typeAnnotationArray2.length;
        for (int i = 0; i < n2; ++i) {
            ArrayList<TypeAnnotation[]> arrayList;
            object = typeAnnotationArray2[i];
            TypeAnnotation.TypeAnnotationTargetInfo typeAnnotationTargetInfo = object.getTargetInfo();
            if (typeAnnotationTargetInfo.getTarget() != typeAnnotationTarget) continue;
            int n3 = typeAnnotationTargetInfo.getCount();
            if (arrayListArray[n3] == null) {
                arrayListArray[n3] = arrayList = new ArrayList<TypeAnnotation[]>(typeAnnotationArray.length);
            }
            arrayList = arrayListArray[n3];
            arrayList.add((TypeAnnotation[])object);
        }
        boolean bl = false;
        if (annotatedElement instanceof Constructor && !(clazz2 = (constructor = (Constructor)annotatedElement).getDeclaringClass()).isEnum() && clazz2.isMemberClass() && (clazz2.getModifiers() & 8) == 0) {
            bl = true;
        }
        for (n2 = 0; n2 < n; ++n2) {
            TypeAnnotation[] typeAnnotationArray3 = bl ? (object = n2 == 0 ? null : arrayListArray[n2 - 1]) : (object = arrayListArray[n2]);
            object = typeAnnotationArray3 != null ? typeAnnotationArray3.toArray(new TypeAnnotation[typeAnnotationArray3.size()]) : EMPTY_TYPE_ANNOTATION_ARRAY;
            objectArray[n2] = AnnotatedTypeFactory.buildAnnotatedType(typeArray[n2], TypeAnnotation.LocationInfo.BASE_LOCATION, object, object, annotatedElement);
        }
        return objectArray;
    }

    public static AnnotatedType buildAnnotatedSuperclass(byte[] byArray, ConstantPool constantPool, Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type == null) {
            return AnnotatedTypeFactory.EMPTY_ANNOTATED_TYPE;
        }
        return TypeAnnotationParser.buildAnnotatedType(byArray, constantPool, clazz, clazz, type, TypeAnnotation.TypeAnnotationTarget.CLASS_EXTENDS);
    }

    public static AnnotatedType[] buildAnnotatedInterfaces(byte[] byArray, ConstantPool constantPool, Class<?> clazz) {
        if (clazz == Object.class || clazz.isArray() || clazz.isPrimitive() || clazz == Void.TYPE) {
            return AnnotatedTypeFactory.EMPTY_ANNOTATED_TYPE_ARRAY;
        }
        return TypeAnnotationParser.buildAnnotatedTypes(byArray, constantPool, clazz, clazz, clazz.getGenericInterfaces(), TypeAnnotation.TypeAnnotationTarget.CLASS_IMPLEMENTS);
    }

    public static <D extends GenericDeclaration> Annotation[] parseTypeVariableAnnotations(D d, int n) {
        TypeAnnotation.TypeAnnotationTarget typeAnnotationTarget;
        GenericDeclaration genericDeclaration;
        if (d instanceof Class) {
            genericDeclaration = (Class)d;
            typeAnnotationTarget = TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER;
        } else if (d instanceof Executable) {
            genericDeclaration = (Executable)d;
            typeAnnotationTarget = TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER;
        } else {
            throw new AssertionError((Object)("Unknown GenericDeclaration " + d + "\nthis should not happen."));
        }
        List<TypeAnnotation> list = TypeAnnotation.filter(TypeAnnotationParser.parseAllTypeAnnotations(genericDeclaration), typeAnnotationTarget);
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(list.size());
        for (TypeAnnotation typeAnnotation : list) {
            if (typeAnnotation.getTargetInfo().getCount() != n) continue;
            arrayList.add(typeAnnotation.getAnnotation());
        }
        return arrayList.toArray(new Annotation[0]);
    }

    public static <D extends GenericDeclaration> AnnotatedType[] parseAnnotatedBounds(Type[] typeArray, D d, int n) {
        return TypeAnnotationParser.parseAnnotatedBounds(typeArray, d, n, TypeAnnotation.LocationInfo.BASE_LOCATION);
    }

    private static <D extends GenericDeclaration> AnnotatedType[] parseAnnotatedBounds(Type[] typeArray, D d, int n, TypeAnnotation.LocationInfo locationInfo) {
        List<TypeAnnotation> list = TypeAnnotationParser.fetchBounds(d);
        if (typeArray != null) {
            Serializable serializable;
            int n2 = 0;
            AnnotatedType[] annotatedTypeArray = new AnnotatedType[typeArray.length];
            if (typeArray.length > 0) {
                Type type = typeArray[0];
                if (!(type instanceof Class)) {
                    n2 = 1;
                } else {
                    serializable = (Class)type;
                    if (((Class)serializable).isInterface()) {
                        n2 = 1;
                    }
                }
            }
            for (int i = 0; i < typeArray.length; ++i) {
                serializable = new ArrayList(list.size());
                for (TypeAnnotation typeAnnotation : list) {
                    TypeAnnotation.TypeAnnotationTargetInfo typeAnnotationTargetInfo = typeAnnotation.getTargetInfo();
                    if (typeAnnotationTargetInfo.getSecondaryIndex() != i + n2 || typeAnnotationTargetInfo.getCount() != n) continue;
                    serializable.add(typeAnnotation);
                }
                annotatedTypeArray[i] = AnnotatedTypeFactory.buildAnnotatedType(typeArray[i], locationInfo, serializable.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), list.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), d);
            }
            return annotatedTypeArray;
        }
        return new AnnotatedType[0];
    }

    private static <D extends GenericDeclaration> List<TypeAnnotation> fetchBounds(D d) {
        GenericDeclaration genericDeclaration;
        TypeAnnotation.TypeAnnotationTarget typeAnnotationTarget;
        if (d instanceof Class) {
            typeAnnotationTarget = TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER_BOUND;
            genericDeclaration = (Class)d;
        } else {
            typeAnnotationTarget = TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER_BOUND;
            genericDeclaration = (Executable)d;
        }
        return TypeAnnotation.filter(TypeAnnotationParser.parseAllTypeAnnotations(genericDeclaration), typeAnnotationTarget);
    }

    static TypeAnnotation[] parseAllTypeAnnotations(AnnotatedElement annotatedElement) {
        byte[] byArray;
        Class<?> clazz;
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        if (annotatedElement instanceof Class) {
            clazz = (Class<?>)annotatedElement;
            byArray = javaLangAccess.getRawClassTypeAnnotations(clazz);
        } else if (annotatedElement instanceof Executable) {
            clazz = ((Executable)annotatedElement).getDeclaringClass();
            byArray = javaLangAccess.getRawExecutableTypeAnnotations((Executable)annotatedElement);
        } else {
            return EMPTY_TYPE_ANNOTATION_ARRAY;
        }
        return TypeAnnotationParser.parseTypeAnnotations(byArray, javaLangAccess.getConstantPool(clazz), annotatedElement, clazz);
    }

    private static TypeAnnotation[] parseTypeAnnotations(byte[] byArray, ConstantPool constantPool, AnnotatedElement annotatedElement, Class<?> clazz) {
        if (byArray == null) {
            return EMPTY_TYPE_ANNOTATION_ARRAY;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = byteBuffer.getShort() & 0xFFFF;
        ArrayList<TypeAnnotation> arrayList = new ArrayList<TypeAnnotation>(n);
        for (int i = 0; i < n; ++i) {
            TypeAnnotation typeAnnotation = TypeAnnotationParser.parseTypeAnnotation(byteBuffer, constantPool, annotatedElement, clazz);
            if (typeAnnotation == null) continue;
            arrayList.add(typeAnnotation);
        }
        return arrayList.toArray(EMPTY_TYPE_ANNOTATION_ARRAY);
    }

    static Map<Class<? extends Annotation>, Annotation> mapTypeAnnotations(TypeAnnotation[] typeAnnotationArray) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> linkedHashMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (TypeAnnotation typeAnnotation : typeAnnotationArray) {
            Annotation annotation = typeAnnotation.getAnnotation();
            Class<? extends Annotation> clazz = annotation.annotationType();
            AnnotationType annotationType = AnnotationType.getInstance(clazz);
            if (annotationType.retention() != RetentionPolicy.RUNTIME || linkedHashMap.put(clazz, annotation) == null) continue;
            throw new AnnotationFormatError("Duplicate annotation for class: " + clazz + ": " + annotation);
        }
        return linkedHashMap;
    }

    private static TypeAnnotation parseTypeAnnotation(ByteBuffer byteBuffer, ConstantPool constantPool, AnnotatedElement annotatedElement, Class<?> clazz) {
        try {
            TypeAnnotation.TypeAnnotationTargetInfo typeAnnotationTargetInfo = TypeAnnotationParser.parseTargetInfo(byteBuffer);
            TypeAnnotation.LocationInfo locationInfo = TypeAnnotation.LocationInfo.parseLocationInfo(byteBuffer);
            Annotation annotation = AnnotationParser.parseAnnotation(byteBuffer, constantPool, clazz, false);
            if (typeAnnotationTargetInfo == null) {
                return null;
            }
            return new TypeAnnotation(typeAnnotationTargetInfo, locationInfo, annotation, annotatedElement);
        }
        catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
            throw new AnnotationFormatError(runtimeException);
        }
    }

    private static TypeAnnotation.TypeAnnotationTargetInfo parseTargetInfo(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 0: 
            case 1: {
                int n2 = byteBuffer.get() & 0xFF;
                TypeAnnotation.TypeAnnotationTargetInfo typeAnnotationTargetInfo = n == 0 ? new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER, n2) : new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER, n2);
                return typeAnnotationTargetInfo;
            }
            case 16: {
                short s = byteBuffer.getShort();
                if (s == -1) {
                    return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.CLASS_EXTENDS);
                }
                if (s < 0) break;
                TypeAnnotation.TypeAnnotationTargetInfo typeAnnotationTargetInfo = new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.CLASS_IMPLEMENTS, s);
                return typeAnnotationTargetInfo;
            }
            case 17: {
                return TypeAnnotationParser.parse2ByteTarget(TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER_BOUND, byteBuffer);
            }
            case 18: {
                return TypeAnnotationParser.parse2ByteTarget(TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER_BOUND, byteBuffer);
            }
            case 19: {
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.FIELD);
            }
            case 20: {
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_RETURN);
            }
            case 21: {
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
            }
            case 22: {
                int n3 = byteBuffer.get() & 0xFF;
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_FORMAL_PARAMETER, n3);
            }
            case 23: {
                return TypeAnnotationParser.parseShortTarget(TypeAnnotation.TypeAnnotationTarget.THROWS, byteBuffer);
            }
            case 64: 
            case 65: {
                int n4 = byteBuffer.getShort();
                for (int i = 0; i < n4; ++i) {
                    short s = byteBuffer.getShort();
                    short s2 = byteBuffer.getShort();
                    short s3 = byteBuffer.getShort();
                }
                return null;
            }
            case 66: {
                byte by = byteBuffer.get();
                return null;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                short s = byteBuffer.getShort();
                return null;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                short s = byteBuffer.getShort();
                byte by = byteBuffer.get();
                return null;
            }
        }
        throw new AnnotationFormatError("Could not parse bytes for type annotations");
    }

    private static TypeAnnotation.TypeAnnotationTargetInfo parseShortTarget(TypeAnnotation.TypeAnnotationTarget typeAnnotationTarget, ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort() & 0xFFFF;
        return new TypeAnnotation.TypeAnnotationTargetInfo(typeAnnotationTarget, n);
    }

    private static TypeAnnotation.TypeAnnotationTargetInfo parse2ByteTarget(TypeAnnotation.TypeAnnotationTarget typeAnnotationTarget, ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        int n2 = byteBuffer.get() & 0xFF;
        return new TypeAnnotation.TypeAnnotationTargetInfo(typeAnnotationTarget, n, n2);
    }
}

