/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.MatcherLookup;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.MapMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Checks;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.filter.Filter;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.filter.NoFilter;

public class ModuleRules {
    private Map rules = new LinkedHashMap();
    private MatcherLookup matcher_lookup = new MatcherLookup();

    public ModuleRules() {
    }

    private ModuleRules(Map rules) {
        this.rules = new LinkedHashMap(rules);
        Iterator iter = rules.keySet().iterator();
        while (iter.hasNext()) {
            this.matcher_lookup.add((MapMatcher)iter.next());
        }
    }

    public void defineRule(MapMatcher condition, Object rule) {
        Checks.checkNotNull(condition, "condition");
        Checks.checkNotNull(rule, "rule");
        this.rules.put(condition, rule);
        this.matcher_lookup.add(condition);
    }

    public Object getRule(ModuleId mid) {
        return this.getRule(mid, NoFilter.INSTANCE);
    }

    public Object[] getRules(ModuleId mid) {
        return this.getRules(mid.getAttributes(), NoFilter.INSTANCE);
    }

    public Object getRule(ModuleRevisionId mrid) {
        return this.getRule(mrid, NoFilter.INSTANCE);
    }

    public Object getRule(ModuleId mid, Filter filter2) {
        Checks.checkNotNull(mid, "mid");
        return this.getRule(mid.getAttributes(), filter2);
    }

    public Object getRule(ModuleRevisionId mrid, Filter filter2) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter2, "filter");
        Map moduleAttributes = mrid.getAttributes();
        return this.getRule(moduleAttributes, filter2);
    }

    private Object getRule(Map moduleAttributes, Filter filter2) {
        List matchers = this.matcher_lookup.get(moduleAttributes);
        for (MapMatcher midm : matchers) {
            Object rule = this.rules.get(midm);
            if (!filter2.accept(rule)) continue;
            return rule;
        }
        return null;
    }

    public Object[] getRules(ModuleRevisionId mrid, Filter filter2) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter2, "filter");
        Map moduleAttributes = mrid.getAttributes();
        return this.getRules(moduleAttributes, filter2);
    }

    private Object[] getRules(Map moduleAttributes, Filter filter2) {
        List matchers = this.matcher_lookup.get(moduleAttributes);
        ArrayList matchingRules = new ArrayList();
        for (MapMatcher midm : matchers) {
            Object rule = this.rules.get(midm);
            if (!filter2.accept(rule)) continue;
            matchingRules.add(rule);
        }
        return matchingRules.toArray();
    }

    public void dump(String prefix) {
        if (this.rules.isEmpty()) {
            Message.debug(prefix + "NONE");
        } else {
            for (MapMatcher midm : this.rules.keySet()) {
                Object rule = this.rules.get(midm);
                Message.debug(prefix + midm + " -> " + rule);
            }
        }
    }

    public Map getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public Object clone() {
        return new ModuleRules(this.rules);
    }
}

