/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxBasicShape;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.util.svg.AWTPathProducer;
import com.mxgraph.util.svg.AWTPolygonProducer;
import com.mxgraph.util.svg.AWTPolylineProducer;
import com.mxgraph.util.svg.ExtendedGeneralPath;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxStencilShape
extends mxBasicShape {
    protected GeneralPath shapePath;
    protected Node root;
    protected svgShape rootShape;
    protected Rectangle2D boundingBox;
    protected String name;
    protected String iconPath;
    protected AffineTransform cachedTransform = new AffineTransform();

    public mxStencilShape() {
    }

    public mxStencilShape(String shapeXml) {
        this(mxXmlUtils.parseXml(shapeXml));
    }

    public mxStencilShape(Document document) {
        if (document != null) {
            NodeList svgList;
            NodeList iconList;
            NodeList nameList = document.getElementsByTagName("name");
            if (nameList != null && nameList.getLength() > 0) {
                this.name = nameList.item(0).getTextContent();
            }
            if ((iconList = document.getElementsByTagName("icon")) != null && iconList.getLength() > 0) {
                this.iconPath = iconList.item(0).getTextContent();
            }
            if ((svgList = document.getElementsByTagName("svg:svg")) != null && svgList.getLength() > 0) {
                this.root = svgList.item(0);
            } else {
                svgList = document.getElementsByTagName("svg");
                if (svgList != null && svgList.getLength() > 0) {
                    this.root = svgList.item(0);
                }
            }
            if (this.root != null) {
                this.rootShape = new svgShape(null, null);
                this.createShape(this.root, this.rootShape);
            }
        }
    }

    @Override
    public void paintShape(mxGraphics2DCanvas canvas, mxCellState state) {
        double x = state.getX();
        double y = state.getY();
        double w = state.getWidth();
        double h = state.getHeight();
        canvas.getGraphics().translate(x, y);
        double widthRatio = 1.0;
        double heightRatio = 1.0;
        if (this.boundingBox != null) {
            widthRatio = w / this.boundingBox.getWidth();
            heightRatio = h / this.boundingBox.getHeight();
        }
        this.paintNode(canvas, state, this.rootShape, widthRatio, heightRatio);
        canvas.getGraphics().translate(-x, -y);
    }

    public void paintNode(mxGraphics2DCanvas canvas, mxCellState state, svgShape shape, double widthRatio, double heightRatio) {
        Shape associatedShape = shape.shape;
        boolean fill = false;
        boolean stroke = true;
        Color fillColor = null;
        Color strokeColor = null;
        Map<String, Object> style = shape.style;
        if (style != null) {
            int hashIndex;
            String fillStyle = mxUtils.getString(style, "fill");
            String strokeStyle = mxUtils.getString(style, "stroke");
            if (strokeStyle != null && strokeStyle.equals("none")) {
                if (strokeStyle.equals("none")) {
                    stroke = false;
                } else if (strokeStyle.trim().startsWith("#")) {
                    hashIndex = strokeStyle.indexOf("#");
                    strokeColor = mxUtils.parseColor(strokeStyle.substring(hashIndex + 1));
                }
            }
            if (fillStyle != null) {
                if (fillStyle.equals("none")) {
                    fill = false;
                } else if (fillStyle.trim().startsWith("#")) {
                    hashIndex = fillStyle.indexOf("#");
                    fillColor = mxUtils.parseColor(fillStyle.substring(hashIndex + 1));
                    fill = true;
                } else {
                    fill = true;
                }
            }
        }
        if (associatedShape != null) {
            boolean wasScaled = false;
            if (widthRatio != 1.0 || heightRatio != 1.0) {
                this.transformShape(associatedShape, 0.0, 0.0, widthRatio, heightRatio);
                wasScaled = true;
            }
            if (fill && this.configureGraphics(canvas, state, true)) {
                if (fillColor != null) {
                    canvas.getGraphics().setColor(fillColor);
                }
                canvas.getGraphics().fill(associatedShape);
            }
            if (stroke && this.configureGraphics(canvas, state, false)) {
                if (strokeColor != null) {
                    canvas.getGraphics().setColor(strokeColor);
                }
                canvas.getGraphics().draw(associatedShape);
            }
            if (wasScaled) {
                this.transformShape(associatedShape, 0.0, 0.0, 1.0 / widthRatio, 1.0 / heightRatio);
            }
        }
        for (svgShape subShape : shape.subShapes) {
            this.paintNode(canvas, state, subShape, widthRatio, heightRatio);
        }
    }

    protected void transformShape(Shape shape, double transX, double transY, double widthRatio, double heightRatio) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            if (transX != 0.0 || transY != 0.0) {
                rect.setFrame(rect.getX() + transX, rect.getY() + transY, rect.getWidth(), rect.getHeight());
            }
            if (widthRatio != 1.0 || heightRatio != 1.0) {
                rect.setFrame(rect.getX() * widthRatio, rect.getY() * heightRatio, rect.getWidth() * widthRatio, rect.getHeight() * heightRatio);
            }
        } else if (shape instanceof Line2D) {
            Line2D line = (Line2D)shape;
            if (transX != 0.0 || transY != 0.0) {
                line.setLine(line.getX1() + transX, line.getY1() + transY, line.getX2() + transX, line.getY2() + transY);
            }
            if (widthRatio != 1.0 || heightRatio != 1.0) {
                line.setLine(line.getX1() * widthRatio, line.getY1() * heightRatio, line.getX2() * widthRatio, line.getY2() * heightRatio);
            }
        } else if (shape instanceof GeneralPath) {
            GeneralPath path = (GeneralPath)shape;
            this.cachedTransform.setToScale(widthRatio, heightRatio);
            this.cachedTransform.translate(transX, transY);
            path.transform(this.cachedTransform);
        } else if (shape instanceof ExtendedGeneralPath) {
            ExtendedGeneralPath path = (ExtendedGeneralPath)shape;
            this.cachedTransform.setToScale(widthRatio, heightRatio);
            this.cachedTransform.translate(transX, transY);
            path.transform(this.cachedTransform);
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse = (Ellipse2D)shape;
            if (transX != 0.0 || transY != 0.0) {
                ellipse.setFrame(ellipse.getX() + transX, ellipse.getY() + transY, ellipse.getWidth(), ellipse.getHeight());
            }
            if (widthRatio != 1.0 || heightRatio != 1.0) {
                ellipse.setFrame(ellipse.getX() * widthRatio, ellipse.getY() * heightRatio, ellipse.getWidth() * widthRatio, ellipse.getHeight() * heightRatio);
            }
        }
    }

    public void createShape(Node root, svgShape shape) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            svgShape subShape;
            if (this.isGroup(child.getNodeName())) {
                String style = ((Element)root).getAttribute("style");
                Map<String, Object> styleMap = mxStencilShape.getStylenames(style);
                svgShape subShape2 = new svgShape(null, styleMap);
                this.createShape(child, subShape2);
            }
            if ((subShape = this.createElement(child)) == null) continue;
            shape.subShapes.add(subShape);
        }
        for (svgShape subShape : shape.subShapes) {
            if (subShape == null || subShape.shape == null) continue;
            if (this.boundingBox == null) {
                this.boundingBox = subShape.shape.getBounds2D();
                continue;
            }
            this.boundingBox.add(subShape.shape.getBounds2D());
        }
        if (this.boundingBox != null && (this.boundingBox.getX() != 0.0 || this.boundingBox.getY() != 0.0)) {
            for (svgShape subShape : shape.subShapes) {
                if (subShape == null || subShape.shape == null) continue;
                this.transformShape(subShape.shape, -this.boundingBox.getX(), -this.boundingBox.getY(), 1.0, 1.0);
            }
        }
    }

    public svgShape createElement(Node root) {
        Element element = null;
        if (root instanceof Element) {
            element = (Element)root;
            String style = element.getAttribute("style");
            Map<String, Object> styleMap = mxStencilShape.getStylenames(style);
            if (this.isRectangle(root.getNodeName())) {
                svgShape rectShape = null;
                try {
                    String xString = element.getAttribute("x");
                    String yString = element.getAttribute("y");
                    String widthString = element.getAttribute("width");
                    String heightString = element.getAttribute("height");
                    double x = 0.0;
                    double y = 0.0;
                    double width = 0.0;
                    double height = 0.0;
                    if (xString.length() > 0) {
                        x = Double.valueOf(xString);
                    }
                    if (yString.length() > 0) {
                        y = Double.valueOf(yString);
                    }
                    if (widthString.length() > 0 && (width = Double.valueOf(widthString).doubleValue()) < 0.0) {
                        return null;
                    }
                    if (heightString.length() > 0 && (height = Double.valueOf(heightString).doubleValue()) < 0.0) {
                        return null;
                    }
                    String rxString = element.getAttribute("rx");
                    String ryString = element.getAttribute("ry");
                    double rx = 0.0;
                    double ry = 0.0;
                    if (rxString.length() > 0 && (rx = Double.valueOf(rxString).doubleValue()) < 0.0) {
                        return null;
                    }
                    if (ryString.length() > 0 && (ry = Double.valueOf(ryString).doubleValue()) < 0.0) {
                        return null;
                    }
                    if (rx > 0.0 || ry > 0.0) {
                        if (rx > 0.0 && ryString.length() == 0) {
                            ry = rx;
                        } else if (ry > 0.0 && rxString.length() == 0) {
                            rx = ry;
                        }
                        if (rx > width / 2.0) {
                            rx = width / 2.0;
                        }
                        if (ry > height / 2.0) {
                            ry = height / 2.0;
                        }
                        rectShape = new svgShape(new RoundRectangle2D.Double(x, y, width, height, rx, ry), styleMap);
                    } else {
                        rectShape = new svgShape(new Rectangle2D.Double(x, y, width, height), styleMap);
                    }
                }
                catch (Exception xString) {
                    // empty catch block
                }
                return rectShape;
            }
            if (this.isLine(root.getNodeName())) {
                String x1String = element.getAttribute("x1");
                String x2String = element.getAttribute("x2");
                String y1String = element.getAttribute("y1");
                String y2String = element.getAttribute("y2");
                double x1 = 0.0;
                double x2 = 0.0;
                double y1 = 0.0;
                double y2 = 0.0;
                if (x1String.length() > 0) {
                    x1 = Double.valueOf(x1String);
                }
                if (x2String.length() > 0) {
                    x2 = Double.valueOf(x2String);
                }
                if (y1String.length() > 0) {
                    y1 = Double.valueOf(y1String);
                }
                if (y2String.length() > 0) {
                    y2 = Double.valueOf(y2String);
                }
                svgShape lineShape = new svgShape(new Line2D.Double(x1, y1, x2, y2), styleMap);
                return lineShape;
            }
            if (this.isPolyline(root.getNodeName()) || this.isPolygon(root.getNodeName())) {
                String pointsString = element.getAttribute("points");
                Shape shape = this.isPolygon(root.getNodeName()) ? AWTPolygonProducer.createShape(pointsString, 1) : AWTPolylineProducer.createShape(pointsString, 1);
                if (shape != null) {
                    return new svgShape(shape, styleMap);
                }
                return null;
            }
            if (this.isCircle(root.getNodeName())) {
                double cx = 0.0;
                double cy = 0.0;
                double r = 0.0;
                String cxString = element.getAttribute("cx");
                String cyString = element.getAttribute("cy");
                String rString = element.getAttribute("r");
                if (cxString.length() > 0) {
                    cx = Double.valueOf(cxString);
                }
                if (cyString.length() > 0) {
                    cy = Double.valueOf(cyString);
                }
                if (rString.length() > 0 && (r = Double.valueOf(rString).doubleValue()) < 0.0) {
                    return null;
                }
                return new svgShape(new Ellipse2D.Double(cx - r, cy - r, r * 2.0, r * 2.0), styleMap);
            }
            if (this.isEllipse(root.getNodeName())) {
                double cx = 0.0;
                double cy = 0.0;
                double rx = 0.0;
                double ry = 0.0;
                String cxString = element.getAttribute("cx");
                String cyString = element.getAttribute("cy");
                String rxString = element.getAttribute("rx");
                String ryString = element.getAttribute("ry");
                if (cxString.length() > 0) {
                    cx = Double.valueOf(cxString);
                }
                if (cyString.length() > 0) {
                    cy = Double.valueOf(cyString);
                }
                if (rxString.length() > 0 && (rx = Double.valueOf(rxString).doubleValue()) < 0.0) {
                    return null;
                }
                if (ryString.length() > 0 && (ry = Double.valueOf(ryString).doubleValue()) < 0.0) {
                    return null;
                }
                return new svgShape(new Ellipse2D.Double(cx - rx, cy - ry, rx * 2.0, ry * 2.0), styleMap);
            }
            if (this.isPath(root.getNodeName())) {
                String d = element.getAttribute("d");
                Shape pathShape = AWTPathProducer.createShape(d, 1);
                return new svgShape(pathShape, styleMap);
            }
        }
        return null;
    }

    private boolean isRectangle(String tag) {
        return tag.equals("svg:rect") || tag.equals("rect");
    }

    private boolean isPath(String tag) {
        return tag.equals("svg:path") || tag.equals("path");
    }

    private boolean isEllipse(String tag) {
        return tag.equals("svg:ellipse") || tag.equals("ellipse");
    }

    private boolean isLine(String tag) {
        return tag.equals("svg:line") || tag.equals("line");
    }

    private boolean isPolyline(String tag) {
        return tag.equals("svg:polyline") || tag.equals("polyline");
    }

    private boolean isCircle(String tag) {
        return tag.equals("svg:circle") || tag.equals("circle");
    }

    private boolean isPolygon(String tag) {
        return tag.equals("svg:polygon") || tag.equals("polygon");
    }

    private boolean isGroup(String tag) {
        return tag.equals("svg:g") || tag.equals("g");
    }

    protected static Map<String, Object> getStylenames(String style) {
        if (style != null && style.length() > 0) {
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            if (style != null) {
                String[] pairs = style.split(";");
                for (int i = 0; i < pairs.length; ++i) {
                    String[] keyValue = pairs[i].split(":");
                    if (keyValue.length != 2) continue;
                    result.put(keyValue[0].trim(), keyValue[1].trim());
                }
            }
            return result;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Rectangle2D boundingBox) {
        this.boundingBox = boundingBox;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class svgShape {
        public Shape shape;
        protected Map<String, Object> style;
        public List<svgShape> subShapes;
        protected double currentXScale;
        protected double currentYScale;

        public svgShape(Shape shape, Map<String, Object> style) {
            this.shape = shape;
            this.style = style;
            this.subShapes = new ArrayList<svgShape>();
        }

        public double getCurrentXScale() {
            return this.currentXScale;
        }

        public void setCurrentXScale(double currentXScale) {
            this.currentXScale = currentXScale;
        }

        public double getCurrentYScale() {
            return this.currentYScale;
        }

        public void setCurrentYScale(double currentYScale) {
            this.currentYScale = currentYScale;
        }
    }
}

