/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.synthetic.diagnostic;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.synthetic.descriptors.AndroidSyntheticPackageFragmentDescriptor;
import org.jetbrains.kotlin.android.synthetic.diagnostic.DefaultErrorMessagesAndroid;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.android.synthetic.res.AndroidSyntheticProperty;
import org.jetbrains.kotlin.android.synthetic.res.SyntheticDescriptorGenerationKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u0004*\u00020\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/android/synthetic/diagnostic/AndroidExtensionPropertiesCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findLeftOutermostQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtElement;", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkDeprecated", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "expression", "packageDescriptor", "Lorg/jetbrains/kotlin/android/synthetic/descriptors/AndroidSyntheticPackageFragmentDescriptor;", "checkPartiallyDefinedResource", "property", "Lorg/jetbrains/kotlin/android/synthetic/res/AndroidSyntheticProperty;", "checkUnresolvedWidgetType", "android-extensions-compiler"})
public final class AndroidExtensionPropertiesCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        PsiElement psiElement2 = reportOn;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        if ((KtExpression)psiElement2 == null) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof PropertyDescriptor)) {
            obj = null;
        }
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)obj;
        if (propertyDescriptor2 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
        DeclarationDescriptor declarationDescriptor = propertyDescriptor3.getContainingDeclaration();
        if (!(declarationDescriptor instanceof AndroidSyntheticPackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        AndroidSyntheticPackageFragmentDescriptor androidSyntheticPackageFragmentDescriptor = (AndroidSyntheticPackageFragmentDescriptor)declarationDescriptor;
        if (androidSyntheticPackageFragmentDescriptor == null) {
            return;
        }
        AndroidSyntheticPackageFragmentDescriptor containingPackage = androidSyntheticPackageFragmentDescriptor;
        PropertyDescriptor propertyDescriptor4 = propertyDescriptor3;
        if (!(propertyDescriptor4 instanceof AndroidSyntheticProperty)) {
            propertyDescriptor4 = null;
        }
        AndroidSyntheticProperty androidSyntheticProperty = (AndroidSyntheticProperty)((Object)propertyDescriptor4);
        if (androidSyntheticProperty == null) {
            return;
        }
        AndroidSyntheticProperty androidSyntheticProperty2 = androidSyntheticProperty;
        BindingTrace bindingTrace = context2.getTrace();
        boolean bl = false;
        boolean bl2 = false;
        BindingTrace $this$with = bindingTrace;
        boolean bl3 = false;
        this.checkUnresolvedWidgetType($this$with, (KtExpression)reportOn, androidSyntheticProperty2);
        this.checkDeprecated($this$with, (KtExpression)reportOn, containingPackage);
        this.checkPartiallyDefinedResource($this$with, resolvedCall2, androidSyntheticProperty2, context2);
    }

    private final void checkDeprecated(@NotNull DiagnosticSink $this$checkDeprecated, KtExpression expression2, AndroidSyntheticPackageFragmentDescriptor packageDescriptor) {
        if (packageDescriptor.getPackageData().isDeprecated()) {
            DiagnosticUtilsKt.reportFromPlugin($this$checkDeprecated, (Diagnostic)ErrorsAndroid.SYNTHETIC_DEPRECATED_PACKAGE.on((KtExpression)((PsiElement)expression2)), DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    private final void checkUnresolvedWidgetType(@NotNull DiagnosticSink $this$checkUnresolvedWidgetType, KtExpression expression2, AndroidSyntheticProperty property2) {
        if (!SyntheticDescriptorGenerationKt.isErrorType(property2)) {
            return;
        }
        String string = property2.getErrorType();
        if (string == null) {
            return;
        }
        String type2 = string;
        DiagnosticFactory1<KtExpression, String> warning = StringsKt.contains$default((CharSequence)type2, (char)'.', (boolean)false, (int)2, null) ? ErrorsAndroid.SYNTHETIC_UNRESOLVED_WIDGET_TYPE : ErrorsAndroid.SYNTHETIC_INVALID_WIDGET_TYPE;
        DiagnosticUtilsKt.reportFromPlugin($this$checkUnresolvedWidgetType, (Diagnostic)warning.on((KtExpression)((PsiElement)expression2), type2), DefaultErrorMessagesAndroid.INSTANCE);
    }

    private final void checkPartiallyDefinedResource(@NotNull DiagnosticSink $this$checkPartiallyDefinedResource, ResolvedCall<?> resolvedCall2, AndroidSyntheticProperty property2, CallCheckerContext context2) {
        if (!property2.getResource().getPartiallyDefined()) {
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"resolvedCall.call.calleeExpression ?: return");
        KtExpression calleeExpression2 = ktExpression;
        KotlinType kotlinType2 = context2.getResolutionContext().expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.resolutionContext.expectedType");
        KotlinType expectedType = kotlinType2;
        if (!(TypeUtils.noExpectedType(expectedType) || expectedType.isMarkedNullable() || FlexibleTypesKt.isFlexible(expectedType))) {
            DiagnosticUtilsKt.reportFromPlugin($this$checkPartiallyDefinedResource, (Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((KtExpression)((PsiElement)calleeExpression2)), DefaultErrorMessagesAndroid.INSTANCE);
            return;
        }
        KtElement ktElement = this.findLeftOutermostQualifiedExpression(calleeExpression2);
        if (ktElement == null) {
            return;
        }
        KtElement outermostQualifiedExpression = ktElement;
        PsiElement usage = outermostQualifiedExpression.getParent();
        if (usage instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)usage).getReceiverExpression(), (Object)outermostQualifiedExpression)) {
            DiagnosticUtilsKt.reportFromPlugin($this$checkPartiallyDefinedResource, (Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((KtExpression)((PsiElement)calleeExpression2)), DefaultErrorMessagesAndroid.INSTANCE);
        }
    }

    private final KtElement findLeftOutermostQualifiedExpression(KtExpression calleeExpression2) {
        KtExpression ktExpression = calleeExpression2;
        if (ktExpression == null || (ktExpression = ktExpression.getParent()) == null) {
            return null;
        }
        KtExpression parent2 = ktExpression;
        if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getSelectorExpression(), (Object)calleeExpression2)) {
            return this.findLeftOutermostQualifiedExpression(parent2);
        }
        return calleeExpression2;
    }
}

