/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KotlinLightReferenceListBuilder
extends LightReferenceListBuilder
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiJavaCodeReferenceElement[] myCachedRefs;
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public KotlinLightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, (Language)JavaLanguage.INSTANCE, role);
    }

    public KotlinLightReferenceListBuilder(PsiManager manager, Language language, PsiReferenceList.Role role) {
        super(manager, language, role);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
    }

    public void addReference(PsiClass aClass2) {
        this.addReference(aClass2.getQualifiedName());
    }

    public void addReference(String qualifiedName2) {
        PsiJavaCodeReferenceElement ref2 = this.myFactory.createReferenceElementByFQClassName(qualifiedName2, this.getResolveScope());
        this.myRefs.add(ref2);
    }

    public void addReference(PsiClassType type2) {
        PsiJavaCodeReferenceElement ref2 = this.myFactory.createReferenceElementByType(type2);
        this.myRefs.add(ref2);
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] refs = this.myCachedRefs;
        if (refs == null) {
            this.myCachedRefs = refs = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        }
        if (refs == null) {
            KotlinLightReferenceListBuilder.$$$reportNull$$$0(0);
        }
        return refs;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] types = this.myCachedTypes;
        if (types == null) {
            int size = this.myRefs.size();
            types = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i2 = 0; i2 < size; ++i2) {
                types[i2] = this.myFactory.createType(this.myRefs.get(i2));
            }
            this.myCachedTypes = types;
        }
        if (types == null) {
            KotlinLightReferenceListBuilder.$$$reportNull$$$0(1);
        }
        return types;
    }

    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/asJava/classes/KotlinLightReferenceListBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

