/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.VariableAsmNameManglingUtils;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    public static final boolean IS_BUILT_WITH_ASM6 = false;
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet((Object[])new Type[]{AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class)});
    private static final int NO_FLAG_LOCAL = 0;
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put((Object)Visibilities.PRIVATE, (Object)2).put((Object)Visibilities.PRIVATE_TO_THIS, (Object)2).put((Object)Visibilities.PROTECTED, (Object)4).put((Object)JavaVisibilities.PROTECTED_STATIC_VISIBILITY, (Object)4).put((Object)JavaVisibilities.PROTECTED_AND_PACKAGE, (Object)4).put((Object)Visibilities.PUBLIC, (Object)1).put((Object)Visibilities.INTERNAL, (Object)1).put((Object)Visibilities.LOCAL, (Object)0).put((Object)JavaVisibilities.PACKAGE_VISIBILITY, (Object)0).build();
    public static final String THIS = "this";
    public static final String THIS_IN_DEFAULT_IMPLS = "$this";
    public static final String LABELED_THIS_FIELD = "this_";
    public static final String INLINE_DECLARATION_SITE_THIS = "this_";
    public static final String LABELED_THIS_PARAMETER = "$this$";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    public static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String LOCAL_FUNCTION_VARIABLE_PREFIX = "$fun$";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static String getCapturedFieldName(@NotNull String originalName) {
        if (originalName == null) {
            AsmUtil.$$$reportNull$$$0(0);
        }
        String string = "$" + originalName;
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getNameForCapturedReceiverField(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(2);
        }
        if (bindingContext2 == null) {
            AsmUtil.$$$reportNull$$$0(3);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(4);
        }
        return AsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext2, languageVersionSettings, "this_", CAPTURED_RECEIVER_FIELD);
    }

    @NotNull
    public static String getNameForReceiverParameter(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(5);
        }
        if (bindingContext2 == null) {
            AsmUtil.$$$reportNull$$$0(6);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(7);
        }
        return AsmUtil.getLabeledThisNameForReceiver(descriptor2, bindingContext2, languageVersionSettings, LABELED_THIS_PARAMETER, RECEIVER_PARAMETER_NAME);
    }

    @NotNull
    private static String getLabeledThisNameForReceiver(@NotNull CallableDescriptor descriptor2, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull String prefix, @NotNull String defaultName) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(8);
        }
        if (bindingContext2 == null) {
            AsmUtil.$$$reportNull$$$0(9);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(11);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(12);
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.NewCapturedReceiverFieldNamingConvention)) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        Name callableName = null;
        if (descriptor2 instanceof FunctionDescriptor) {
            String labelName2 = bindingContext2.get(CodegenBinding.CALL_LABEL_FOR_LAMBDA_ARGUMENT, (FunctionDescriptor)descriptor2);
            if (labelName2 != null) {
                return AsmUtil.getLabeledThisName(labelName2, prefix, defaultName);
            }
            if (descriptor2 instanceof VariableAccessorDescriptor) {
                VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)descriptor2;
                callableName = accessor.getCorrespondingVariable().getName();
            }
        }
        if (callableName == null) {
            callableName = descriptor2.getName();
        }
        if (callableName.isSpecial()) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        return AsmUtil.getLabeledThisName(callableName.asString(), prefix, defaultName);
    }

    @NotNull
    public static String getLabeledThisName(@NotNull String callableName, @NotNull String prefix, @NotNull String defaultName) {
        if (callableName == null) {
            AsmUtil.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(16);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(17);
        }
        if (!Name.isValidIdentifier(callableName)) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = prefix + VariableAsmNameManglingUtils.mangleNameIfNeeded(callableName);
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        Type boxedType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(20);
        }
        Type type3 = (boxedType = AsmUtil.boxPrimitiveType(type2)) != null ? boxedType : type2;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(21);
        }
        return type3;
    }

    @NotNull
    public static Type boxType(@NotNull Type type2, @NotNull KotlinType kotlinType2, @NotNull KotlinTypeMapper typeMapper2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(22);
        }
        if (kotlinType2 == null) {
            AsmUtil.$$$reportNull$$$0(23);
        }
        if (typeMapper2 == null) {
            AsmUtil.$$$reportNull$$$0(24);
        }
        if (InlineClassesUtilsKt.isInlineClassType(kotlinType2)) {
            Type type3 = typeMapper2.mapTypeAsDeclaration(kotlinType2);
            if (type3 == null) {
                AsmUtil.$$$reportNull$$$0(25);
            }
            return type3;
        }
        Type boxedPrimitiveType = AsmUtil.boxPrimitiveType(type2);
        Type type4 = boxedPrimitiveType != null ? boxedPrimitiveType : type2;
        if (type4 == null) {
            AsmUtil.$$$reportNull$$$0(26);
        }
        return type4;
    }

    @Nullable
    private static Type boxPrimitiveType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(27);
        }
        return (jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type2.getSort()))) != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : null;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType;
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(28);
        }
        if ((primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType)) == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type2 = primitiveType;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(29);
        }
        return type2;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(30);
        }
        return (Type)primitiveTypeByBoxedType.get((Object)boxedType);
    }

    public static boolean isBoxedPrimitiveType(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(31);
        }
        return primitiveTypeByBoxedType.get((Object)boxedType) != null;
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (boxedOrPrimitiveType == null) {
            AsmUtil.$$$reportNull$$$0(32);
        }
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            Type type2 = boxedOrPrimitiveType;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(33);
            }
            return type2;
        }
        return AsmUtil.unboxType(boxedOrPrimitiveType);
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(34);
        }
        if (unboxedType == null) {
            AsmUtil.$$$reportNull$$$0(35);
        }
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(36);
        }
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        Type type3 = Type.getType((String)internalName.substring(1));
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(37);
        }
        return type3;
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        if (componentType == null) {
            AsmUtil.$$$reportNull$$$0(38);
        }
        Type type2 = Type.getType((String)("[" + componentType.getDescriptor()));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(39);
        }
        return type2;
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type2.getSort()));
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name2, @NotNull Type returnType2, Type ... parameterTypes2) {
        if (name2 == null) {
            AsmUtil.$$$reportNull$$$0(40);
        }
        if (returnType2 == null) {
            AsmUtil.$$$reportNull$$$0(41);
        }
        if (parameterTypes2 == null) {
            AsmUtil.$$$reportNull$$$0(42);
        }
        return new Method(name2, Type.getMethodDescriptor((Type)returnType2, (Type[])parameterTypes2));
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor2, OwnerKind kind2) {
        return (functionDescriptor2.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor2.getContainingDeclaration()) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor2)) && !AsmUtil.isStaticMethod(kind2, functionDescriptor2);
    }

    public static boolean isStaticMethod(OwnerKind kind2, CallableMemberDescriptor functionDescriptor2) {
        return AsmUtil.isStaticKind(kind2) || KotlinTypeMapper.isStaticAccessor(functionDescriptor2) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor2);
    }

    public static boolean isStaticKind(OwnerKind kind2) {
        return kind2 == OwnerKind.PACKAGE || kind2 == OwnerKind.DEFAULT_IMPLS || kind2 == OwnerKind.ERASED_INLINE_CLASS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor2, OwnerKind kind2, GenerationState state) {
        return AsmUtil.getMethodAsmFlags(functionDescriptor2, kind2, state.getDeprecationProvider());
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor2, OwnerKind kind2, DeprecationResolver deprecationResolver2) {
        DeclarationDescriptor containingDeclaration2;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor2, kind2, deprecationResolver2);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            flags |= flagAnnotation.getJvmFlag(functionDescriptor2.getOriginal());
        }
        if (functionDescriptor2.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor2)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor2.getModality() != Modality.FINAL || functionDescriptor2 instanceof ConstructorDescriptor || (containingDeclaration2 = functionDescriptor2.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration2).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind2, functionDescriptor2)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor2, kind2)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor2) || JvmAnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor2) || AsmUtil.isInlineClassWrapperConstructor(functionDescriptor2, kind2) || InlineClassDescriptorResolver.isSynthesizedBoxMethod(functionDescriptor2) || InlineClassDescriptorResolver.isSynthesizedUnboxMethod(functionDescriptor2)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static boolean isInlineClassWrapperConstructor(@NotNull FunctionDescriptor functionDescriptor2, @Nullable OwnerKind kind2) {
        if (functionDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(43);
        }
        if (!(functionDescriptor2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor2).getConstructedClass();
        return classDescriptor2.isInline() && kind2 == OwnerKind.IMPLEMENTATION;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor2, @NotNull GenerationState state) {
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(44);
        }
        return AsmUtil.getCommonCallableFlags(functionDescriptor2, null, state.getDeprecationProvider());
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor2, @Nullable OwnerKind kind2, @NotNull DeprecationResolver deprecationResolver2) {
        if (deprecationResolver2 == null) {
            AsmUtil.$$$reportNull$$$0(45);
        }
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor2, kind2);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor2);
        flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor2);
        if (deprecationResolver2.isDeprecatedHidden(functionDescriptor2) || InlineOnlyKt.isInlineWithReified(functionDescriptor2) || functionDescriptor2.isSuspend() && functionDescriptor2.getVisibility().equals(Visibilities.PRIVATE)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(46);
        }
        return AsmUtil.getVisibilityAccessFlag(descriptor2, null);
    }

    private static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2, @Nullable OwnerKind kind2) {
        Integer specialCase;
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(47);
        }
        if ((specialCase = AsmUtil.specialCaseVisibility(descriptor2, kind2)) != null) {
            return specialCase;
        }
        Visibility visibility2 = descriptor2.getVisibility();
        Integer defaultMapping = AsmUtil.getVisibilityAccessFlag(visibility2);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility2 + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility2) {
        return visibilityToAccessFlag.get(visibility2);
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(48);
        }
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (ExpectedActualDeclarationChecker.isOptionalAnnotationClass(descriptor2)) {
            return 0;
        }
        if (descriptor2.getKind() == ClassKind.ENUM_ENTRY) {
            return 0;
        }
        if (descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.PROTECTED || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(49);
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int getSyntheticAccessFlagForLambdaClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(50);
        }
        return descriptor2 instanceof SyntheticClassDescriptorForLambda && ((SyntheticClassDescriptorForLambda)descriptor2).isCallableReference() ? 4096 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(51);
        }
        int visibility2 = innerClass instanceof SyntheticClassDescriptorForLambda ? AsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility2 | AsmUtil.getSyntheticAccessFlagForLambdaClass(innerClass) | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            AsmUtil.$$$reportNull$$$0(52);
        }
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality2 = innerClass.getModality();
        if (modality2 == Modality.FINAL) {
            return 16;
        }
        if (modality2 == Modality.ABSTRACT || modality2 == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(53);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor2) {
        if (!functionDescriptor2.getValueParameters().isEmpty() && functionDescriptor2.getValueParameters().get(functionDescriptor2.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor, @Nullable OwnerKind kind2) {
        PropertyDescriptor property2;
        if (memberDescriptor == null) {
            AsmUtil.$$$reportNull$$$0(54);
        }
        DeclarationDescriptor containingDeclaration2 = memberDescriptor.getContainingDeclaration();
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (JvmCodegenUtil.isNonIntrinsicPrivateCompanionObjectInInterface(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof FunctionDescriptor && AsmUtil.isInlineClassWrapperConstructor((FunctionDescriptor)memberDescriptor, kind2)) {
            return 2;
        }
        if (kind2 != OwnerKind.ERASED_INLINE_CLASS && memberDescriptor instanceof ConstructorDescriptor && !(memberDescriptor instanceof AccessorForConstructorDescriptor) && InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters((ConstructorDescriptor)memberDescriptor)) {
            return 2;
        }
        if (InlineOnlyKt.isInlineOnlyPrivateInBytecode(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return AsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property2 = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor2 = method = memberDescriptor == property2.getGetter() ? ((SyntheticJavaPropertyDescriptor)property2).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property2).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property2;
            return AsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == Visibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)memberDescriptor).isSuspend()) {
            return 0;
        }
        if (memberDescriptor instanceof AccessorForCompanionObjectInstanceFieldDescriptor) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isEnumEntry(containingDeclaration2)) {
            return 0;
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(55);
        }
        if (exception == null) {
            AsmUtil.$$$reportNull$$$0(56);
        }
        v.anew(Type.getObjectType((String)exception));
        v.dup();
        if (message2 != null) {
            v.aconst((Object)message2);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v, KotlinTypeMapper typeMapper2, @NotNull LanguageVersionSettings languageVersionSettings) {
        KotlinType captureReceiverType;
        if (closure == null) {
            AsmUtil.$$$reportNull$$$0(57);
        }
        if (languageVersionSettings == null) {
            AsmUtil.$$$reportNull$$$0(58);
        }
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
        if (captureThis != null) {
            allFields.add(Pair.create((Object)CAPTURED_THIS_FIELD, (Object)typeMapper2.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCapturedReceiverFromOuterContext()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            String fieldName = closure.getCapturedReceiverFieldName(typeMapper2.getBindingContext(), languageVersionSettings);
            allFields.add((Pair<String, Type>)Pair.create((Object)fieldName, (Object)typeMapper2.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field2 : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field2.first, ((Type)field2.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info2, int index2, InstructionAdapter iv) {
        return AsmUtil.genAssignInstanceFieldFromParam(info2, index2, iv, 0, false);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info2, int index2, InstructionAdapter iv, int ownerIndex, boolean cast) {
        assert (!info2.isStatic());
        Type fieldType = info2.getFieldType();
        KotlinType fieldKotlinType = info2.getFieldKotlinType();
        SimpleType nullableAny = fieldKotlinType != null ? fieldKotlinType.getConstructor().getBuiltIns().getNullableAnyType() : null;
        iv.load(ownerIndex, info2.getOwnerType());
        if (cast) {
            iv.load(index2, AsmTypes.OBJECT_TYPE);
            StackValue.coerce(AsmTypes.OBJECT_TYPE, nullableAny, fieldType, fieldKotlinType, iv);
        } else {
            iv.load(index2, fieldType);
        }
        iv.visitFieldInsn(181, info2.getOwnerInternalName(), info2.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(59);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(60);
        }
        AsmUtil.genInvokeAppendMethod(v, type2, kotlinType2, null);
    }

    public static void genInvokeAppendMethod(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType2, @Nullable KotlinTypeMapper typeMapper2) {
        Type appendParameterType;
        CallableMethod specializedToString;
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(61);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(62);
        }
        if ((specializedToString = AsmUtil.getSpecializedToStringCallableMethodOrNull(kotlinType2, typeMapper2)) != null) {
            specializedToString.genInvokeInstruction(v);
            appendParameterType = AsmTypes.JAVA_STRING_TYPE;
        } else if (kotlinType2 != null && InlineClassesUtilsKt.isInlineClassType(kotlinType2)) {
            appendParameterType = AsmTypes.OBJECT_TYPE;
            SimpleType nullableAnyType = kotlinType2.getConstructor().getBuiltIns().getNullableAnyType();
            StackValue.coerce(type2, kotlinType2, appendParameterType, nullableAnyType, v);
        } else {
            appendParameterType = AsmUtil.stringBuilderAppendType(type2);
        }
        v.invokevirtual("java/lang/StringBuilder", "append", "(" + appendParameterType.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(@NotNull StackValue receiver2, @NotNull Type receiverType2, @Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper2) {
        if (receiver2 == null) {
            AsmUtil.$$$reportNull$$$0(63);
        }
        if (receiverType2 == null) {
            AsmUtil.$$$reportNull$$$0(64);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            SimpleType kotlinType2;
            Type type2;
            CallableMethod specializedToString = AsmUtil.getSpecializedToStringCallableMethodOrNull(receiverKotlinType, typeMapper2);
            if (specializedToString != null) {
                receiver2.put(receiverType2, receiverKotlinType, (InstructionAdapter)v);
                specializedToString.genInvokeInstruction((InstructionAdapter)v);
                return null;
            }
            if (receiverKotlinType != null && InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
                type2 = AsmTypes.OBJECT_TYPE;
                kotlinType2 = receiverKotlinType.getConstructor().getBuiltIns().getNullableAnyType();
            } else {
                type2 = AsmUtil.stringValueOfType(receiverType2);
                kotlinType2 = null;
            }
            receiver2.put(type2, kotlinType2, (InstructionAdapter)v);
            v.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        }));
    }

    @Nullable
    private static CallableMethod getSpecializedToStringCallableMethodOrNull(@Nullable KotlinType receiverKotlinType, @Nullable KotlinTypeMapper typeMapper2) {
        if (typeMapper2 == null) {
            return null;
        }
        if (receiverKotlinType == null) {
            return null;
        }
        if (!InlineClassesUtilsKt.isInlineClassType(receiverKotlinType)) {
            return null;
        }
        if (receiverKotlinType.isMarkedNullable()) {
            return null;
        }
        ClassifierDescriptor receiverTypeDescriptor = receiverKotlinType.getConstructor().getDeclarationDescriptor();
        assert (receiverTypeDescriptor instanceof ClassDescriptor && ((ClassDescriptor)receiverTypeDescriptor).isInline()) : "Inline class type expected: " + receiverKotlinType;
        ClassDescriptor receiverClassDescriptor = (ClassDescriptor)receiverTypeDescriptor;
        FunctionDescriptor toStringDescriptor = receiverClassDescriptor.getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("toString"), NoLookupLocation.FROM_BACKEND).stream().filter(f2 -> f2.getValueParameters().size() == 0 && KotlinBuiltIns.isString(f2.getReturnType()) && f2.getDispatchReceiverParameter() != null && f2.getExtensionReceiverParameter() == null).findFirst().orElseThrow(() -> new AssertionError((Object)("'toString' not found in member scope of " + receiverClassDescriptor)));
        return typeMapper2.mapToCallableMethod(toStringDescriptor, false, OwnerKind.ERASED_INLINE_CLASS);
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    public static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left2, @NotNull StackValue right2) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(65);
        }
        if (left2 == null) {
            AsmUtil.$$$reportNull$$$0(66);
        }
        if (right2 == null) {
            AsmUtil.$$$reportNull$$$0(67);
        }
        Type leftType = left2.type;
        Type rightType = right2.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            StackValue stackValue = StackValue.cmp(opToken, leftType, left2, right2);
            if (stackValue == null) {
                AsmUtil.$$$reportNull$$$0(68);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            left2.put(AsmTypes.OBJECT_TYPE, left2.kotlinType, (InstructionAdapter)v);
            right2.put(AsmTypes.OBJECT_TYPE, right2.kotlinType, (InstructionAdapter)v);
            return AsmUtil.genAreEqualCall(v, opToken);
        }));
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(69);
        }
        return stackValue;
    }

    @NotNull
    public static StackValue genEqualsBoxedOnStack(@NotNull IElementType opToken) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(70);
        }
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> AsmUtil.genAreEqualCall(v, opToken)));
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(71);
        }
        return stackValue;
    }

    public static void genAreEqualCall(InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    @NotNull
    private static Unit genAreEqualCall(InstructionAdapter v, @NotNull IElementType opToken) {
        if (opToken == null) {
            AsmUtil.$$$reportNull$$$0(72);
        }
        AsmUtil.genAreEqualCall(v);
        if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
            AsmUtil.genInvertBoolean(v);
        }
        Unit unit = Unit.INSTANCE;
        if (unit == null) {
            AsmUtil.$$$reportNull$$$0(73);
        }
        return unit;
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v, Type left2, Type right2) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left2.getDescriptor() + right2.getDescriptor() + ")Z", false);
    }

    public static void numConst(int value2, Type type2, InstructionAdapter v) {
        if (type2 == Type.FLOAT_TYPE) {
            v.fconst((float)value2);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.dconst((double)value2);
        } else if (type2 == Type.LONG_TYPE) {
            v.lconst((long)value2);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v.iconst(value2);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void genIncrement(Type baseType, int myDelta, InstructionAdapter v) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType);
        AsmUtil.numConst(myDelta, operationType, v);
        v.add(operationType);
        StackValue.coerce(operationType, baseType, v);
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(74);
        }
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(75);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(76);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(77);
        }
        if (state.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                String name2 = AsmUtil.getNameForReceiverParameter(descriptor2, state.getBindingContext(), state.getLanguageVersionSettings());
                AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, receiverParameter, name2, descriptor2);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            String name3 = AsmUtil.getNameForReceiverParameter(descriptor2, state.getBindingContext(), state.getLanguageVersionSettings());
            AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, receiverParameter, name3, descriptor2);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, parameter, parameter.getName().asString(), descriptor2);
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v, @NotNull KotlinTypeMapper typeMapper2, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name2, @NotNull FunctionDescriptor containingDeclaration2) {
        KotlinType type2;
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(78);
        }
        if (typeMapper2 == null) {
            AsmUtil.$$$reportNull$$$0(79);
        }
        if (frameMap == null) {
            AsmUtil.$$$reportNull$$$0(80);
        }
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(81);
        }
        if (name2 == null) {
            AsmUtil.$$$reportNull$$$0(82);
        }
        if (containingDeclaration2 == null) {
            AsmUtil.$$$reportNull$$$0(83);
        }
        if (TypeUtils.isNullableType(type2 = parameter.getType()) || InlineClassesUtilsKt.isNullableUnderlyingType(type2)) {
            return;
        }
        Type asmType = typeMapper2.mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            StackValue value2;
            if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(containingDeclaration2) || JvmCodegenUtil.isDeclarationOfBigArityCreateCoroutineMethod(containingDeclaration2)) {
                int index2 = AsmUtil.getIndexOfParameterInVarargInvokeArray(parameter);
                value2 = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE)), StackValue.constant(index2));
            } else {
                int index3 = frameMap.getIndex(parameter);
                value2 = StackValue.local(index3, asmType);
            }
            value2.put(asmType, v);
            v.visitLdcInsn((Object)name2);
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkParameterIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(@NotNull GenerationState state, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state == null) {
            AsmUtil.$$$reportNull$$$0(84);
        }
        if (stackValue == null) {
            AsmUtil.$$$reportNull$$$0(85);
        }
        if (state.isCallAssertionsDisabled()) {
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                AsmUtil.$$$reportNull$$$0(86);
            }
            return stackValue2;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            StackValue stackValue3 = stackValue;
            if (stackValue3 == null) {
                AsmUtil.$$$reportNull$$$0(87);
            }
            return stackValue3;
        }
        return new StackValue(stackValue.type, stackValue.kotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    1.$$$reportNull$$$0(1);
                }
                Type innerType = stackValue.type;
                KotlinType innerKotlinType = stackValue.kotlinType;
                stackValue.put(innerType, innerKotlinType, v);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v.dup();
                    v.visitLdcInsn((Object)runtimeAssertionInfo.getMessage());
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkExpressionValueIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, innerKotlinType, type2, kotlinType2, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/AsmUtil$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static int getIndexOfParameterInVarargInvokeArray(@NotNull ParameterDescriptor parameter) {
        if (parameter == null) {
            AsmUtil.$$$reportNull$$$0(88);
        }
        if (parameter instanceof ReceiverParameterDescriptor) {
            return 0;
        }
        DeclarationDescriptor container2 = parameter.getContainingDeclaration();
        assert (parameter instanceof ValueParameterDescriptor) : "Non-extension-receiver parameter must be a value parameter: " + parameter;
        int extensionShift = ((CallableDescriptor)container2).getExtensionReceiverParameter() == null ? 0 : 1;
        return extensionShift + ((ValueParameterDescriptor)parameter).getIndex();
    }

    public static void generateVarargInvokeArityAssert(InstructionAdapter v, int functionArity) {
        Label start2 = new Label();
        v.load(1, AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE));
        v.arraylength();
        v.iconst(functionArity);
        v.ificmpeq(start2);
        v.visitLdcInsn((Object)("Vararg argument must contain " + functionArity + " elements."));
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwIllegalArgument", "(Ljava/lang/String;)V", false);
        v.visitLabel(start2);
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(89);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(90);
        }
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(91);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(92);
        }
        if (type2.getSort() == 6) {
            v.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v.lconst(0L);
        } else {
            v.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(93);
        }
        return propertyDescriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor2.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor2, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(94);
        }
        boolean bl = isExtensionProperty = propertyDescriptor2.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor2.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor2) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor2)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(95);
        }
        if (!propertyDescriptor2.isVar()) {
            return propertyDescriptor2;
        }
        return propertyDescriptor2.getSetter() != null ? propertyDescriptor2.getSetter() : propertyDescriptor2;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor2) {
        if (propertyDescriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(96);
        }
        DeclarationDescriptor propertyContainer = propertyDescriptor2.getContainingDeclaration();
        return propertyDescriptor2.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && JvmCodegenUtil.isJvmInterface(propertyContainer.getContainingDeclaration()) && AsmUtil.getVisibilityForBackingField(propertyDescriptor2, false) == 1;
    }

    public static Type comparisonOperandType(Type left2, Type right2) {
        if (left2 == Type.DOUBLE_TYPE || right2 == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left2 == Type.FLOAT_TYPE || right2 == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left2 == Type.LONG_TYPE || right2 == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left2 == Type.CHAR_TYPE || right2 == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            AsmUtil.$$$reportNull$$$0(97);
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            Type type2 = Type.INT_TYPE;
            if (type2 == null) {
                AsmUtil.$$$reportNull$$$0(98);
            }
            return type2;
        }
        Type type3 = expectedType;
        if (type3 == null) {
            AsmUtil.$$$reportNull$$$0(99);
        }
        return type3;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(100);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(101);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(102);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(103);
        }
        if (type2.getSize() == 2) {
            v.visitInsn(88);
            v.visitInsn(88);
        } else {
            v.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(104);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(105);
        }
        AsmUtil.dup(v, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(106);
        }
        if (size == 2) {
            v.dup2();
        } else if (size == 1) {
            v.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(107);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(108);
        }
        AsmUtil.dupx(v, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v, int size) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(109);
        }
        if (size == 2) {
            v.dup2X2();
        } else if (size == 1) {
            v.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(110);
        }
        if (topOfStack == null) {
            AsmUtil.$$$reportNull$$$0(111);
        }
        if (afterTop == null) {
            AsmUtil.$$$reportNull$$$0(112);
        }
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v, 2);
            } else {
                v.dup2X1();
                v.pop2();
                v.dupX2();
                v.dupX2();
                v.pop();
                v.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer2, @NotNull MessageLite message2) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(113);
        }
        if (serializer2 == null) {
            AsmUtil.$$$reportNull$$$0(114);
        }
        if (message2 == null) {
            AsmUtil.$$$reportNull$$$0(115);
        }
        AsmUtil.writeAnnotationData(av, message2, (JvmStringTable)((Object)serializer2.getStringTable()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull MessageLite message2, @NotNull JvmStringTable stringTable) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(116);
        }
        if (message2 == null) {
            AsmUtil.$$$reportNull$$$0(117);
        }
        if (stringTable == null) {
            AsmUtil.$$$reportNull$$$0(118);
        }
        AsmUtil.writeAnnotationData(av, JvmProtoBufUtil.writeData(message2, stringTable), ArrayUtil.toStringArray(stringTable.getStrings()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(119);
        }
        if (data == null) {
            AsmUtil.$$$reportNull$$$0(120);
        }
        if (strings == null) {
            AsmUtil.$$$reportNull$$$0(121);
        }
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string : data) {
            dataVisitor.visit(null, (Object)string);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string : strings) {
            stringsVisitor.visit(null, (Object)string);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(122);
        }
        Type type2 = Type.getObjectType((String)AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(123);
        }
        return type2;
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            AsmUtil.$$$reportNull$$$0(124);
        }
        Type type2 = Type.getObjectType((String)classId.asString().replace('.', '$'));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(125);
        }
        return type2;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            AsmUtil.$$$reportNull$$$0(126);
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(127);
        }
        return string;
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type2, @Nullable KotlinType kotlinType2, @NotNull KotlinTypeMapper typeMapper2) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(128);
        }
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(129);
        }
        if (typeMapper2 == null) {
            AsmUtil.$$$reportNull$$$0(130);
        }
        if (kotlinType2 != null && InlineClassesUtilsKt.isInlineClassType(kotlinType2)) {
            v.aconst((Object)AsmUtil.boxType(type2, kotlinType2, typeMapper2));
        } else if (AsmUtil.isPrimitive(type2)) {
            v.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst((Object)type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(131);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_TYPE, (Type[])new Type[]{AsmTypes.getType(Class.class)}), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(132);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_ARRAY_TYPE, (Type[])new Type[]{AsmTypes.getType(Class[].class)}), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context2, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind2;
        if (context2 == null) {
            AsmUtil.$$$reportNull$$$0(133);
        }
        if (descriptor2 == null) {
            AsmUtil.$$$reportNull$$$0(134);
        }
        return (kind2 = context2.getContextKind()) != OwnerKind.DEFAULT_IMPLS && AsmUtil.isStaticMethod(kind2, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType((String)primitiveType.getDesc());
            typeBySortBuilder.put((Object)asmType.getSort(), (Object)primitiveType);
            typeByWrapperBuilder.put((Object)AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), (Object)asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 123: 
            case 125: 
            case 127: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 123: 
            case 125: 
            case 127: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 123: 
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 76: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableName";
                break;
            }
            case 20: 
            case 22: 
            case 27: 
            case 36: 
            case 60: 
            case 62: 
            case 89: 
            case 91: 
            case 101: 
            case 103: 
            case 105: 
            case 108: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 24: 
            case 79: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedOrPrimitiveType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxedType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 40: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 44: 
            case 75: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecationResolver";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 55: 
            case 59: 
            case 61: 
            case 74: 
            case 78: 
            case 90: 
            case 92: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 128: 
            case 131: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = BOUND_REFERENCE_RECEIVER;
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 65: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 81: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackValue";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOfStack";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterTop";
                break;
            }
            case 113: 
            case 116: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 115: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringTable";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 122: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedFieldName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisNameForReceiver";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisName";
                break;
            }
            case 21: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxUnlessPrimitive";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "correctElementType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsBoxedOnStack";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "genAreEqualCall";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "genNotNullAssertions";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "numberFunctionOperandType";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByClassId";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedFieldName";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 123: 
            case 125: 
            case 127: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForCapturedReceiverField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameForReceiverParameter";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisNameForReceiver";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisName";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unboxType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unboxPrimitiveTypeOrNull";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedPrimitiveType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unboxUnlessPrimitive";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedTypeOf";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "correctElementType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "method";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInlineClassWrapperConstructor";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCallableFlags";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlag";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAccessFlagForAnonymous";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticAccessFlagForLambdaClass";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "calculateInnerClassAccessFlags";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "innerAccessFlagsForModalityAndKind";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedAccessFlag";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "specialCaseVisibility";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "genThrow";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "genClosureFields";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "genInvokeAppendMethod";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "genToString";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsOnStack";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsBoxedOnStack";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "genAreEqualCall";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertionsForParameters";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "genParamAssertion";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "genNotNullAssertions";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfParameterInVarargInvokeArray";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultValueOnStack";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultPrimitiveValueOnStack";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isInstancePropertyWithStaticBackingField";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityForBackingField";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "descriptorForVisibility";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithBackingFieldCopyInOuterClass";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "numberFunctionOperandType";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "pop";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "pop2";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "dup";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "dupx";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByClassId";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "putJavaLangClassInstance";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassIntoKClass";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassesIntoKClasses";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 123: 
            case 125: 
            case 127: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

