/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerForMethod", "backend"})
public final class LabelNormalizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        new TransformerForMethod(methodNode).transform();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00172\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020#H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010%\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020#H\u0002J\u0006\u0010+\u001a\u00020#J\f\u0010,\u001a\u00020\u0017*\u00020\u0019H\u0002J\f\u0010,\u001a\u00020\u0017*\u00020\u001cH\u0002J\f\u0010,\u001a\u00020\u0017*\u00020!H\u0002J\f\u0010,\u001a\u00020\u0017*\u00020&H\u0002J\f\u0010,\u001a\u00020\u0017*\u00020)H\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR-\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "newLabelNodes", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/Label;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lkotlin/collections/HashMap;", "getNewLabelNodes", "()Ljava/util/HashMap;", "getNew", "oldLabelNode", "getNewOrOld", "rewriteFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "oldFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/FrameNode;", "rewriteJumpInsn", "oldJumpNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "rewriteLabelInstructions", "", "rewriteLineNumberNode", "oldLineNode", "Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;", "rewriteLocalVars", "", "rewriteLookupSwitchInsn", "oldSwitchNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "rewriteNonLabelInstructions", "rewriteTableSwitchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "rewriteTryCatchBlocks", "transform", "rewriteLabels", "backend"})
    private static final class TransformerForMethod {
        private final InsnList instructions;
        @NotNull
        private final HashMap<Label, LabelNode> newLabelNodes;
        @NotNull
        private final MethodNode methodNode;

        public final InsnList getInstructions() {
            return this.instructions;
        }

        @NotNull
        public final HashMap<Label, LabelNode> getNewLabelNodes() {
            return this.newLabelNodes;
        }

        public final void transform() {
            if (this.rewriteLabelInstructions()) {
                this.rewriteNonLabelInstructions();
                this.rewriteTryCatchBlocks();
                this.rewriteLocalVars();
                UtilKt.removeEmptyCatchBlocks(this.methodNode);
            }
        }

        private final boolean rewriteLabelInstructions() {
            boolean removedAnyLabels = false;
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            AbstractInsnNode thisNode = insnList.getFirst();
            while (thisNode != null) {
                if (thisNode instanceof LabelNode) {
                    AbstractInsnNode prevNode = ((LabelNode)thisNode).getPrevious();
                    if (prevNode instanceof LabelNode) {
                        Map map2 = this.newLabelNodes;
                        Label label2 = ((LabelNode)thisNode).getLabel();
                        Intrinsics.checkExpressionValueIsNotNull((Object)label2, (String)"thisNode.label");
                        map2.put(label2, prevNode);
                        removedAnyLabels = true;
                        InsnList insnList2 = this.instructions;
                        Intrinsics.checkExpressionValueIsNotNull((Object)insnList2, (String)"instructions");
                        thisNode = LabelNormalizationMethodTransformerKt.removeNodeGetNext(insnList2, thisNode);
                        continue;
                    }
                    Map map3 = this.newLabelNodes;
                    Label label3 = ((LabelNode)thisNode).getLabel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)label3, (String)"thisNode.label");
                    map3.put(label3, thisNode);
                    thisNode = ((LabelNode)thisNode).getNext();
                    continue;
                }
                thisNode = thisNode.getNext();
            }
            return removedAnyLabels;
        }

        private final void rewriteNonLabelInstructions() {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            AbstractInsnNode thisNode = insnList.getFirst();
            while (thisNode != null) {
                AbstractInsnNode abstractInsnNode = thisNode;
                thisNode = abstractInsnNode instanceof JumpInsnNode ? this.rewriteJumpInsn((JumpInsnNode)thisNode) : (abstractInsnNode instanceof LineNumberNode ? this.rewriteLineNumberNode((LineNumberNode)thisNode) : (abstractInsnNode instanceof LookupSwitchInsnNode ? this.rewriteLookupSwitchInsn((LookupSwitchInsnNode)thisNode) : (abstractInsnNode instanceof TableSwitchInsnNode ? this.rewriteTableSwitchInsn((TableSwitchInsnNode)thisNode) : (abstractInsnNode instanceof FrameNode ? this.rewriteFrameNode((FrameNode)thisNode) : thisNode.getNext()))));
            }
        }

        private final AbstractInsnNode rewriteLineNumberNode(LineNumberNode oldLineNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldLineNode, this.rewriteLabels(oldLineNode));
        }

        private final AbstractInsnNode rewriteJumpInsn(JumpInsnNode oldJumpNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldJumpNode, this.rewriteLabels(oldJumpNode));
        }

        private final AbstractInsnNode rewriteLookupSwitchInsn(LookupSwitchInsnNode oldSwitchNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteTableSwitchInsn(TableSwitchInsnNode oldSwitchNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteFrameNode(FrameNode oldFrameNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldFrameNode, this.rewriteLabels(oldFrameNode));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteTryCatchBlocks() {
            Collection<TryCatchBlockNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list2 = this.methodNode.tryCatchBlocks;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"methodNode.tryCatchBlocks");
            Iterable iterable = list2;
            MethodNode methodNode = this.methodNode;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oldTcb;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                LabelNode labelNode = oldTcb.start;
                Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"oldTcb.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldTcb.end;
                Intrinsics.checkExpressionValueIsNotNull((Object)labelNode3, (String)"oldTcb.end");
                LabelNode labelNode4 = this.getNew(labelNode3);
                LabelNode labelNode5 = oldTcb.handler;
                Intrinsics.checkExpressionValueIsNotNull((Object)labelNode5, (String)"oldTcb.handler");
                TryCatchBlockNode newTcb = new TryCatchBlockNode(labelNode2, labelNode4, this.getNew(labelNode5), oldTcb.type);
                newTcb.visibleTypeAnnotations = oldTcb.visibleTypeAnnotations;
                newTcb.invisibleTypeAnnotations = oldTcb.invisibleTypeAnnotations;
                TryCatchBlockNode tryCatchBlockNode2 = newTcb;
                collection.add(tryCatchBlockNode2);
            }
            collection = (List)destination$iv$iv;
            methodNode.tryCatchBlocks = collection;
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteLocalVars() {
            Collection<LocalVariableNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list2 = this.methodNode.localVariables;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"methodNode.localVariables");
            Iterable iterable = list2;
            MethodNode methodNode = this.methodNode;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oldVar;
                LocalVariableNode localVariableNode = (LocalVariableNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = oldVar.name;
                String string2 = oldVar.desc;
                String string3 = oldVar.signature;
                LabelNode labelNode = oldVar.start;
                Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"oldVar.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                LabelNode labelNode3 = oldVar.end;
                Intrinsics.checkExpressionValueIsNotNull((Object)labelNode3, (String)"oldVar.end");
                LocalVariableNode localVariableNode2 = new LocalVariableNode(string, string2, string3, labelNode2, this.getNew(labelNode3), oldVar.index);
                collection.add(localVariableNode2);
            }
            collection = (List)destination$iv$iv;
            methodNode.localVariables = collection;
        }

        private final AbstractInsnNode rewriteLabels(@NotNull LineNumberNode $this$rewriteLabels) {
            int n = $this$rewriteLabels.line;
            LabelNode labelNode = $this$rewriteLabels.start;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"start");
            return (AbstractInsnNode)new LineNumberNode(n, this.getNewOrOld(labelNode));
        }

        private final AbstractInsnNode rewriteLabels(@NotNull JumpInsnNode $this$rewriteLabels) {
            int n = $this$rewriteLabels.getOpcode();
            LabelNode labelNode = $this$rewriteLabels.label;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"label");
            return (AbstractInsnNode)new JumpInsnNode(n, this.getNew(labelNode));
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(@NotNull LookupSwitchInsnNode $this$rewriteLabels) {
            Collection<LabelNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LabelNode[] labelNodeArray;
            LabelNode labelNode = $this$rewriteLabels.dflt;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"dflt");
            LabelNode labelNode2 = this.getNew(labelNode);
            List list2 = $this$rewriteLabels.keys;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"keys");
            int[] nArray = CollectionsKt.toIntArray((Collection)list2);
            LabelNode labelNode3 = labelNode2;
            LabelNode[] labelNodeArray2 = labelNodeArray = new LabelNode[0];
            int[] nArray2 = nArray;
            LabelNode labelNode4 = labelNode3;
            LookupSwitchInsnNode switchNode = new LookupSwitchInsnNode(labelNode4, nArray2, labelNodeArray2);
            List list3 = $this$rewriteLabels.labels;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"labels");
            Iterable iterable = list3;
            LookupSwitchInsnNode lookupSwitchInsnNode = switchNode;
            boolean $i$f$map = false;
            void var5_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LabelNode labelNode5 = (LabelNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                labelNode3 = this.getNew((LabelNode)v4);
                collection.add(labelNode3);
            }
            collection = (List)destination$iv$iv;
            lookupSwitchInsnNode.labels = collection;
            return (AbstractInsnNode)switchNode;
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(@NotNull TableSwitchInsnNode $this$rewriteLabels) {
            Collection<LabelNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n = $this$rewriteLabels.min;
            int n2 = $this$rewriteLabels.max;
            LabelNode labelNode = $this$rewriteLabels.dflt;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"dflt");
            TableSwitchInsnNode switchNode = new TableSwitchInsnNode(n, n2, this.getNew(labelNode), new LabelNode[0]);
            List list2 = $this$rewriteLabels.labels;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"labels");
            Iterable iterable = list2;
            TableSwitchInsnNode tableSwitchInsnNode = switchNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LabelNode labelNode2 = (LabelNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                LabelNode labelNode3 = this.getNew((LabelNode)v4);
                collection.add(labelNode3);
            }
            collection = (List)destination$iv$iv;
            tableSwitchInsnNode.labels = collection;
            return (AbstractInsnNode)switchNode;
        }

        private final AbstractInsnNode rewriteLabels(@NotNull FrameNode $this$rewriteLabels) {
            Object it;
            Collection collection;
            Object item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object[] objectArray;
            int n = 0;
            int n2 = $this$rewriteLabels.type;
            Object[] objectArray2 = new Object[]{};
            int n3 = 0;
            Object[] objectArray3 = objectArray = new Object[0];
            int n4 = n3;
            Object[] objectArray4 = objectArray2;
            int n5 = n;
            int n6 = n2;
            FrameNode frameNode = new FrameNode(n6, n5, objectArray4, n4, objectArray3);
            List list2 = $this$rewriteLabels.local;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"local");
            Iterable iterable = list2;
            FrameNode frameNode2 = frameNode;
            boolean $i$f$map = false;
            void var5_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                void var14_4 = it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it;
                collection.add(var14_4);
            }
            collection = (List)destination$iv$iv;
            frameNode2.local = collection;
            List list3 = $this$rewriteLabels.stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"stack");
            $this$map$iv = list3;
            frameNode2 = frameNode;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                Object t = it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it;
                collection.add(t);
            }
            collection = (List)destination$iv$iv;
            frameNode2.stack = collection;
            return (AbstractInsnNode)frameNode;
        }

        private final LabelNode getNew(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode.getLabel());
            if (labelNode == null) {
                throw (Throwable)new IllegalStateException("Label wasn't found during iterating through instructions");
            }
            return labelNode;
        }

        private final LabelNode getNewOrOld(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode.getLabel());
            if (labelNode == null) {
                labelNode = oldLabelNode;
            }
            return labelNode;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public TransformerForMethod(@NotNull MethodNode methodNode) {
            Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
            this.methodNode = methodNode;
            this.instructions = this.methodNode.instructions;
            TransformerForMethod transformerForMethod = this;
            boolean bl = false;
            HashMap hashMap = new HashMap();
            transformerForMethod.newLabelNodes = hashMap;
        }
    }
}

