/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.HistoryUpdater;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/console/CommandExecutor;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "commandHistory", "Lorg/jetbrains/kotlin/console/CommandHistory;", "historyUpdater", "Lorg/jetbrains/kotlin/console/HistoryUpdater;", "executeCommand", "", "getTrimmedCommandText", "", "sendCommandToProcess", "command", "idea"})
public final class CommandExecutor {
    private final CommandHistory commandHistory;
    private final HistoryUpdater historyUpdater;
    private final KotlinConsoleRunner runner;

    public final void executeCommand() {
        WriteCommandAction.runWriteCommandAction((Project)this.runner.getProject(), (Runnable)new Runnable(this){
            final /* synthetic */ CommandExecutor this$0;

            public final void run() {
                String commandText = CommandExecutor.access$getTrimmedCommandText(this.this$0);
                CharSequence charSequence = commandText;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return;
                }
                TextRange historyDocumentRange = CommandExecutor.access$getHistoryUpdater$p(this.this$0).printNewCommandInHistory(commandText);
                CommandExecutor.access$getCommandHistory$p(this.this$0).addEntry(new CommandHistory.Entry(commandText, historyDocumentRange));
                CommandExecutor.access$sendCommandToProcess(this.this$0, commandText);
            }
            {
                this.this$0 = commandExecutor;
            }
        });
    }

    private final String getTrimmedCommandText() {
        LanguageConsoleView consoleView2;
        LanguageConsoleView languageConsoleView = consoleView2 = this.runner.getConsoleView();
        Intrinsics.checkExpressionValueIsNotNull((Object)languageConsoleView, (String)"consoleView");
        Document document = languageConsoleView.getEditorDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"consoleView.editorDocument");
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    private final void sendCommandToProcess(String command2) {
        Object object;
        ProcessHandler processHandler;
        ProcessHandler processHandler2 = processHandler = this.runner.getProcessHandler();
        Intrinsics.checkExpressionValueIsNotNull((Object)processHandler2, (String)"processHandler");
        OutputStream outputStream2 = processHandler2.getProcessInput();
        if (outputStream2 == null) {
            RunExecuteActionsKt.logError$default(this.getClass(), "<p>Broken process stream</p>", null, 4, null);
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"processHandler.processIn\u2026oken process stream</p>\")");
        OutputStream processInputOS = outputStream2;
        ProcessHandler processHandler3 = processHandler;
        if (!(processHandler3 instanceof BaseOSProcessHandler)) {
            processHandler3 = null;
        }
        if ((object = (BaseOSProcessHandler)processHandler3) == null || (object = object.getCharset()) == null) {
            object = Charsets.UTF_8;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(processHandler as? Base\u2026charset ?: Charsets.UTF_8");
        Object charset = object;
        String xmlRes = ReplUtilKt.replInputAsXml(command2);
        String string = xmlRes + '\n';
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        processInputOS.write(bytes2);
        processInputOS.flush();
    }

    public CommandExecutor(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.commandHistory = this.runner.getCommandHistory();
        this.historyUpdater = new HistoryUpdater(this.runner);
    }

    public static final /* synthetic */ String access$getTrimmedCommandText(CommandExecutor $this) {
        return $this.getTrimmedCommandText();
    }

    public static final /* synthetic */ HistoryUpdater access$getHistoryUpdater$p(CommandExecutor $this) {
        return $this.historyUpdater;
    }

    public static final /* synthetic */ CommandHistory access$getCommandHistory$p(CommandExecutor $this) {
        return $this.commandHistory;
    }

    public static final /* synthetic */ void access$sendCommandToProcess(CommandExecutor $this, String command2) {
        $this.sendCommandToProcess(command2);
    }
}

