/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplOutputHandler$WhenMappings;
import org.jetbrains.kotlin.console.ReplOutputProcessor;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u001c\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\b\b\u0002\u0010#\u001a\u00020$H\u0002J\f\u0010%\u001a\u00020&*\u00020\u0007H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "process", "Ljava/lang/Process;", "commandLine", "", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;Ljava/lang/Process;Ljava/lang/String;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "inputBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isBuildInfoChecked", "", "outputProcessor", "Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "buildWarningIfNeededBeforeInit", "", "content", "createCompilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "runtimeErrorsReport", "handleReplMessage", "text", "isSilentlyDestroyOnClose", "notifyTextAvailable", "key", "Lcom/intellij/openapi/util/Key;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "toSeverity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "idea"})
public final class ReplOutputHandler
extends OSProcessHandler {
    private boolean isBuildInfoChecked;
    private final DocumentBuilderFactory factory;
    private final ReplOutputProcessor outputProcessor;
    private final StringBuilder inputBuffer;
    private final KotlinConsoleRunner runner;

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> key) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        if (StringsKt.startsWith$default((String)text2, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
            return;
        }
        if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
            this.inputBuffer.append(text2);
            String string = this.inputBuffer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputBuffer.toString()");
            String resultingText = string;
            if (StringsKt.endsWith$default((String)resultingText, (String)"\n", (boolean)false, (int)2, null)) {
                this.handleReplMessage(resultingText);
                this.inputBuffer.setLength(0);
            }
        } else {
            super.notifyTextAvailable(text2, key);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleReplMessage(String text2) {
        Document output;
        Document document;
        if (StringsKt.isBlank((CharSequence)text2)) {
            return;
        }
        try {
            document = this.factory.newDocumentBuilder().parse(ReplOutputHandler.strToSource$default(this, text2, null, 2, null));
        }
        catch (Exception e) {
            RunExecuteActionsKt.logError(ReplOutputHandler.class, "Couldn't parse REPL output: " + text2, e);
            return;
        }
        Document document2 = output = document;
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"output");
        Node node = document2.getFirstChild();
        if (node == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
        }
        Element root = (Element)node;
        String string = root.getAttribute("type");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root.getAttribute(\"type\")");
        ReplEscapeType outputType = ReplEscapeType.Companion.valueOfOrNull(string);
        String string2 = root.getTextContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"root.textContent");
        String content2 = ReplUtilKt.replNormalizeLineBreaks(ReplUtilKt.replUnescapeLineBreaks(string2));
        ReplEscapeType replEscapeType = outputType;
        if (replEscapeType == null) {
            RunExecuteActionsKt.logError$default(ReplOutputHandler.class, "Unexpected output type:\n" + (Object)((Object)outputType), null, 4, null);
        } else {
            switch (ReplOutputHandler$WhenMappings.$EnumSwitchMapping$0[replEscapeType.ordinal()]) {
                case 1: {
                    this.buildWarningIfNeededBeforeInit(content2);
                    break;
                }
                case 2: {
                    this.outputProcessor.printHelp(content2);
                    break;
                }
                case 3: {
                    this.outputProcessor.printUserOutput(content2);
                    break;
                }
                case 4: {
                    this.outputProcessor.printResultWithGutterIcon(content2);
                    break;
                }
                case 5: {
                    this.runner.setReadLineMode(true);
                    break;
                }
                case 6: {
                    this.runner.setReadLineMode(false);
                    break;
                }
                case 7: 
                case 8: {
                    this.outputProcessor.highlightCompilerErrors(this.createCompilerMessages(content2));
                    break;
                }
                case 9: {
                    String string3 = content2;
                    StringBuilder stringBuilder = new StringBuilder();
                    ReplOutputProcessor replOutputProcessor = this.outputProcessor;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                    replOutputProcessor.printRuntimeError(stringBuilder.append(string5).append('\n').toString());
                    break;
                }
                case 10: {
                    this.outputProcessor.printInternalErrorMessage(content2);
                    break;
                }
                case 11: {
                    Object object = this.runner.getCommandHistory().lastUnprocessedEntry();
                    if (object == null || (object = ((CommandHistory.Entry)object).getEntryText()) == null) break;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    this.runner.successfulLine((String)it);
                    break;
                }
            }
        }
        if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])new ReplEscapeType[]{ReplEscapeType.SUCCESS, ReplEscapeType.COMPILE_ERROR, ReplEscapeType.INTERNAL_ERROR, ReplEscapeType.RUNTIME_ERROR, ReplEscapeType.READLINE_END}), (Object)((Object)outputType))) {
            this.runner.getCommandHistory().entryProcessed();
        }
    }

    private final void buildWarningIfNeededBeforeInit(String content2) {
        if (!this.isBuildInfoChecked) {
            this.outputProcessor.printBuildInfoWarningIfNeeded();
            this.isBuildInfoChecked = true;
        }
        this.outputProcessor.printInitialPrompt(content2);
    }

    private final InputSource strToSource(String s, Charset encoding) {
        byte[] byArray;
        String string = s;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string2.getBytes(encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        InputStream inputStream = new ByteArrayInputStream(byArray3);
        return new InputSource(inputStream);
    }

    static /* synthetic */ InputSource strToSource$default(ReplOutputHandler replOutputHandler, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return replOutputHandler.strToSource(string, charset);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeverityDetails> createCompilerMessages(String runtimeErrorsReport) {
        boolean bl = false;
        ArrayList<SeverityDetails> compilerMessages = new ArrayList<SeverityDetails>();
        Document report2 = this.factory.newDocumentBuilder().parse(this.strToSource(runtimeErrorsReport, Charsets.UTF_16));
        NodeList entries2 = report2.getElementsByTagName("reportEntry");
        int n = 0;
        NodeList nodeList = entries2;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"entries");
        int n2 = nodeList.getLength() - 1;
        if (n <= n2) {
            while (true) {
                String description2;
                String string;
                String string2;
                void i2;
                Node node = entries2.item((int)i2);
                if (node == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element reportEntry = (Element)node;
                String string3 = reportEntry.getAttribute("severity");
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"reportEntry.getAttribute(\"severity\")");
                Severity severityLevel = this.toSeverity(string3);
                Intrinsics.checkExpressionValueIsNotNull((Object)reportEntry.getAttribute("rangeStart"), (String)"reportEntry.getAttribute(\"rangeStart\")");
                boolean bl2 = false;
                int rangeStart = Integer.parseInt(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)reportEntry.getAttribute("rangeEnd"), (String)"reportEntry.getAttribute(\"rangeEnd\")");
                boolean bl3 = false;
                int rangeEnd = Integer.parseInt(string);
                String string4 = description2 = reportEntry.getTextContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"description");
                compilerMessages.add(new SeverityDetails(severityLevel, string4, new TextRange(rangeStart, rangeEnd)));
                if (i2 == n2) break;
                ++i2;
            }
        }
        return compilerMessages;
    }

    private final Severity toSeverity(@NotNull String $this$toSeverity) {
        Severity severity;
        switch ($this$toSeverity) {
            case "ERROR": {
                severity = Severity.ERROR;
                break;
            }
            case "WARNING": {
                severity = Severity.WARNING;
                break;
            }
            case "INFO": {
                severity = Severity.INFO;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported Severity: '" + $this$toSeverity + '\'');
            }
        }
        return severity;
    }

    public ReplOutputHandler(@NotNull KotlinConsoleRunner runner, @NotNull Process process2, @NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        super(process2, commandLine);
        this.runner = runner;
        this.factory = DocumentBuilderFactory.newInstance();
        this.outputProcessor = new ReplOutputProcessor(this.runner);
        this.inputBuffer = new StringBuilder();
    }
}

