/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirNamedReference;
import org.jetbrains.kotlin.fir.FirReference;
import org.jetbrains.kotlin.fir.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001aS\u0010\u0002\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u000526\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u001b\u001a\u00020\u001c*\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u001f\u001a\u00020 *\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010%\u001a\u0004\u0018\u00010&*\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010%\u001a\u0004\u0018\u00010&*\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010)\u001a\u00020**\u00020+2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010,\u001a\u00020-*\u00020.2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006/"}, d2={"createErrorType", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "convertWithOffsets", "T", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "f", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "startOffset", "endOffset", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/ir/IrElement;", "toClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "toFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "toIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;", "toPropertySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "toSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/fir/FirNamedReference;", "Lorg/jetbrains/kotlin/fir/FirReference;", "toTypeParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "toValueSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "fir2ir"})
public final class ConversionUtilsKt {
    @NotNull
    public static final <T extends IrElement> T convertWithOffsets(@NotNull FirElement $this$convertWithOffsets, @NotNull Function2<? super Integer, ? super Integer, ? extends T> f2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$convertWithOffsets, (String)"$this$convertWithOffsets");
        Intrinsics.checkParameterIsNotNull(f2, (String)"f");
        PsiElement psiElement2 = $this$convertWithOffsets.getPsi();
        int startOffset = psiElement2 != null ? PsiUtilsKt.getStartOffsetSkippingComments(psiElement2) : -1;
        PsiElement psiElement3 = $this$convertWithOffsets.getPsi();
        int endOffset = psiElement3 != null ? PsiUtilsKt.getEndOffset(psiElement3) : -1;
        return (T)((IrElement)f2.invoke((Object)startOffset, (Object)endOffset));
    }

    @NotNull
    public static final IrErrorType createErrorType() {
        return new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
    }

    @NotNull
    public static final IrType toIrType(@NotNull FirTypeRef $this$toIrType, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toIrType, (String)"$this$toIrType");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        if (!($this$toIrType instanceof FirResolvedTypeRef)) {
            return ConversionUtilsKt.createErrorType();
        }
        return ConversionUtilsKt.toIrType(((FirResolvedTypeRef)$this$toIrType).getType(), session, declarationStorage);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType toIrType(@NotNull ConeKotlinType $this$toIrType, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrType irType;
        Intrinsics.checkParameterIsNotNull((Object)$this$toIrType, (String)"$this$toIrType");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        ConeKotlinType coneKotlinType = $this$toIrType;
        if (coneKotlinType instanceof ConeClassErrorType) {
            irType = ConversionUtilsKt.createErrorType();
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            Collection<IrTypeArgument> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ConeClassifierSymbol coneClassifierSymbol = ResolveUtilsKt.toSymbol(((ConeLookupTagBasedType)$this$toIrType).getLookupTag(), session);
            if (coneClassifierSymbol == null) {
                return ConversionUtilsKt.createErrorType();
            }
            ConeClassifierSymbol firSymbol = coneClassifierSymbol;
            IrClassifierSymbol irSymbol = ConversionUtilsKt.toIrSymbol(firSymbol, session, declarationStorage);
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = $this$toIrType.getTypeArguments();
            boolean bl = ConeTypesKt.isMarkedNullable($this$toIrType);
            IrClassifierSymbol irClassifierSymbol = irSymbol;
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var11_15 = $this$mapTo$iv$iv;
            int n = ((void)var11_15).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var15_19 = item$iv$iv = var11_15[j];
                collection = destination$iv$iv;
                boolean bl2 = false;
                IrTypeArgument irTypeArgument = ConversionUtilsKt.toIrTypeArgument((ConeKotlinTypeProjection)it, session, declarationStorage);
                collection.add(irTypeArgument);
            }
            collection = (List)destination$iv$iv;
            List list2 = CollectionsKt.emptyList();
            List list3 = collection;
            boolean bl3 = bl;
            IrClassifierSymbol irClassifierSymbol2 = irClassifierSymbol;
            irType = new IrSimpleTypeImpl(irClassifierSymbol2, bl3, list3, list2);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            irType = ConversionUtilsKt.toIrType(((ConeFlexibleType)$this$toIrType).getUpperBound(), session, declarationStorage);
        } else {
            if (coneKotlinType instanceof ConeCapturedType) {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return irType;
    }

    @NotNull
    public static final IrTypeArgument toIrTypeArgument(@NotNull ConeKotlinTypeProjection $this$toIrTypeArgument, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrTypeArgument irTypeArgument;
        Intrinsics.checkParameterIsNotNull((Object)$this$toIrTypeArgument, (String)"$this$toIrTypeArgument");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        ConeKotlinTypeProjection coneKotlinTypeProjection = $this$toIrTypeArgument;
        if (Intrinsics.areEqual((Object)coneKotlinTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
            irTypeArgument = IrStarProjectionImpl.INSTANCE;
        } else if (coneKotlinTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            IrType irType = ConversionUtilsKt.toIrType(((ConeKotlinTypeProjectionIn)$this$toIrTypeArgument).getType(), session, declarationStorage);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.IN_VARIANCE);
        } else if (coneKotlinTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            IrType irType = ConversionUtilsKt.toIrType(((ConeKotlinTypeProjectionOut)$this$toIrTypeArgument).getType(), session, declarationStorage);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.OUT_VARIANCE);
        } else if (coneKotlinTypeProjection instanceof ConeKotlinType) {
            IrType irType = ConversionUtilsKt.toIrType((ConeKotlinType)$this$toIrTypeArgument, session, declarationStorage);
            irTypeArgument = IrSimpleTypeImplKt.makeTypeProjection(irType, Variance.INVARIANT);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irTypeArgument;
    }

    @NotNull
    public static final IrClassifierSymbol toIrSymbol(@NotNull ConeClassifierSymbol $this$toIrSymbol, @NotNull FirSession session, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        IrClassifierSymbol irClassifierSymbol;
        Intrinsics.checkParameterIsNotNull((Object)$this$toIrSymbol, (String)"$this$toIrSymbol");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        ConeClassifierSymbol coneClassifierSymbol = $this$toIrSymbol;
        if (coneClassifierSymbol instanceof FirTypeParameterSymbol) {
            irClassifierSymbol = ConversionUtilsKt.toTypeParameterSymbol((FirTypeParameterSymbol)$this$toIrSymbol, declarationStorage);
        } else if (coneClassifierSymbol instanceof FirTypeAliasSymbol) {
            FirTypeAlias typeAlias2 = (FirTypeAlias)((FirTypeAliasSymbol)$this$toIrSymbol).getFir();
            FirTypeRef firTypeRef = typeAlias2.getExpandedTypeRef();
            if (firTypeRef == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
            }
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
            ConeClassifierSymbol coneClassifierSymbol2 = ResolveUtilsKt.toSymbol(coneClassLikeType.getLookupTag(), session);
            if (coneClassifierSymbol2 == null) {
                Intrinsics.throwNpe();
            }
            irClassifierSymbol = ConversionUtilsKt.toIrSymbol(coneClassifierSymbol2, session, declarationStorage);
        } else if (coneClassifierSymbol instanceof FirClassSymbol) {
            irClassifierSymbol = ConversionUtilsKt.toClassSymbol((FirClassSymbol)$this$toIrSymbol, declarationStorage);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Should not be here: " + $this$toIrSymbol)));
        }
        return irClassifierSymbol;
    }

    @Nullable
    public static final IrSymbol toSymbol(@NotNull FirReference $this$toSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toSymbol, (String)"$this$toSymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        if ($this$toSymbol instanceof FirNamedReference) {
            return ConversionUtilsKt.toSymbol((FirNamedReference)$this$toSymbol, declarationStorage);
        }
        return null;
    }

    @Nullable
    public static final IrSymbol toSymbol(@NotNull FirNamedReference $this$toSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toSymbol, (String)"$this$toSymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        if ($this$toSymbol instanceof FirResolvedCallableReference) {
            ConeSymbol callableSymbol = ((FirResolvedCallableReference)$this$toSymbol).getConeSymbol();
            if (callableSymbol instanceof FirFunctionSymbol) {
                return ConversionUtilsKt.toFunctionSymbol((FirFunctionSymbol)callableSymbol, declarationStorage);
            }
            if (callableSymbol instanceof FirPropertySymbol) {
                return ConversionUtilsKt.toPropertySymbol((FirPropertySymbol)callableSymbol, declarationStorage);
            }
            if (callableSymbol instanceof FirVariableSymbol) {
                return ConversionUtilsKt.toValueSymbol((FirVariableSymbol)callableSymbol, declarationStorage);
            }
        }
        return null;
    }

    @NotNull
    public static final IrClassSymbol toClassSymbol(@NotNull FirClassSymbol $this$toClassSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toClassSymbol, (String)"$this$toClassSymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        return declarationStorage.getIrClassSymbol($this$toClassSymbol);
    }

    @NotNull
    public static final IrTypeParameterSymbol toTypeParameterSymbol(@NotNull FirTypeParameterSymbol $this$toTypeParameterSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toTypeParameterSymbol, (String)"$this$toTypeParameterSymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        return declarationStorage.getIrTypeParameterSymbol($this$toTypeParameterSymbol);
    }

    @NotNull
    public static final IrFunctionSymbol toFunctionSymbol(@NotNull FirFunctionSymbol $this$toFunctionSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toFunctionSymbol, (String)"$this$toFunctionSymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        return declarationStorage.getIrFunctionSymbol($this$toFunctionSymbol);
    }

    @NotNull
    public static final IrPropertySymbol toPropertySymbol(@NotNull FirPropertySymbol $this$toPropertySymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toPropertySymbol, (String)"$this$toPropertySymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        return declarationStorage.getIrPropertySymbol($this$toPropertySymbol);
    }

    @NotNull
    public static final IrValueSymbol toValueSymbol(@NotNull FirVariableSymbol $this$toValueSymbol, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toValueSymbol, (String)"$this$toValueSymbol");
        Intrinsics.checkParameterIsNotNull((Object)declarationStorage, (String)"declarationStorage");
        return declarationStorage.getIrValueSymbol($this$toValueSymbol);
    }
}

