/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirNamedReference;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassSubstitutionScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeSymbol;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.fir.types.impl.FirTypeProjectionWithVarianceImpl;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompleterTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "finalSubstitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "typeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "transformFunctionCall", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "data", "", "resolve"})
public final class FirCallCompleterTransformer
extends FirAbstractTreeTransformer {
    @NotNull
    private final FirSession session;
    private final ConeSubstitutor finalSubstitutor;
    private final ReturnTypeCalculator typeCalculator;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeTransformResult<FirStatement> transformFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data) {
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Object object;
        ConeKotlinType it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)functionCall, (String)"functionCall");
        FirNamedReference firNamedReference = functionCall.getCalleeReference();
        if (!(firNamedReference instanceof FirNamedReferenceWithCandidate)) {
            firNamedReference = null;
        }
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate = (FirNamedReferenceWithCandidate)firNamedReference;
        if (firNamedReferenceWithCandidate == null) {
            FirElement $this$compose$iv = functionCall;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        FirNamedReferenceWithCandidate calleeReference = firNamedReferenceWithCandidate;
        FirElement firElement = functionCall.transformChildren(this, data);
        if (firElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        }
        FirFunctionCall functionCall2 = (FirFunctionCall)firElement;
        Candidate subCandidate = calleeReference.getCandidate();
        ConeSymbol $this$firUnsafe$iv = subCandidate.getSymbol();
        boolean $i$f$firUnsafe = false;
        boolean bl = $this$firUnsafe$iv instanceof FirBasedSymbol;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl42 = false;
            String string = "Not a fir based symbol: " + $this$firUnsafe$iv;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object fir$iv = ((FirBasedSymbol)$this$firUnsafe$iv).getFir();
        bl2 = fir$iv instanceof FirCallableMemberDeclaration;
        bl3 = false;
        boolean bl42 = false;
        if (!bl2) {
            boolean bl5 = false;
            String bl42 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirCallableMemberDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType(fir$iv);
            throw (Throwable)new IllegalArgumentException(bl42.toString());
        }
        FirCallableMemberDeclaration declaration2 = (FirCallableMemberDeclaration)fir$iv;
        Iterable $this$map$iv = declaration2.getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl6 = false;
            object = new ConeTypeParameterTypeImpl(it.getSymbol(), false);
            collection2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConeTypeParameterTypeImpl)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl7 = false;
            object = subCandidate.getSubstitutor().substituteOrSelf(it);
            collection2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConeKotlinType)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl8 = false;
            object = this.finalSubstitutor.substituteOrSelf(it);
            collection2.add(object);
        }
        Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv22 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            FirTypeProjectionWithVarianceImpl firTypeProjectionWithVarianceImpl;
            void type2;
            void index2;
            int n = index$iv$iv22++;
            collection = destination$iv$iv;
            boolean bl9 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ConeKotlinType coneKotlinType = (ConeKotlinType)item$iv$iv;
            int n3 = n2;
            collection2 = collection;
            boolean bl10 = false;
            FirTypeProjection argument2 = (FirTypeProjection)CollectionsKt.getOrNull(functionCall2.getTypeArguments(), (int)index2);
            if (argument2 instanceof FirTypeProjectionWithVariance) {
                FirTypeRef firTypeRef = ((FirTypeProjectionWithVariance)argument2).getTypeRef();
                if (firTypeRef == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
                }
                FirResolvedTypeRef typeRef = (FirResolvedTypeRef)firTypeRef;
                firTypeProjectionWithVarianceImpl = new FirTypeProjectionWithVarianceImpl(this.session, argument2.getPsi(), ((FirTypeProjectionWithVariance)argument2).getVariance(), FirClassSubstitutionScopeKt.withReplacedConeType(typeRef, this.session, (ConeKotlinType)type2));
            } else {
                FirTypeProjection firTypeProjection = argument2;
                firTypeProjectionWithVarianceImpl = new FirTypeProjectionWithVarianceImpl(this.session, (PsiElement)(firTypeProjection != null ? firTypeProjection.getPsi() : null), Variance.INVARIANT, new FirResolvedTypeRefImpl(this.session, null, (ConeKotlinType)type2, CollectionsKt.emptyList()));
            }
            object = firTypeProjectionWithVarianceImpl;
            collection2.add(object);
        }
        List newTypeParameters = (List)destination$iv$iv;
        FirResolvedTypeRef typeRef = this.typeCalculator.tryCalculateReturnType(declaration2);
        ConeKotlinType initialType = subCandidate.getSubstitutor().substituteOrNull(typeRef.getType());
        ConeKotlinType finalType = ConeSubstitutorKt.substituteOrNull(this.finalSubstitutor, initialType);
        FirResolvedTypeRef resultType = FirClassSubstitutionScopeKt.withReplacedConeType(typeRef, this.session, finalType);
        FirNamedReference $i$f$mapIndexedTo22 = new FirResolvedCallableReferenceImpl(calleeReference.getSession(), calleeReference.getPsi(), calleeReference.getName(), calleeReference.getConeSymbol());
        List index$iv$iv22 = newTypeParameters;
        Iterator iterator2 = null;
        boolean bl11 = false;
        PsiElement psiElement2 = null;
        collection = null;
        FirTypeRef firTypeRef = resultType;
        FirElement $this$compose$iv = CopyUtilsKt.copy$default(functionCall2, null, null, $i$f$mapIndexedTo22, (FirExpression)((Object)collection), psiElement2, bl11, iterator2, index$iv$iv22, firTypeRef, 123, null);
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    public FirCallCompleterTransformer(@NotNull FirSession session, @NotNull ConeSubstitutor finalSubstitutor, @NotNull ReturnTypeCalculator typeCalculator2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)finalSubstitutor, (String)"finalSubstitutor");
        Intrinsics.checkParameterIsNotNull((Object)typeCalculator2, (String)"typeCalculator");
        this.session = session;
        this.finalSubstitutor = finalSubstitutor;
        this.typeCalculator = typeCalculator2;
    }
}

