/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirNamedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.expressions.FirVariable;
import org.jetbrains.kotlin.fir.scopes.FirPosition;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeVariableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0010H\u0016J$\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "()V", "functions", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/ConeFunctionSymbol;", "getFunctions", "()Ljava/util/Map;", "properties", "Lorg/jetbrains/kotlin/fir/symbols/ConeVariableSymbol;", "getProperties", "processFunctionsByName", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "name", "processor", "Lkotlin/Function1;", "processPropertiesByName", "storeDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedDeclaration;", "resolve"})
public final class FirLocalScope
implements FirScope {
    @NotNull
    private final Map<Name, ConeVariableSymbol> properties;
    @NotNull
    private final Map<Name, ConeFunctionSymbol> functions;

    @NotNull
    public final Map<Name, ConeVariableSymbol> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Map<Name, ConeFunctionSymbol> getFunctions() {
        return this.functions;
    }

    public final void storeDeclaration(@NotNull FirNamedDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        FirNamedDeclaration firNamedDeclaration = declaration2;
        if (firNamedDeclaration instanceof FirVariable) {
            this.properties.put(declaration2.getName(), ((FirVariable)declaration2).getSymbol());
        } else if (firNamedDeclaration instanceof FirNamedFunction) {
            FirCallableSymbol firCallableSymbol = ((FirNamedFunction)declaration2).getSymbol();
            if (firCallableSymbol == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol");
            }
            this.functions.put(declaration2.getName(), (FirFunctionSymbol)firCallableSymbol);
        }
    }

    @Override
    @NotNull
    public ProcessorAction processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super ConeFunctionSymbol, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        ConeFunctionSymbol prop = this.functions.get(name2);
        if (prop != null) {
            return (ProcessorAction)((Object)processor2.invoke((Object)prop));
        }
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public ProcessorAction processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super ConeVariableSymbol, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        ConeVariableSymbol prop = this.properties.get(name2);
        if (prop != null) {
            return (ProcessorAction)((Object)processor2.invoke((Object)prop));
        }
        return ProcessorAction.NEXT;
    }

    public FirLocalScope() {
        Map map2;
        FirLocalScope firLocalScope = this;
        boolean bl = false;
        firLocalScope.properties = map2 = (Map)new LinkedHashMap();
        firLocalScope = this;
        bl = false;
        firLocalScope.functions = map2 = (Map)new LinkedHashMap();
    }

    @Override
    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="processClassifiersByNameWithAction(name, position) { if (processor()) ProcessorAction.NEXT else ProcessorAction.STOP }.next()"), message="obsolete")
    public boolean processClassifiersByName(@NotNull Name name2, @NotNull FirPosition position2, @NotNull Function1<? super ConeClassifierSymbol, Boolean> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)position2), (String)"position");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        return FirScope.DefaultImpls.processClassifiersByName(this, name2, position2, processor2);
    }
}

