/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ide.konan;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalyzerFacadeKt;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.konan.DeserializedKonanModuleOrigin;
import org.jetbrains.kotlin.descriptors.konan.KonanModuleDescriptorFactory;
import org.jetbrains.kotlin.ide.konan.NativeLibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.resolve.PlatformAnalysisSettings;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProvider;
import org.jetbrains.kotlin.konan.library.KonanLibrary;
import org.jetbrains.kotlin.konan.util.KonanFactories;
import org.jetbrains.kotlin.metadata.konan.KonanProtoBuf;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.resolve.konan.platform.KonanPlatform;
import org.jetbrains.kotlin.serialization.konan.KonanDeserializedPackageFragmentsFactory;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"createKotlinNativeBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "settings", "Lorg/jetbrains/kotlin/idea/caches/resolve/PlatformAnalysisSettings;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "findNativeStdlib", "Lorg/jetbrains/kotlin/ide/konan/NativeLibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "asNativeStdlib", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "idea-native"})
public final class NativePlatformKindResolutionKt {
    private static final KotlinBuiltIns createKotlinNativeBuiltIns(PlatformAnalysisSettings settings2, ProjectContext projectContext) {
        Project project = projectContext.getProject();
        StorageManager storageManager = projectContext.getStorageManager();
        NativeLibraryInfo nativeLibraryInfo = NativePlatformKindResolutionKt.findNativeStdlib(project);
        if (nativeLibraryInfo == null) {
            return DefaultBuiltIns.Companion.getInstance();
        }
        NativeLibraryInfo stdlibInfo = nativeLibraryInfo;
        KonanLibrary konanLibrary = AnalyzerFacadeKt.getCapability(stdlibInfo, NativeLibraryInfo.Companion.getNATIVE_LIBRARY_CAPABILITY());
        if (konanLibrary == null) {
            Intrinsics.throwNpe();
        }
        KonanLibrary konanLibrary2 = konanLibrary;
        KonanModuleDescriptorFactory konanModuleDescriptorFactory = KonanFactories.INSTANCE.getDefaultDescriptorFactory();
        Name name2 = KotlinBuiltIns.BUILTINS_MODULE_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"KotlinBuiltIns.BUILTINS_MODULE_NAME");
        ModuleDescriptorImpl builtInsModule = konanModuleDescriptorFactory.createDescriptorAndNewBuiltIns(name2, storageManager, new DeserializedKonanModuleOrigin(konanLibrary2), stdlibInfo.getCapabilities());
        LanguageVersionSettings languageSettings = IDELanguageSettingsProvider.INSTANCE.getLanguageVersionSettings(stdlibInfo, project, settings2.isReleaseCoroutines());
        CompilerDeserializationConfiguration deserializationConfiguration = new CompilerDeserializationConfiguration(languageSettings);
        KonanProtoBuf.LinkDataLibrary libraryProto = konanLibrary2.getModuleHeaderData();
        KonanDeserializedPackageFragmentsFactory konanDeserializedPackageFragmentsFactory = KonanFactories.INSTANCE.getDefaultPackageFragmentsFactory();
        ProtocolStringList protocolStringList = libraryProto.getPackageFragmentNameList();
        Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"libraryProto.packageFragmentNameList");
        PackageFragmentProvider stdlibFragmentProvider = konanDeserializedPackageFragmentsFactory.createPackageFragmentProvider(konanLibrary2, null, protocolStringList, storageManager, builtInsModule, deserializationConfiguration);
        builtInsModule.initialize(new CompositePackageFragmentProvider(CollectionsKt.listOf((Object[])new PackageFragmentProvider[]{stdlibFragmentProvider, KonanFactories.INSTANCE.getDefaultPackageFragmentsFactory().createForwardDeclarationHackPackagePartProvider(storageManager, builtInsModule)})));
        builtInsModule.setDependencies(CollectionsKt.listOf((Object)builtInsModule));
        return builtInsModule.getBuiltIns();
    }

    private static final NativeLibraryInfo findNativeStdlib(Project project) {
        NativeLibraryInfo nativeLibraryInfo;
        block1: {
            Iterable $this$firstNotNullResult$iv = ModuleInfosFromIdeaModelKt.getModuleInfosFromIdeaModel(project, KonanPlatform.INSTANCE);
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                IdeaModuleInfo it = (IdeaModuleInfo)element$iv;
                boolean bl = false;
                NativeLibraryInfo result$iv = NativePlatformKindResolutionKt.asNativeStdlib(it);
                if (result$iv == null) continue;
                nativeLibraryInfo = result$iv;
                break block1;
            }
            nativeLibraryInfo = null;
        }
        return nativeLibraryInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final NativeLibraryInfo asNativeStdlib(@NotNull IdeaModuleInfo $this$asNativeStdlib) {
        IdeaModuleInfo ideaModuleInfo = $this$asNativeStdlib;
        if (!(ideaModuleInfo instanceof NativeLibraryInfo)) {
            ideaModuleInfo = null;
        }
        NativeLibraryInfo nativeLibraryInfo = (NativeLibraryInfo)ideaModuleInfo;
        if (nativeLibraryInfo == null) return null;
        if (!nativeLibraryInfo.isStdlib()) return null;
        NativeLibraryInfo nativeLibraryInfo2 = (NativeLibraryInfo)$this$asNativeStdlib;
        return nativeLibraryInfo2;
    }

    public static final /* synthetic */ KotlinBuiltIns access$createKotlinNativeBuiltIns(PlatformAnalysisSettings settings2, ProjectContext projectContext) {
        return NativePlatformKindResolutionKt.createKotlinNativeBuiltIns(settings2, projectContext);
    }
}

