/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.ui.Messages;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.KotlinPluginVersion;
import org.jetbrains.kotlin.idea.PlatformVersion;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginCompatibilityVerifier;", "", "()V", "checkCompatibility", "", "idea"})
public final class KotlinPluginCompatibilityVerifier {
    public static final KotlinPluginCompatibilityVerifier INSTANCE;

    @JvmStatic
    public static final void checkCompatibility() {
        String string = KotlinPluginUtil.getPluginVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinPluginUtil.getPluginVersion()");
        KotlinPluginVersion kotlinPluginVersion = KotlinPluginVersion.Companion.parse(string);
        if (kotlinPluginVersion == null) {
            return;
        }
        KotlinPluginVersion kotlinVersion2 = kotlinPluginVersion;
        PlatformVersion platformVersion = PlatformVersion.Companion.getCurrent();
        if (platformVersion == null) {
            return;
        }
        PlatformVersion platformVersion2 = platformVersion;
        if (kotlinVersion2.getPlatformVersion().getPlatform() != platformVersion2.getPlatform()) {
            Messages.showWarningDialog((String)("Installed Kotlin plugin version (" + kotlinVersion2 + ") is not compatible with " + platformVersion2 + ".\n" + "Some functionality may be broken.\n\n" + "Please reinstall the Kotlin plugin."), (String)"Compatibility issue");
        }
    }

    private KotlinPluginCompatibilityVerifier() {
    }

    static {
        KotlinPluginCompatibilityVerifier kotlinPluginCompatibilityVerifier;
        INSTANCE = kotlinPluginCompatibilityVerifier = new KotlinPluginCompatibilityVerifier();
    }
}

