/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.actions.AutoImportVariant;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "variants", "", "Lorg/jetbrains/kotlin/idea/actions/AutoImportVariant;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "addImport", "", "variant", "execute", "", "getVariantSelectionPopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "isUnambiguous", "showHint", "idea"})
public final class KotlinAddImportAction
implements QuestionAction {
    private final Project project;
    private final Editor editor;
    private final KtElement element;
    private final List<AutoImportVariant> variants;

    public final boolean showHint() {
        if (this.variants.isEmpty()) {
            return false;
        }
        String hintText = ShowAutoImportPass.getMessage((this.variants.size() > 1 ? 1 : 0) != 0, (String)((AutoImportVariant)CollectionsKt.first(this.variants)).getHint());
        HintManager hintManager = HintManager.getInstance();
        int n = this.element.getTextOffset();
        TextRange textRange = this.element.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        hintManager.showQuestionHint(this.editor, hintText, n, textRange.getEndOffset(), (QuestionAction)this);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnambiguous() {
        DeclarationDescriptor it;
        if (this.variants.size() != 1) return false;
        Iterable $this$all$iv = this.variants.get(0).getDescriptorsToImport();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (DeclarationDescriptor)element$iv;
            boolean bl = false;
        } while (it instanceof ClassDescriptor);
        return false;
    }

    public boolean execute() {
        block6: {
            block5: {
                PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
                if (!this.element.isValid()) {
                    return false;
                }
                if (this.variants.isEmpty()) {
                    return false;
                }
                if (this.variants.size() == 1) break block5;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block6;
            }
            this.addImport((AutoImportVariant)CollectionsKt.first(this.variants));
            return true;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)this.getVariantSelectionPopup()).showInBestPositionFor(this.editor);
        return true;
    }

    private final BaseListPopupStep<AutoImportVariant> getVariantSelectionPopup() {
        return (BaseListPopupStep)new BaseListPopupStep<AutoImportVariant>(this, KotlinBundle.message("imports.chooser.title", new Object[0]), this.variants){
            final /* synthetic */ KotlinAddImportAction this$0;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @Nullable
            public PopupStep<String> onChosen(@Nullable AutoImportVariant selectedValue, boolean finalChoice) {
                if (selectedValue == null || KotlinAddImportAction.access$getProject$p(this.this$0).isDisposed()) {
                    return null;
                }
                if (finalChoice) {
                    KotlinAddImportAction.access$addImport(this.this$0, selectedValue);
                    return null;
                }
                List toExclude = AddImportAction.getAllExcludableStrings((String)selectedValue.getExcludeFqNameCheck().asString());
                return (PopupStep)new BaseListPopupStep<String>(this, toExclude, null, toExclude){
                    final /* synthetic */ getVariantSelectionPopup.1 this$0;
                    final /* synthetic */ List $toExclude;

                    @NotNull
                    public String getTextFor(@NotNull String value2) {
                        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                        return "Exclude '" + value2 + "' from auto-import";
                    }

                    @Nullable
                    public PopupStep<Object> onChosen(@Nullable String selectedValue, boolean finalChoice) {
                        if (finalChoice && !KotlinAddImportAction.access$getProject$p(this.this$0.this$0).isDisposed()) {
                            AddImportAction.excludeFromImport((Project)KotlinAddImportAction.access$getProject$p(this.this$0.this$0), (String)selectedValue);
                        }
                        return null;
                    }
                    {
                        this.this$0 = $outer;
                        this.$toExclude = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                    }
                };
            }

            public boolean hasSubstep(@Nullable AutoImportVariant selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(@NotNull AutoImportVariant value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return value2.getHint();
            }

            @Nullable
            public Icon getIconFor(@NotNull AutoImportVariant value2) {
                Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                return value2.icon(KotlinAddImportAction.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    private final void addImport(AutoImportVariant variant) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        psiDocumentManager.commitAllDocuments();
        String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"add.import\")");
        ApplicationUtilsKt.executeWriteCommand(this.project, string, (Function0<Unit>)((Function0)new Function0<Unit>(this, variant){
            final /* synthetic */ KotlinAddImportAction this$0;
            final /* synthetic */ AutoImportVariant $variant;

            public final void invoke() {
                if (!KotlinAddImportAction.access$getElement$p(this.this$0).isValid()) {
                    return;
                }
                KtFile ktFile2 = KotlinAddImportAction.access$getElement$p(this.this$0).getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"element.containingKtFile");
                KtFile file2 = ktFile2;
                PsiElement psiElement2 = this.$variant.declarationToImport(KotlinAddImportAction.access$getProject$p(this.this$0));
                if (psiElement2 != null) {
                    PsiElement psiElement3 = psiElement2;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement it = psiElement3;
                    boolean bl3 = false;
                    ProximityLocation location2 = new ProximityLocation((PsiElement)KotlinAddImportAction.access$getElement$p(this.this$0), ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)KotlinAddImportAction.access$getElement$p(this.this$0))));
                    StatisticsManager.getInstance().incUseCount(PsiProximityComparator.STATISTICS_KEY, (Object)it, (Object)location2);
                }
                Iterable $this$forEach$iv = this.$variant.getDescriptorsToImport();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtImportAlias importAlias;
                    KtImportAlias ktImportAlias;
                    FqName it;
                    FqName fqName2;
                    boolean bl;
                    boolean bl4;
                    DeclarationDescriptor descriptor2 = (DeclarationDescriptor)element$iv;
                    boolean bl5 = false;
                    if (ImportsUtils.getImportableFqName(descriptor2) != null) {
                        bl4 = false;
                        bl = false;
                        it = fqName2;
                        boolean bl6 = false;
                        ktImportAlias = file2.findAliasByFqName(it);
                    } else {
                        ktImportAlias = importAlias = null;
                    }
                    if (importAlias != null || descriptor2 instanceof ClassDescriptor || descriptor2 instanceof PackageViewDescriptor) {
                        if (!(KotlinAddImportAction.access$getElement$p(this.this$0) instanceof KtSimpleNameExpression)) continue;
                        if (importAlias != null) {
                            PsiElement psiElement4 = importAlias.getNameIdentifier();
                            if (psiElement4 != null && (psiElement4 = psiElement4.copy()) != null) {
                                fqName2 = psiElement4;
                                bl4 = false;
                                bl = false;
                                it = fqName2;
                                boolean bl7 = false;
                                PsiElement psiElement5 = ((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(this.this$0)).getIdentifier();
                                if (psiElement5 != null) {
                                    psiElement5.replace((PsiElement)it);
                                }
                            }
                            DeclarationDescriptor resultDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(KotlinAddImportAction.access$getElement$p(this.this$0)));
                            DeclarationDescriptor declarationDescriptor = resultDescriptor;
                            if (Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName(descriptor2), (Object)(declarationDescriptor != null ? ImportsUtils.getImportableFqName(declarationDescriptor) : null))) continue;
                        }
                        if (ImportsUtils.getImportableFqName(descriptor2) != null) {
                            bl4 = false;
                            bl = false;
                            it = fqName2;
                            boolean bl8 = false;
                            KtSimpleNameReference.bindToFqName$default(ReferenceUtilKt.getMainReference((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(this.this$0)), it, KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING, null, 4, null);
                        }
                        continue;
                    }
                    ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(KotlinAddImportAction.access$getProject$p(this.this$0)), file2, descriptor2, false, 4, null);
                }
            }
            {
                this.this$0 = kotlinAddImportAction;
                this.$variant = autoImportVariant;
                super(0);
            }
        }));
    }

    public KotlinAddImportAction(@NotNull Project project, @NotNull Editor editor2, @NotNull KtElement element3, @NotNull List<? extends AutoImportVariant> variants) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(variants, (String)"variants");
        this.project = project;
        this.editor = editor2;
        this.element = element3;
        this.variants = variants;
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinAddImportAction $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$addImport(KotlinAddImportAction $this, AutoImportVariant variant) {
        $this.addImport(variant);
    }

    public static final /* synthetic */ KtElement access$getElement$p(KotlinAddImportAction $this) {
        return $this.element;
    }
}

