/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.PluginStartupComponent;
import org.jetbrains.kotlin.idea.compiler.configuration.ClearBuildStateExtension;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;
import org.jetbrains.kotlin.idea.facet.DescriptionListCellRenderer;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.project.NewInferenceForIDEAnalysisComponent;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.CidrUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;

public class KotlinCompilerConfigurableTab
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Map<String, String> moduleKindDescriptions = new LinkedHashMap<String, String>();
    private static final Map<String, String> soruceMapSourceEmbeddingDescriptions = new LinkedHashMap<String, String>();
    private static final List<LanguageFeature.State> languageFeatureStates = Arrays.asList(LanguageFeature.State.ENABLED, LanguageFeature.State.ENABLED_WITH_WARNING, LanguageFeature.State.ENABLED_WITH_ERROR);
    private static final int MAX_WARNING_SIZE = 75;
    @Nullable
    private final KotlinCompilerWorkspaceSettings compilerWorkspaceSettings;
    private final Project project;
    private final boolean isProjectSettings;
    private CommonCompilerArguments commonCompilerArguments;
    private K2JSCompilerArguments k2jsCompilerArguments;
    private K2JVMCompilerArguments k2jvmCompilerArguments;
    private CompilerSettings compilerSettings;
    private JPanel contentPane;
    private ThreeStateCheckBox reportWarningsCheckBox;
    private RawCommandLineEditor additionalArgsOptionsField;
    private JLabel additionalArgsLabel;
    private ThreeStateCheckBox generateSourceMapsCheckBox;
    private TextFieldWithBrowseButton outputPrefixFile;
    private TextFieldWithBrowseButton outputPostfixFile;
    private JLabel labelForOutputDirectory;
    private TextFieldWithBrowseButton outputDirectory;
    private ThreeStateCheckBox copyRuntimeFilesCheckBox;
    private ThreeStateCheckBox keepAliveCheckBox;
    private JCheckBox enableIncrementalCompilationForJvmCheckBox;
    private JCheckBox enableIncrementalCompilationForJsCheckBox;
    private JComboBox moduleKindComboBox;
    private JTextField scriptTemplatesField;
    private JTextField scriptTemplatesClasspathField;
    private JLabel scriptTemplatesLabel;
    private JLabel scriptTemplatesClasspathLabel;
    private JPanel k2jvmPanel;
    private JPanel k2jsPanel;
    private JComboBox jvmVersionComboBox;
    private JComboBox<VersionView> languageVersionComboBox;
    private JComboBox coroutineSupportComboBox;
    private JComboBox<VersionView> apiVersionComboBox;
    private JPanel scriptPanel;
    private JLabel labelForOutputPrefixFile;
    private JLabel labelForOutputPostfixFile;
    private JLabel warningLabel;
    private JTextField sourceMapPrefix;
    private JLabel labelForSourceMapPrefix;
    private JComboBox sourceMapEmbedSources;
    private JPanel coroutinesPanel;
    private ThreeStateCheckBox enableNewInferenceInIDECheckBox;
    private boolean isEnabled;

    public KotlinCompilerConfigurableTab(Project project, @NotNull CommonCompilerArguments commonCompilerArguments, @NotNull K2JSCompilerArguments k2jsCompilerArguments, @NotNull K2JVMCompilerArguments k2jvmCompilerArguments, CompilerSettings compilerSettings, @Nullable KotlinCompilerWorkspaceSettings compilerWorkspaceSettings, boolean isProjectSettings, boolean isMultiEditor) {
        if (commonCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(0);
        }
        if (k2jsCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(1);
        }
        if (k2jvmCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(2);
        }
        if (commonCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(0);
        }
        if (k2jsCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(1);
        }
        if (k2jvmCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(2);
        }
        if (commonCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(0);
        }
        if (k2jsCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(1);
        }
        if (k2jvmCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(2);
        }
        if (commonCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(0);
        }
        if (k2jsCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(1);
        }
        if (k2jvmCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(2);
        }
        this.isEnabled = true;
        this.project = project;
        this.commonCompilerArguments = commonCompilerArguments;
        this.k2jsCompilerArguments = k2jsCompilerArguments;
        this.compilerSettings = compilerSettings;
        this.compilerWorkspaceSettings = compilerWorkspaceSettings;
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
        this.isProjectSettings = isProjectSettings;
        this.$$$setupUI$$$();
        this.warningLabel.setIcon(AllIcons.General.WarningDialog);
        if (isProjectSettings) {
            this.languageVersionComboBox.addActionListener(e -> this.onLanguageLevelChanged(this.getSelectedLanguageVersionView()));
        }
        this.additionalArgsOptionsField.attachLabel(this.additionalArgsLabel);
        this.fillLanguageAndAPIVersionList();
        this.fillCoroutineSupportList();
        if (CidrUtil.isRunningInCidrIde()) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
            this.k2jsPanel.setVisible(false);
        } else {
            this.initializeNonCidrSettings(isMultiEditor);
        }
        this.reportWarningsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.enableNewInferenceInIDECheckBox.setThirdStateEnabled(isMultiEditor);
        if (isProjectSettings) {
            List modulesOverridingProjectSettings = ArraysKt.mapNotNull((Object[])ModuleManager.getInstance((Project)project).getModules(), module -> {
                KotlinFacet facet = KotlinFacet.Companion.get((Module)module);
                if (facet == null) {
                    return null;
                }
                KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                if (facetSettings.getUseProjectSettings()) {
                    return null;
                }
                return module.getName();
            });
            CollectionsKt.sort((List)modulesOverridingProjectSettings);
            if (!modulesOverridingProjectSettings.isEmpty()) {
                this.warningLabel.setVisible(true);
                this.warningLabel.setText(KotlinCompilerConfigurableTab.buildOverridingModulesWarning(modulesOverridingProjectSettings));
            }
        }
    }

    public KotlinCompilerConfigurableTab(Project project) {
        this(project, (CommonCompilerArguments)((CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project).getSettings()).unfrozen(), (K2JSCompilerArguments)((K2JSCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(project).getSettings()).unfrozen(), (K2JVMCompilerArguments)((K2JVMCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(project).getSettings()).unfrozen(), (CompilerSettings)((CompilerSettings)KotlinCompilerSettings.Companion.getInstance(project).getSettings()).unfrozen(), (KotlinCompilerWorkspaceSettings)ServiceManager.getService((Project)project, KotlinCompilerWorkspaceSettings.class), true, false);
    }

    private void initializeNonCidrSettings(boolean isMultiEditor) {
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPrefixFile, this.outputPrefixFile, KotlinBundle.message("kotlin.compiler.js.option.output.prefix.browse.title", new Object[0]), true);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPostfixFile, this.outputPostfixFile, KotlinBundle.message("kotlin.compiler.js.option.output.postfix.browse.title", new Object[0]), true);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputDirectory, this.outputDirectory, "Choose Output Directory", false);
        this.fillModuleKindList();
        this.fillSourceMapSourceEmbeddingList();
        this.fillJvmVersionList();
        this.generateSourceMapsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.generateSourceMapsCheckBox.addActionListener(event -> this.sourceMapPrefix.setEnabled(this.generateSourceMapsCheckBox.isSelected()));
        this.copyRuntimeFilesCheckBox.setThirdStateEnabled(isMultiEditor);
        this.keepAliveCheckBox.setThirdStateEnabled(isMultiEditor);
        if (this.compilerWorkspaceSettings == null) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
            this.enableIncrementalCompilationForJsCheckBox.setVisible(false);
            this.enableNewInferenceInIDECheckBox.setVisible(false);
        }
        this.updateOutputDirEnabled();
    }

    private static int calculateNameCountToShowInWarning(List<String> allNames2) {
        int lengthSoFar = 0;
        int size = allNames2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            lengthSoFar = (i2 > 0 ? lengthSoFar + 2 : 0) + allNames2.get(i2).length();
            if (lengthSoFar <= 75) continue;
            return i2;
        }
        return size;
    }

    @NotNull
    private static String buildOverridingModulesWarning(List<String> modulesOverridingProjectSettings) {
        int nameCountToShow = KotlinCompilerConfigurableTab.calculateNameCountToShowInWarning(modulesOverridingProjectSettings);
        int allNamesCount = modulesOverridingProjectSettings.size();
        if (nameCountToShow == 0) {
            String string = String.valueOf(allNamesCount) + " modules override project settings";
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$0(3);
            }
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$1(3);
            }
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$2(3);
            }
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$3(3);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html>Following modules override project settings: ");
        CollectionsKt.joinTo(modulesOverridingProjectSettings.subList(0, nameCountToShow), (Appendable)builder, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", (Function1)new Function1<String, CharSequence>(){

            public CharSequence invoke(String s) {
                return "<strong>" + s + "</strong>";
            }
        });
        if (nameCountToShow < allNamesCount) {
            builder.append(" and ").append(allNamesCount - nameCountToShow).append(" other(s)");
        }
        String string = builder.toString();
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(4);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(4);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(4);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(4);
        }
        return string;
    }

    @NotNull
    private static String getModuleKindDescription(@Nullable String moduleKind) {
        if (moduleKind == null) {
            return "";
        }
        String result2 = moduleKindDescriptions.get(moduleKind);
        assert (result2 != null) : "Module kind " + moduleKind + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(5);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(5);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(5);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(5);
        }
        return string;
    }

    @NotNull
    private static String getSourceMapSourceEmbeddingDescription(@Nullable String sourceMapSourceEmbeddingId) {
        if (sourceMapSourceEmbeddingId == null) {
            return "";
        }
        String result2 = soruceMapSourceEmbeddingDescriptions.get(sourceMapSourceEmbeddingId);
        assert (result2 != null) : "Source map source embedding mode " + sourceMapSourceEmbeddingId + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(6);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(6);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(6);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(6);
        }
        return string;
    }

    @NotNull
    private static String getModuleKindOrDefault(@Nullable String moduleKindId) {
        if (moduleKindId == null) {
            moduleKindId = "plain";
        }
        String string = moduleKindId;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(7);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(7);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(7);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(7);
        }
        return string;
    }

    @NotNull
    private static String getSourceMapSourceEmbeddingOrDefault(@Nullable String sourceMapSourceEmbeddingId) {
        if (sourceMapSourceEmbeddingId == null) {
            sourceMapSourceEmbeddingId = "inlining";
        }
        String string = sourceMapSourceEmbeddingId;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(8);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(8);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(8);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(8);
        }
        return string;
    }

    private static String getJvmVersionOrDefault(@Nullable String jvmVersion) {
        return jvmVersion != null ? jvmVersion : JvmTarget.DEFAULT.getDescription();
    }

    private static void setupFileChooser(@NotNull JLabel label2, @NotNull TextFieldWithBrowseButton fileChooser, @NotNull String title, boolean forFiles) {
        if (label2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(9);
        }
        if (fileChooser == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(10);
        }
        if (title == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(11);
        }
        if (label2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(9);
        }
        if (fileChooser == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(10);
        }
        if (title == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(11);
        }
        if (label2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(9);
        }
        if (fileChooser == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(10);
        }
        if (title == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(11);
        }
        if (label2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(9);
        }
        if (fileChooser == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(10);
        }
        if (title == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(11);
        }
        label2.setLabelFor((Component)fileChooser);
        fileChooser.addBrowseFolderListener(title, null, null, new FileChooserDescriptor(forFiles, !forFiles, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    private static boolean isModifiedWithNullize(@NotNull TextFieldWithBrowseButton chooser2, @Nullable String currentValue) {
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(12);
        }
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(12);
        }
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(12);
        }
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(12);
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)chooser2.getText(), (boolean)true), (CharSequence)StringUtil.nullize((String)currentValue, (boolean)true));
    }

    private static boolean isModified(@NotNull TextFieldWithBrowseButton chooser2, @NotNull String currentValue) {
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(13);
        }
        if (currentValue == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(14);
        }
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(13);
        }
        if (currentValue == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(14);
        }
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(13);
        }
        if (currentValue == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(14);
        }
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(13);
        }
        if (currentValue == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(14);
        }
        return !StringUtil.equals((CharSequence)chooser2.getText(), (CharSequence)currentValue);
    }

    private void updateOutputDirEnabled() {
        if (this.isEnabled && this.copyRuntimeFilesCheckBox != null) {
            this.outputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
            this.labelForOutputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
        }
    }

    private boolean isLessOrEqual(LanguageVersion version, LanguageVersion upperBound) {
        return VersionComparatorUtil.compare((String)version.getVersionString(), (String)upperBound.getVersionString()) <= 0;
    }

    public void onLanguageLevelChanged(VersionView languageLevel) {
        this.restrictAPIVersions(languageLevel);
        this.coroutinesPanel.setVisible(languageLevel.getVersion().compareTo(LanguageVersion.KOTLIN_1_3) < 0);
    }

    private void restrictAPIVersions(VersionView upperBoundView) {
        VersionView selectedAPIView = this.getSelectedAPIVersionView();
        LanguageVersion selectedAPIVersion = selectedAPIView.getVersion();
        LanguageVersion upperBound = upperBoundView.getVersion();
        ArrayList<VersionView.LatestStable> permittedAPIVersions = new ArrayList<VersionView.LatestStable>(LanguageVersion.values().length + 1);
        if (this.isLessOrEqual(VersionView.LatestStable.INSTANCE.getVersion(), upperBound)) {
            permittedAPIVersions.add(VersionView.LatestStable.INSTANCE);
        }
        ArraysKt.mapNotNullTo((Object[])LanguageVersion.values(), permittedAPIVersions, version -> this.isLessOrEqual((LanguageVersion)version, upperBound) ? new VersionView.Specific((LanguageVersion)version) : null);
        this.apiVersionComboBox.setModel(new DefaultComboBoxModel<Object>(permittedAPIVersions.toArray()));
        this.apiVersionComboBox.setSelectedItem(VersionComparatorUtil.compare((String)selectedAPIVersion.getVersionString(), (String)upperBound.getVersionString()) <= 0 ? selectedAPIView : upperBoundView);
    }

    private void fillJvmVersionList() {
        for (IdePlatform idePlatform : JvmIdePlatformKind.INSTANCE.getPlatforms()) {
            this.jvmVersionComboBox.addItem(idePlatform.getVersion().getDescription());
        }
    }

    private void fillLanguageAndAPIVersionList() {
        this.languageVersionComboBox.addItem(VersionView.LatestStable.INSTANCE);
        this.apiVersionComboBox.addItem(VersionView.LatestStable.INSTANCE);
        for (LanguageVersion version : LanguageVersion.values()) {
            if (!version.isStable() && !ApplicationManager.getApplication().isInternal()) continue;
            VersionView.Specific specificVersion = new VersionView.Specific(version);
            this.languageVersionComboBox.addItem(specificVersion);
            this.apiVersionComboBox.addItem(specificVersion);
        }
        this.languageVersionComboBox.setRenderer(new DescriptionListCellRenderer());
        this.apiVersionComboBox.setRenderer(new DescriptionListCellRenderer());
    }

    private void fillCoroutineSupportList() {
        for (LanguageFeature.State coroutineSupport : languageFeatureStates) {
            this.coroutineSupportComboBox.addItem(coroutineSupport);
        }
        this.coroutineSupportComboBox.setRenderer(new DescriptionListCellRenderer());
    }

    public void setTargetPlatform(@Nullable IdePlatformKind<?> targetPlatform) {
        this.k2jsPanel.setVisible(JsIdePlatformUtil.isJavaScript(targetPlatform));
        this.scriptPanel.setVisible(JvmIdePlatformUtil.isJvm(targetPlatform));
    }

    private void fillModuleKindList() {
        for (String moduleKind : moduleKindDescriptions.keySet()) {
            this.moduleKindComboBox.addItem(moduleKind);
        }
        this.moduleKindComboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value2, int index2, boolean selected, boolean hasFocus) {
                this.setText(KotlinCompilerConfigurableTab.getModuleKindDescription(value2));
            }
        });
    }

    private void fillSourceMapSourceEmbeddingList() {
        for (String moduleKind : soruceMapSourceEmbeddingDescriptions.keySet()) {
            this.sourceMapEmbedSources.addItem(moduleKind);
        }
        this.sourceMapEmbedSources.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value2, int index2, boolean selected, boolean hasFocus) {
                this.setText(value2 != null ? KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingDescription(value2) : "");
            }
        });
    }

    @NotNull
    public String getId() {
        return "project.kotlinCompiler";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.contentPane;
    }

    public boolean isModified() {
        return this.isModified((JToggleButton)this.reportWarningsCheckBox, !this.commonCompilerArguments.getSuppressWarnings()) || this.isModified((JToggleButton)this.enableNewInferenceInIDECheckBox, NewInferenceForIDEAnalysisComponent.isEnabled(this.project)) || !this.getSelectedLanguageVersionView().equals(KotlinFacetSettingsKt.getLanguageVersionView(this.commonCompilerArguments)) || !this.getSelectedAPIVersionView().equals(KotlinFacetSettingsKt.getApiVersionView(this.commonCompilerArguments)) || !this.getSelectedCoroutineState().equals(this.commonCompilerArguments.getCoroutinesState()) || !this.additionalArgsOptionsField.getText().equals(this.compilerSettings.getAdditionalArguments()) || this.isModified(this.scriptTemplatesField, this.compilerSettings.getScriptTemplates()) || this.isModified(this.scriptTemplatesClasspathField, this.compilerSettings.getScriptTemplatesClasspath()) || this.isModified((JToggleButton)this.copyRuntimeFilesCheckBox, this.compilerSettings.getCopyJsLibraryFiles()) || KotlinCompilerConfigurableTab.isModified(this.outputDirectory, this.compilerSettings.getOutputDirectoryForJsLibraryFiles()) || this.compilerWorkspaceSettings != null && (this.isModified(this.enableIncrementalCompilationForJvmCheckBox, this.compilerWorkspaceSettings.getPreciseIncrementalEnabled()) || this.isModified(this.enableIncrementalCompilationForJsCheckBox, this.compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled()) || this.isModified((JToggleButton)this.keepAliveCheckBox, this.compilerWorkspaceSettings.getEnableDaemon())) || this.isModified((JToggleButton)this.generateSourceMapsCheckBox, this.k2jsCompilerArguments.getSourceMap()) || KotlinCompilerConfigurableTab.isModifiedWithNullize(this.outputPrefixFile, this.k2jsCompilerArguments.getOutputPrefix()) || KotlinCompilerConfigurableTab.isModifiedWithNullize(this.outputPostfixFile, this.k2jsCompilerArguments.getOutputPostfix()) || !this.getSelectedModuleKind().equals(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.getModuleKind())) || this.isModified(this.sourceMapPrefix, StringUtil.notNullize((String)this.k2jsCompilerArguments.getSourceMapPrefix())) || !this.getSelectedSourceMapSourceEmbedding().equals(KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault(this.k2jsCompilerArguments.getSourceMapEmbedSources())) || !this.getSelectedJvmVersion().equals(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.getJvmTarget()));
    }

    @NotNull
    private String getSelectedModuleKind() {
        return KotlinCompilerConfigurableTab.getModuleKindOrDefault((String)this.moduleKindComboBox.getSelectedItem());
    }

    private String getSelectedSourceMapSourceEmbedding() {
        return KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault((String)this.sourceMapEmbedSources.getSelectedItem());
    }

    @NotNull
    private String getSelectedJvmVersion() {
        String string = KotlinCompilerConfigurableTab.getJvmVersionOrDefault((String)this.jvmVersionComboBox.getSelectedItem());
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(15);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(15);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(15);
        }
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(15);
        }
        return string;
    }

    @NotNull
    public VersionView getSelectedLanguageVersionView() {
        Object item = this.languageVersionComboBox.getSelectedItem();
        VersionView versionView = item != null ? (VersionView)item : VersionView.LatestStable.INSTANCE;
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(16);
        }
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(16);
        }
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(16);
        }
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(16);
        }
        return versionView;
    }

    @NotNull
    private VersionView getSelectedAPIVersionView() {
        Object item = this.apiVersionComboBox.getSelectedItem();
        VersionView versionView = item != null ? (VersionView)item : VersionView.LatestStable.INSTANCE;
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(17);
        }
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$1(17);
        }
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$2(17);
        }
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$3(17);
        }
        return versionView;
    }

    @NotNull
    private String getSelectedCoroutineState() {
        if (this.getSelectedLanguageVersionView().getVersion().compareTo(LanguageVersion.KOTLIN_1_3) >= 0) {
            return "default";
        }
        LanguageFeature.State state = (LanguageFeature.State)this.coroutineSupportComboBox.getSelectedItem();
        if (state == null) {
            return "default";
        }
        switch (state) {
            case ENABLED: {
                return "enable";
            }
            case ENABLED_WITH_WARNING: {
                return "warn";
            }
            case ENABLED_WITH_ERROR: {
                return "error";
            }
        }
        return "default";
    }

    public void applyTo(CommonCompilerArguments commonCompilerArguments, K2JVMCompilerArguments k2jvmCompilerArguments, K2JSCompilerArguments k2jsCompilerArguments, CompilerSettings compilerSettings) throws ConfigurationException {
        if (this.isProjectSettings) {
            boolean shouldInvalidateCaches;
            boolean bl = shouldInvalidateCaches = !this.getSelectedLanguageVersionView().equals(KotlinFacetSettingsKt.getLanguageVersionView(commonCompilerArguments)) || !this.getSelectedAPIVersionView().equals(KotlinFacetSettingsKt.getApiVersionView(commonCompilerArguments)) || !this.getSelectedCoroutineState().equals(commonCompilerArguments.getCoroutinesState()) || !this.additionalArgsOptionsField.getText().equals(compilerSettings.getAdditionalArguments()) || this.enableNewInferenceInIDECheckBox.isSelected() != NewInferenceForIDEAnalysisComponent.isEnabled(this.project);
            if (shouldInvalidateCaches) {
                ApplicationUtilsKt.runWriteAction(new Function0<Object>(){

                    public Object invoke() {
                        RootUtilsKt.invalidateProjectRoots(KotlinCompilerConfigurableTab.this.project);
                        return null;
                    }
                });
            }
        }
        commonCompilerArguments.setSuppressWarnings(!this.reportWarningsCheckBox.isSelected());
        NewInferenceForIDEAnalysisComponent.setEnabled(this.project, this.enableNewInferenceInIDECheckBox.isSelected());
        KotlinFacetSettingsKt.setLanguageVersionView(commonCompilerArguments, this.getSelectedLanguageVersionView());
        KotlinFacetSettingsKt.setApiVersionView(commonCompilerArguments, this.getSelectedAPIVersionView());
        commonCompilerArguments.setCoroutinesState(this.getSelectedCoroutineState());
        compilerSettings.setAdditionalArguments(this.additionalArgsOptionsField.getText());
        compilerSettings.setScriptTemplates(this.scriptTemplatesField.getText());
        compilerSettings.setScriptTemplatesClasspath(this.scriptTemplatesClasspathField.getText());
        compilerSettings.setCopyJsLibraryFiles(this.copyRuntimeFilesCheckBox.isSelected());
        compilerSettings.setOutputDirectoryForJsLibraryFiles(this.outputDirectory.getText());
        if (this.compilerWorkspaceSettings != null) {
            this.compilerWorkspaceSettings.setPreciseIncrementalEnabled(this.enableIncrementalCompilationForJvmCheckBox.isSelected());
            this.compilerWorkspaceSettings.setIncrementalCompilationForJsEnabled(this.enableIncrementalCompilationForJsCheckBox.isSelected());
            boolean oldEnableDaemon = this.compilerWorkspaceSettings.getEnableDaemon();
            this.compilerWorkspaceSettings.setEnableDaemon(this.keepAliveCheckBox.isSelected());
            if (this.keepAliveCheckBox.isSelected() != oldEnableDaemon) {
                PluginStartupComponent.getInstance().resetAliveFlag();
            }
        }
        k2jsCompilerArguments.setSourceMap(this.generateSourceMapsCheckBox.isSelected());
        k2jsCompilerArguments.setOutputPrefix(StringUtil.nullize((String)this.outputPrefixFile.getText(), (boolean)true));
        k2jsCompilerArguments.setOutputPostfix(StringUtil.nullize((String)this.outputPostfixFile.getText(), (boolean)true));
        k2jsCompilerArguments.setModuleKind(this.getSelectedModuleKind());
        k2jsCompilerArguments.setSourceMapPrefix(this.sourceMapPrefix.getText());
        k2jsCompilerArguments.setSourceMapEmbedSources(this.generateSourceMapsCheckBox.isSelected() ? this.getSelectedSourceMapSourceEmbedding() : null);
        k2jvmCompilerArguments.setJvmTarget(this.getSelectedJvmVersion());
        if (this.isProjectSettings) {
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(commonCompilerArguments);
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(k2jvmCompilerArguments);
            Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(k2jsCompilerArguments);
            KotlinCompilerSettings.Companion.getInstance(this.project).setSettings(compilerSettings);
        }
        for (ClearBuildStateExtension extension : ClearBuildStateExtension.getExtensions()) {
            extension.clearState(this.project);
        }
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.commonCompilerArguments, this.k2jvmCompilerArguments, this.k2jsCompilerArguments, this.compilerSettings);
    }

    public void reset() {
        this.reportWarningsCheckBox.setSelected(!this.commonCompilerArguments.getSuppressWarnings());
        this.enableNewInferenceInIDECheckBox.setSelected(NewInferenceForIDEAnalysisComponent.isEnabled(this.project));
        this.languageVersionComboBox.setSelectedItem(KotlinFacetSettingsKt.getLanguageVersionView(this.commonCompilerArguments));
        this.onLanguageLevelChanged(this.getSelectedLanguageVersionView());
        this.apiVersionComboBox.setSelectedItem(KotlinFacetSettingsKt.getApiVersionView(this.commonCompilerArguments));
        this.coroutineSupportComboBox.setSelectedItem(CoroutineSupport.byCompilerArguments(this.commonCompilerArguments));
        this.additionalArgsOptionsField.setText(this.compilerSettings.getAdditionalArguments());
        this.scriptTemplatesField.setText(this.compilerSettings.getScriptTemplates());
        this.scriptTemplatesClasspathField.setText(this.compilerSettings.getScriptTemplatesClasspath());
        this.copyRuntimeFilesCheckBox.setSelected(this.compilerSettings.getCopyJsLibraryFiles());
        this.outputDirectory.setText(this.compilerSettings.getOutputDirectoryForJsLibraryFiles());
        if (this.compilerWorkspaceSettings != null) {
            this.enableIncrementalCompilationForJvmCheckBox.setSelected(this.compilerWorkspaceSettings.getPreciseIncrementalEnabled());
            this.enableIncrementalCompilationForJsCheckBox.setSelected(this.compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled());
            this.keepAliveCheckBox.setSelected(this.compilerWorkspaceSettings.getEnableDaemon());
        }
        this.generateSourceMapsCheckBox.setSelected(this.k2jsCompilerArguments.getSourceMap());
        this.outputPrefixFile.setText(this.k2jsCompilerArguments.getOutputPrefix());
        this.outputPostfixFile.setText(this.k2jsCompilerArguments.getOutputPostfix());
        this.moduleKindComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.getModuleKind()));
        this.sourceMapPrefix.setText(this.k2jsCompilerArguments.getSourceMapPrefix());
        this.sourceMapPrefix.setEnabled(this.k2jsCompilerArguments.getSourceMap());
        this.sourceMapEmbedSources.setSelectedItem(KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault(this.k2jsCompilerArguments.getSourceMapEmbedSources()));
        this.jvmVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.getJvmTarget()));
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Kotlin Compiler";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.compiler.kotlin";
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public ThreeStateCheckBox getReportWarningsCheckBox() {
        return this.reportWarningsCheckBox;
    }

    public ThreeStateCheckBox getEnableNewInferenceInIDECheckBox() {
        return this.enableNewInferenceInIDECheckBox;
    }

    public RawCommandLineEditor getAdditionalArgsOptionsField() {
        return this.additionalArgsOptionsField;
    }

    public ThreeStateCheckBox getGenerateSourceMapsCheckBox() {
        return this.generateSourceMapsCheckBox;
    }

    public TextFieldWithBrowseButton getOutputPrefixFile() {
        return this.outputPrefixFile;
    }

    public TextFieldWithBrowseButton getOutputPostfixFile() {
        return this.outputPostfixFile;
    }

    public TextFieldWithBrowseButton getOutputDirectory() {
        return this.outputDirectory;
    }

    public ThreeStateCheckBox getCopyRuntimeFilesCheckBox() {
        return this.copyRuntimeFilesCheckBox;
    }

    public ThreeStateCheckBox getKeepAliveCheckBox() {
        return this.keepAliveCheckBox;
    }

    public JComboBox getModuleKindComboBox() {
        return this.moduleKindComboBox;
    }

    public JTextField getScriptTemplatesField() {
        return this.scriptTemplatesField;
    }

    public JTextField getScriptTemplatesClasspathField() {
        return this.scriptTemplatesClasspathField;
    }

    public JComboBox getLanguageVersionComboBox() {
        return this.languageVersionComboBox;
    }

    public JComboBox getApiVersionComboBox() {
        return this.apiVersionComboBox;
    }

    public JComboBox getCoroutineSupportComboBox() {
        return this.coroutineSupportComboBox;
    }

    public void setEnabled(boolean value2) {
        this.isEnabled = value2;
        UIUtil.setEnabled((Component)this.getContentPane(), (boolean)value2, (boolean)true);
    }

    public CommonCompilerArguments getCommonCompilerArguments() {
        return this.commonCompilerArguments;
    }

    public void setCommonCompilerArguments(CommonCompilerArguments commonCompilerArguments) {
        this.commonCompilerArguments = commonCompilerArguments;
    }

    public K2JSCompilerArguments getK2jsCompilerArguments() {
        return this.k2jsCompilerArguments;
    }

    public void setK2jsCompilerArguments(K2JSCompilerArguments k2jsCompilerArguments) {
        this.k2jsCompilerArguments = k2jsCompilerArguments;
    }

    public K2JVMCompilerArguments getK2jvmCompilerArguments() {
        return this.k2jvmCompilerArguments;
    }

    public void setK2jvmCompilerArguments(K2JVMCompilerArguments k2jvmCompilerArguments) {
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
    }

    public CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public void setCompilerSettings(CompilerSettings compilerSettings) {
        this.compilerSettings = compilerSettings;
    }

    private void createUIComponents() {
        this.copyRuntimeFilesCheckBox = new ThreeStateCheckBox(){

            public void setState(ThreeStateCheckBox.State state) {
                super.setState(state);
                KotlinCompilerConfigurableTab.this.updateOutputDirEnabled();
            }
        };
    }

    static {
        moduleKindDescriptions.put("plain", "Plain (put to global scope)");
        moduleKindDescriptions.put("amd", "AMD");
        moduleKindDescriptions.put("commonjs", "CommonJS");
        moduleKindDescriptions.put("umd", "UMD (detect AMD or CommonJS if available, fallback to plain)");
        soruceMapSourceEmbeddingDescriptions.put("never", "Never");
        soruceMapSourceEmbeddingDescriptions.put("always", "Always");
        soruceMapSourceEmbeddingDescriptions.put("inlining", "When inlining a function from other module with embedded sources");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCompilerArguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jsCompilerArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jvmCompilerArguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOverridingModulesWarning";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindOrDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedJvmVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLanguageVersionView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAPIVersionView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupFileChooser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedWithNullize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCompilerArguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jsCompilerArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jvmCompilerArguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOverridingModulesWarning";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindOrDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedJvmVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLanguageVersionView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAPIVersionView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupFileChooser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedWithNullize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCompilerArguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jsCompilerArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jvmCompilerArguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOverridingModulesWarning";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindOrDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedJvmVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLanguageVersionView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAPIVersionView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupFileChooser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedWithNullize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCompilerArguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jsCompilerArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jvmCompilerArguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOverridingModulesWarning";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindOrDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedJvmVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLanguageVersionView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAPIVersionView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupFileChooser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isModifiedWithNullize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ThreeStateCheckBox threeStateCheckBox;
        ThreeStateCheckBox threeStateCheckBox2;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel2;
        ThreeStateCheckBox threeStateCheckBox3;
        JComboBox jComboBox2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField;
        JLabel jLabel4;
        JTextField jTextField2;
        JPanel jPanel4;
        JCheckBox jCheckBox2;
        JComboBox jComboBox3;
        JTextField jTextField3;
        JLabel jLabel5;
        ThreeStateCheckBox threeStateCheckBox4;
        JComboBox jComboBox4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel8;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        this.contentPane = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(12, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.k2jsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setVisible(true);
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel5, new GridConstraints(9, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.panel.title"), (int)0, (int)0, null, null));
        this.labelForOutputPrefixFile = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.prefix"));
        jPanel5.add((Component)jLabel8, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPrefixFile = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputPostfixFile = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.postfix"));
        jPanel5.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPostfixFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputDirectory = jLabel6 = new JLabel();
        jLabel6.setText("Destination directory");
        jLabel6.setDisplayedMnemonic('D');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel6, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.outputDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("lib");
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        ThreeStateCheckBox threeStateCheckBox5 = this.copyRuntimeFilesCheckBox;
        threeStateCheckBox5.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox5, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.copy.files"));
        jPanel5.add((Component)threeStateCheckBox5, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Module kind:");
        jLabel9.setDisplayedMnemonic('K');
        jLabel9.setDisplayedMnemonicIndex(7);
        jPanel5.add((Component)jLabel9, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.moduleKindComboBox = jComboBox4 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox4.setModel(defaultComboBoxModel);
        jPanel5.add(jComboBox4, new GridConstraints(8, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.generateSourceMapsCheckBox = threeStateCheckBox4 = new ThreeStateCheckBox();
        threeStateCheckBox4.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox4, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.generate.sourcemaps"));
        jPanel5.add((Component)threeStateCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.labelForSourceMapPrefix = jLabel5 = new JLabel();
        jLabel5.setText("Add prefix to paths in source map:");
        jPanel5.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.sourceMapPrefix = jTextField3 = new JTextField();
        jPanel5.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Embed source code into source map:");
        jPanel5.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.sourceMapEmbedSources = jComboBox3 = new JComboBox();
        jPanel5.add(jComboBox3, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.enableIncrementalCompilationForJsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable incremental compilation");
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.scriptPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel4, new GridConstraints(10, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Kotlin Scripting", (int)0, (int)0, null, null));
        this.scriptTemplatesField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesClasspathLabel = jLabel4 = new JLabel();
        jLabel4.setText("Script templates classpath:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(22);
        jPanel4.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.scriptTemplatesClasspathField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesLabel = jLabel3 = new JLabel();
        ((Component)jLabel3).setEnabled(true);
        jLabel3.setText("Script template classes:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.warningLabel = jLabel2 = new JLabel();
        jLabel2.setFocusable(false);
        jLabel2.setInheritsPopupMenu(false);
        jLabel2.setText("");
        ((Component)jLabel2).setVisible(false);
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.k2jvmPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel3, new GridConstraints(8, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.jvm.option.panel.title"), (int)0, (int)0, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Target JVM version");
        jLabel11.setDisplayedMnemonic('J');
        jLabel11.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jLabel11, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.enableIncrementalCompilationForJvmCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable incremental compilation");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.jvmVersionComboBox = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.reportWarningsCheckBox = threeStateCheckBox3 = new ThreeStateCheckBox();
        threeStateCheckBox3.setSelected(false);
        threeStateCheckBox3.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox3, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.generate.no.warnings"));
        jPanel8.add((Component)threeStateCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Language version");
        jLabel12.setDisplayedMnemonic('L');
        jLabel12.setDisplayedMnemonicIndex(0);
        jPanel9.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox5 = new JComboBox();
        this.languageVersionComboBox = jComboBox5;
        jPanel9.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel10, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("API version");
        jLabel13.setDisplayedMnemonic('I');
        jLabel13.setDisplayedMnemonicIndex(2);
        jPanel10.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox6 = new JComboBox();
        this.apiVersionComboBox = jComboBox6;
        jPanel10.add(jComboBox6, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.coroutinesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Coroutines");
        jLabel14.setDisplayedMnemonic('U');
        jLabel14.setDisplayedMnemonicIndex(4);
        jPanel2.add((Component)jLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.coroutineSupportComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.additionalArgsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.additional.command.line.parameters"));
        jPanel6.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalArgsOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Additional command line parameters");
        jPanel6.add((Component)rawCommandLineEditor, new GridConstraints(6, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.keepAliveCheckBox = threeStateCheckBox2 = new ThreeStateCheckBox();
        threeStateCheckBox2.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        threeStateCheckBox2.setText("Keep compiler process alive between invocations");
        jPanel6.add((Component)threeStateCheckBox2, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel11, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.enableNewInferenceInIDECheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setSelected(false);
        threeStateCheckBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.enable.new.inference.in.ide"));
        jPanel11.add((Component)threeStateCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        jLabel9.setLabelFor(jComboBox4);
        jLabel5.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField);
        jLabel3.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

