/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ide.konan.NativeLibraryKind;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleLibraryDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "resetLibraryKind", "modifiableModel", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "looksAsNonJvmLibrary", "", "Lcom/intellij/openapi/roots/libraries/Library;", "Companion", "idea-gradle"})
public final class KotlinGradleLibraryDataService
extends AbstractProjectDataService<LibraryData, Void> {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> nonJvmSuffixes;
    public static final Companion Companion;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.LIBRARY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        boolean bl;
        Iterator iterator2;
        block13: {
            boolean bl2;
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
            if (toImport.isEmpty()) {
                return;
            }
            DataNode dataNode = ((DataNode)CollectionsKt.first((Iterable)toImport)).getParent();
            if (dataNode == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"toImport.first().parent!!");
            DataNode projectDataNode = dataNode;
            Collection collection = projectDataNode.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"projectDataNode.children");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                DataNode it = (DataNode)element$iv$iv;
                bl2 = false;
                DataNode dataNode2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"it");
                if (!(dataNode2.getData() instanceof ModuleData)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDataNodes = (List)destination$iv$iv;
            Iterable $this$any$iv = moduleDataNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdePlatformKind<Object> idePlatformKind;
                    DataNode node = (DataNode)element$iv;
                    boolean bl3 = false;
                    if (KotlinGradleSourceSetDataServiceKt.detectPlatformKindByPlugin((DataNode<ModuleData>)node) != null) {
                        IdePlatformKind<?> idePlatformKind2;
                        bl2 = false;
                        boolean bl4 = false;
                        IdePlatformKind<?> it = idePlatformKind2;
                        boolean bl5 = false;
                        idePlatformKind = !JvmIdePlatformUtil.isJvm(it) ? idePlatformKind2 : null;
                    } else {
                        idePlatformKind = null;
                    }
                    if (!(idePlatformKind != null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        boolean anyNonJvmModules = bl;
        for (DataNode<LibraryData> libraryDataNode : toImport) {
            Library ideLibrary;
            if (modelsProvider.findIdeLibrary((LibraryData)libraryDataNode.getData()) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ideLibrary, (String)"modelsProvider.findIdeLi\u2026ataNode.data) ?: continue");
            Library.ModifiableModel modifiableModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
            if (modifiableModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
            }
            LibraryEx.ModifiableModelEx modifiableModel2 = (LibraryEx.ModifiableModelEx)modifiableModel;
            if (anyNonJvmModules || this.looksAsNonJvmLibrary(ideLibrary)) {
                VirtualFile[] virtualFileArray = modifiableModel2.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"modifiableModel.getFiles(OrderRootType.CLASSES)");
                if (LibraryKindsKt.detectLibraryKind(virtualFileArray) != null) {
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Iterator it = iterator2;
                    boolean bl8 = false;
                    modifiableModel2.setKind(it);
                }
                continue;
            }
            if (!(ideLibrary instanceof LibraryImpl) || ((LibraryImpl)ideLibrary).getKind() != JSLibraryKind.INSTANCE && ((LibraryImpl)ideLibrary).getKind() != NativeLibraryKind.INSTANCE && ((LibraryImpl)ideLibrary).getKind() != CommonLibraryKind.INSTANCE) continue;
            this.resetLibraryKind(modifiableModel2);
        }
    }

    private final boolean looksAsNonJvmLibrary(@NotNull Library $this$looksAsNonJvmLibrary) {
        block8: {
            block9: {
                boolean bl;
                String name2;
                block7: {
                    String string = $this$looksAsNonJvmLibrary.getName();
                    if (string == null) break block8;
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    name2 = string2;
                    boolean bl4 = false;
                    Iterable $this$any$iv = nonJvmSuffixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            String string3 = name2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                            if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) break block9;
                String string = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                if (!StringsKt.startsWith$default((String)string, (String)"Kotlin/Native", (boolean)false, (int)2, null)) break block8;
            }
            return true;
        }
        Object[] objectArray = $this$looksAsNonJvmLibrary.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"getFiles(OrderRootType.CLASSES)");
        VirtualFile virtualFile2 = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
        return Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getExtension() : null), (Object)"klib");
    }

    private final void resetLibraryKind(LibraryEx.ModifiableModelEx modifiableModel) {
        try {
            Class<LibraryImpl> cls = LibraryImpl.class;
            Field[] fieldArray = cls.getDeclaredFields();
            int n = fieldArray.length;
            for (int j = 0; j < n; ++j) {
                Field field2;
                Field field3 = field2 = fieldArray[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"field");
                if (!Intrinsics.areEqual(field3.getType(), PersistentLibraryKind.class)) continue;
                field2.setAccessible(true);
                field2.set(modifiableModel, null);
                return;
            }
            LOG.info("Could not find field of type PersistentLibraryKind in LibraryImpl.class");
        }
        catch (Exception e) {
            LOG.info("Failed to reset library kind", (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinGradleLibraryDataService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026yDataService::class.java)");
        LOG = logger;
        nonJvmSuffixes = CollectionsKt.listOf((Object[])new String[]{"-common", "-js", "-native", "-kjsm", "-metadata"});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleLibraryDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "nonJvmSuffixes", "", "", "getNonJvmSuffixes", "()Ljava/util/List;", "idea-gradle"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final List<String> getNonJvmSuffixes() {
            return nonJvmSuffixes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

