/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleAbstractMultiplatformModuleBuilder;
import org.jetbrains.kotlin.idea.configuration.xcode.XcodeProjectConfigurator;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020\u0004H\u0016J\f\u0010!\u001a\u00020\u001b*\u00020\"H\u0014J\f\u0010#\u001a\u00020\u001b*\u00020\"H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleMobileMultiplatformModuleBuilder;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleAbstractMultiplatformModuleBuilder;", "()V", "androidAppName", "", "commonName", "commonSourceName", "getCommonSourceName", "()Ljava/lang/String;", "commonTestName", "getCommonTestName", "jvmSourceName", "getJvmSourceName", "jvmTargetName", "jvmTestName", "getJvmTestName", "mainSourceName", "getMainSourceName", "mainTestName", "getMainTestName", "nativeSourceName", "getNativeSourceName", "nativeTargetName", "nativeTestName", "getNativeTestName", "buildMultiPlatformPart", "createProjectSkeleton", "", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBuilderId", "getDescription", "getPresentableName", "setupAdditionalDependencies", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "setupAdditionalDependenciesForApplication", "idea-gradle"})
public final class KotlinGradleMobileMultiplatformModuleBuilder
extends KotlinGradleAbstractMultiplatformModuleBuilder {
    private final String commonName = "common";
    private String jvmTargetName = "android";
    private String nativeTargetName = "ios";
    private final String androidAppName = this.getMppDirName();

    private final String getCommonSourceName() {
        return this.commonName + "Main";
    }

    private final String getCommonTestName() {
        return this.commonName + "Test";
    }

    private final String getJvmSourceName() {
        return this.jvmTargetName + "Main";
    }

    private final String getJvmTestName() {
        return this.jvmTargetName + "Test";
    }

    private final String getNativeSourceName() {
        return this.nativeTargetName + "Main";
    }

    private final String getNativeTestName() {
        return this.nativeTargetName + "Test";
    }

    private final String getMainSourceName() {
        String string = "Main";
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    private final String getMainTestName() {
        String string = "Test";
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform.mobile";
    }

    @NotNull
    public String getPresentableName() {
        return "Mobile Android/iOS | Gradle";
    }

    @NotNull
    public String getDescription() {
        return "Multiplatform Gradle project allowing reuse of the same Kotlin code between Android and iOS mobile platforms";
    }

    @Override
    protected void setupAdditionalDependencies(@NotNull BuildScriptDataBuilder $this$setupAdditionalDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setupAdditionalDependencies, (String)"$this$setupAdditionalDependencies");
        $this$setupAdditionalDependencies.addBuildscriptDependencyNotation("classpath 'com.android.tools.build:gradle:3.2.0'");
        $this$setupAdditionalDependencies.addBuildscriptRepositoriesDefinition("google()");
        $this$setupAdditionalDependencies.addBuildscriptRepositoriesDefinition("jcenter()");
        $this$setupAdditionalDependencies.addRepositoriesDefinition("google()");
        $this$setupAdditionalDependencies.addRepositoriesDefinition("jcenter()");
    }

    @Override
    protected void setupAdditionalDependenciesForApplication(@NotNull BuildScriptDataBuilder $this$setupAdditionalDependenciesForApplication) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setupAdditionalDependenciesForApplication, (String)"$this$setupAdditionalDependenciesForApplication");
        $this$setupAdditionalDependenciesForApplication.addRepositoriesDefinition("google()");
        $this$setupAdditionalDependenciesForApplication.addRepositoriesDefinition("jcenter()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProjectSkeleton(@NotNull VirtualFile rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        VirtualFile virtualFile2 = rootDir.findChild(this.androidAppName);
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"rootDir.findChild(androidAppName)!!");
        VirtualFile appDir = virtualFile2;
        VirtualFile virtualFile3 = appDir.createChildDirectory((Object)this, "src");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"appDir.createChildDirectory(this, \"src\")");
        VirtualFile src = virtualFile3;
        BufferedWriter commonMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonSourceName(), null, null, null, 14, null);
        BufferedWriter commonTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonTestName(), null, null, "SampleTests.kt", 6, null);
        BufferedWriter androidMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getMainSourceName(), this.jvmTargetName, "java", null, 8, null);
        BufferedWriter androidTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getMainTestName(), null, "java", "SampleTestsAndroid.kt", 2, null);
        VirtualFile virtualFile4 = appDir.createChildData((Object)appDir, "Info.plist");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"appDir.createChildData(appDir,\"Info.plist\")");
        BufferedWriter appInfo = this.bufferedWriter(virtualFile4);
        VirtualFile virtualFile5 = rootDir.createChildData((Object)this, "local.properties");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"rootDir.createChildData(this, \"local.properties\")");
        BufferedWriter androidLocalProperties = this.bufferedWriter(virtualFile5);
        VirtualFile virtualFile6 = src.findChild(this.getMainSourceName());
        if (virtualFile6 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile6, (String)"src.findChild(mainSourceName)!!");
        VirtualFile androidRoot = virtualFile6;
        VirtualFile virtualFile7 = androidRoot.createChildData((Object)this, "AndroidManifest.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile7, (String)"androidRoot.createChildD\u2026s, \"AndroidManifest.xml\")");
        BufferedWriter androidManifest = this.bufferedWriter(virtualFile7);
        VirtualFile virtualFile8 = androidRoot.createChildDirectory((Object)this, "res");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile8, (String)"androidRoot.createChildDirectory(this, \"res\")");
        VirtualFile androidResources = virtualFile8;
        VirtualFile virtualFile9 = androidResources.createChildDirectory((Object)this, "values");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile9, (String)"androidResources.createC\u2026Directory(this, \"values\")");
        VirtualFile androidValues = virtualFile9;
        VirtualFile virtualFile10 = androidResources.createChildDirectory((Object)this, "layout");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile10, (String)"androidResources.createC\u2026Directory(this, \"layout\")");
        VirtualFile androidLayout = virtualFile10;
        VirtualFile virtualFile11 = androidValues.createChildData((Object)this, "strings.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile11, (String)"androidValues.createChildData(this, \"strings.xml\")");
        BufferedWriter androidStrings = this.bufferedWriter(virtualFile11);
        VirtualFile virtualFile12 = androidValues.createChildData((Object)this, "styles.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile12, (String)"androidValues.createChildData(this, \"styles.xml\")");
        BufferedWriter androidStyles = this.bufferedWriter(virtualFile12);
        VirtualFile virtualFile13 = androidLayout.createChildData((Object)this, "activity_main.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile13, (String)"androidLayout.createChil\u2026his, \"activity_main.xml\")");
        BufferedWriter androidActivityMain = this.bufferedWriter(virtualFile13);
        BufferedWriter nativeMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeSourceName(), this.nativeTargetName, null, null, 12, null);
        BufferedWriter nativeTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeTestName(), null, null, "SampleTestsIOS.kt", 6, null);
        XcodeProjectConfigurator xcodeConfigurator = new XcodeProjectConfigurator();
        try {
            commonMain.write("package sample\n\nexpect class Sample() {\n    fun checkMe(): Int\n}\n\nexpect object Platform {\n    val name: String\n}\n\nfun hello(): String = \"Hello from ${Platform.name}\"\n\nclass Proxy {\n    fun proxyHello() = hello()\n}\n\nfun main() {\n    println(hello())\n}");
            androidMain.write("package sample\n\nimport android.support.v7.app.AppCompatActivity\nimport android.os.Bundle\nimport android.widget.TextView\n\nactual class Sample {\n    actual fun checkMe() = 44\n}\n\nactual object Platform {\n    actual val name: String = \"Android\"\n}\n\nclass MainActivity : AppCompatActivity() {\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        Sample().checkMe()\n        setContentView(R.layout.activity_main)\n        findViewById<TextView>(R.id.main_text).text = hello()\n    }\n}");
            nativeMain.write("package sample\n\nactual class Sample {\n    actual fun checkMe() = 7\n}\n\nactual object Platform {\n    actual val name: String = \"iOS\"\n}");
            commonTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTests {\n    @Test\n    fun testMe() {\n        assertTrue(Sample().checkMe() > 0)\n    }\n\n    @Test\n    fun testProxy() {\n        assertTrue(Proxy().proxyHello().isNotEmpty())\n    }\n}");
            androidTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTestsAndroid {\n    @Test\n    fun testHello() {\n        assertTrue(\"Android\" in hello())\n    }\n}");
            nativeTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTestsIOS {\n    @Test\n    fun testHello() {\n        assertTrue(\"iOS\" in hello())\n    }\n}");
            androidLocalProperties.write("## This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n#\n# Location of the SDK. This is only used by Gradle.\n# For customization when using a Version Control System, please read the\n# header note.\nsdk.dir=PleaseSpecifyAndroidSdkPathHere");
            androidManifest.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n          package=\"sample\">\n\n    <application\n            android:allowBackup=\"true\"\n            android:label=\"@string/app_name\"\n            android:supportsRtl=\"true\"\n            android:theme=\"@style/AppTheme\">\n        <activity android:name=\"sample.MainActivity\">\n            <intent-filter>\n                <action android:name=\"android.intent.action.MAIN\" />\n\n                <category android:name=\"android.intent.category.LAUNCHER\" />\n            </intent-filter>\n        </activity>\n    </application>\n\n</manifest>");
            androidStrings.write("<resources>\n    <string name=\"app_name\">android-app</string>\n</resources>");
            androidStyles.write("<resources>\n    <!-- Base application theme. -->\n    <style name=\"AppTheme\" parent=\"Theme.AppCompat.Light.DarkActionBar\">\n        <!-- Customize your theme here. -->\n    </style>\n</resources>");
            androidActivityMain.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<android.support.constraint.ConstraintLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    xmlns:tools=\"http://schemas.android.com/tools\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\"\n    tools:context=\".MainActivity\">\n\n    <TextView\n        android:id=\"@+id/main_text\"\n        android:textSize=\"42sp\"\n        android:layout_margin=\"5sp\"\n        android:textAlignment=\"center\"\n        android:layout_width=\"wrap_content\"\n        android:layout_height=\"wrap_content\"\n        app:layout_constraintBottom_toBottomOf=\"parent\"\n        app:layout_constraintLeft_toLeftOf=\"parent\"\n        app:layout_constraintRight_toRightOf=\"parent\"\n        app:layout_constraintTop_toTopOf=\"parent\" />\n\n</android.support.constraint.ConstraintLayout>");
            appInfo.write(xcodeConfigurator.templatePlist("<key>CFBundlePackageType</key>\n<string>FMWK</string>"));
        }
        catch (Throwable throwable) {
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, androidMain, androidTest, nativeMain, nativeTest, appInfo, androidLocalProperties, androidManifest, androidStrings, androidStyles, androidActivityMain});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BufferedWriter p1 = (BufferedWriter)element$iv;
                boolean bl = false;
                p1.close();
            }
            throw throwable;
        }
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, androidMain, androidTest, nativeMain, nativeTest, appInfo, androidLocalProperties, androidManifest, androidStrings, androidStyles, androidActivityMain});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BufferedWriter p1 = (BufferedWriter)element$iv;
            boolean bl = false;
            p1.close();
        }
        xcodeConfigurator.createSkeleton(rootDir);
    }

    @Override
    @NotNull
    protected String buildMultiPlatformPart() {
        return StringsKt.trimIndent((String)("\n            apply plugin: 'com.android.application'\n            apply plugin: 'kotlin-android-extensions'\n\n            android {\n                compileSdkVersion 28\n                defaultConfig {\n                    applicationId 'org.jetbrains.kotlin.mpp_app_android'\n                    minSdkVersion 15\n                    targetSdkVersion 28\n                    versionCode 1\n                    versionName '1.0'\n                    testInstrumentationRunner 'android.support.test.runner.AndroidJUnitRunner'\n                }\n                buildTypes {\n                    release {\n                        minifyEnabled false\n                    }\n                }\n            }\n\n            dependencies {\n                implementation fileTree(dir: 'libs', include: ['*.jar'])\n                implementation 'com.android.support:appcompat-v7:28.0.0'\n                implementation 'com.android.support.constraint:constraint-layout:1.1.3'\n                androidTestImplementation 'com.android.support.test:runner:1.0.2'\n            }\n\n            kotlin {\n                android(\"" + this.jvmTargetName + "\")\n                // This is for iPhone emulator\n                // Switch here to iosArm64 (or iosArm32) to build library for iPhone device\n                iosX64(\"" + this.nativeTargetName + "\") {\n                    binaries {\n                        framework()\n                    }\n                }\n                sourceSets {\n                    " + this.getCommonSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib-common')\n                        }\n                    }\n                    " + this.getCommonTestName() + " {\n                        dependencies {\n                    \t\timplementation kotlin('test-common')\n                    \t\timplementation kotlin('test-annotations-common')\n                        }\n                    }\n                    " + this.getJvmSourceName() + " {\n                        dependencies {\n                            implementation kotlin('stdlib')\n                        }\n                    }\n                    " + this.getJvmTestName() + " {\n                        dependencies {\n                            implementation kotlin('test')\n                            implementation kotlin('test-junit')\n                        }\n                    }\n                    " + this.getNativeSourceName() + " {\n                    }\n                    " + this.getNativeTestName() + " {\n                    }\n                }\n            }\n\n            // This task attaches native framework built from ios module to Xcode project\n            // (see iosApp directory). Don't run this task directly,\n            // Xcode runs this task itself during its build process.\n            // Before opening the project from iosApp directory in Xcode,\n            // make sure all Gradle infrastructure exists (gradle.wrapper, gradlew).\n            task copyFramework {\n                def buildType = project.findProperty('kotlin.build.type') ?: 'DEBUG'\n                def target = project.findProperty('kotlin.target') ?: 'ios'\n                dependsOn kotlin.targets.\"$target\".binaries.getFramework(buildType).linkTask\n\n                doLast {\n                    def srcFile = kotlin.targets.\"$target\".binaries.getFramework(buildType).outputFile\n                    def targetDir = getProperty('configuration.build.dir')\n                    copy {\n                        from srcFile.parent\n                        into targetDir\n                        include '" + this.androidAppName + ".framework/**'\n                        include '" + this.androidAppName + ".framework.dSYM'\n                    }\n                }\n            }\n        "));
    }

    public KotlinGradleMobileMultiplatformModuleBuilder() {
        super(true);
    }
}

