/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.core.ModuleUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u0004H\u0014J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0016H\u0014J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator;", "()V", "kotlinPluginName", "", "getKotlinPluginName", "()Ljava/lang/String;", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "configureModule", "", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "isTopLevelProjectFile", "", "version", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "filesToOpen", "", "getJvmTarget", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getKotlinPluginExpression", "forKotlinDsl", "isApplicable", "Companion", "idea-gradle"})
public final class KotlinGradleModuleConfigurator
extends KotlinWithGradleConfigurator {
    @NotNull
    private static final String NAME = "gradle";
    @NotNull
    private static final String KOTLIN = "kotlin";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatform.INSTANCE;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "Java with Gradle";
    }

    @Override
    @NotNull
    protected String getKotlinPluginName() {
        return KOTLIN;
    }

    @Override
    @NotNull
    protected String getKotlinPluginExpression(boolean forKotlinDsl) {
        return forKotlinDsl ? "kotlin(\"jvm\")" : "id 'org.jetbrains.kotlin.jvm'";
    }

    @Override
    @Nullable
    protected String getJvmTarget(@Nullable Sdk sdk2, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        JvmTarget jvmTarget = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget(sdk2, version);
        return jvmTarget != null ? jvmTarget.getDescription() : null;
    }

    @Override
    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return super.isApplicable(module) && !ModuleUtilsKt.isAndroidModule$default(module, null, 1, null);
    }

    @Override
    public void configureModule(@NotNull Module module, @NotNull PsiFile file2, boolean isTopLevelProjectFile, @NotNull String version, @NotNull NotificationMessageCollector collector2, @NotNull Collection<PsiFile> filesToOpen) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull(filesToOpen, (String)"filesToOpen");
        super.configureModule(module, file2, isTopLevelProjectFile, version, collector2, filesToOpen);
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.getWholeModuleGroup(module);
        for (Module sourceModule : ModuleSourceRootMapKt.allModules(moduleGroup)) {
            if (ConfigureKotlinInProjectUtilsKt.addStdlibToJavaModuleInfo(sourceModule, collector2)) break;
        }
    }

    static {
        NAME = NAME;
        KOTLIN = KOTLIN;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleModuleConfigurator$Companion;", "", "()V", "KOTLIN", "", "getKOTLIN", "()Ljava/lang/String;", "NAME", "getNAME", "idea-gradle"})
    public static final class Companion {
        @NotNull
        public final String getNAME() {
            return NAME;
        }

        @NotNull
        public final String getKOTLIN() {
            return KOTLIN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

