/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.ElementsAndTextsProcessor;
import org.jetbrains.kotlin.idea.conversion.copy.KotlinPasteFromJavaDialog;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.j2k.JavaToKotlinConverterFactory;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ElementResult;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.ParseContext;
import org.jetbrains.kotlin.j2k.Result;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\r"}, d2={"confirmConvertJavaOnPaste", "", "project", "Lcom/intellij/openapi/project/Project;", "isPlainText", "isNoConversionPosition", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "idea"})
public final class ConvertJavaCopyPasteProcessorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversionResult convertCodeToKotlin(@NotNull ElementAndTextList $this$convertCodeToKotlin, @NotNull Project project) {
        void parseContext;
        void resultIndex;
        void results2;
        Object element$iv$iv;
        Result $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$convertCodeToKotlin, (String)"$this$convertCodeToKotlin");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JavaToKotlinConverter converter = JavaToKotlinConverterFactory.INSTANCE.createJavaToKotlinConverter(project, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
        List<ElementResult> $this$filterIsInstance$iv = (List<ElementResult>)$this$convertCodeToKotlin.toList();
        boolean $i$f$filterIsInstance = false;
        List<ElementResult> list2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof PsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inputElements = (List)destination$iv$iv;
        $this$filterIsInstanceTo$iv$iv = (Result)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Result, Exception>(converter, inputElements){
            final /* synthetic */ JavaToKotlinConverter $converter;
            final /* synthetic */ List $inputElements;

            @NotNull
            public final Result compute() {
                return (Result)ApplicationUtilsKt.runReadAction((Function0)new Function0<Result>(this){
                    final /* synthetic */ convertCodeToKotlin.1 this$0;

                    @NotNull
                    public final Result invoke() {
                        return this.this$0.$converter.elementsToKotlin(this.this$0.$inputElements);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$converter = javaToKotlinConverter;
                this.$inputElements = list2;
            }
        }, JavaToKotlinAction.Companion.getTitle(), false, project);
        $this$filterIsInstance$iv = $this$filterIsInstanceTo$iv$iv.component1();
        ConverterContext converterContext = $this$filterIsInstanceTo$iv$iv.component3();
        LinkedHashSet importsToAdd = new LinkedHashSet();
        destination$iv$iv = new Ref.IntRef();
        ((Ref.IntRef)destination$iv$iv).element = 0;
        StringBuilder convertedCodeBuilder = new StringBuilder();
        StringBuilder originalCodeBuilder = new StringBuilder();
        element$iv$iv = new Ref.ObjectRef();
        ((Ref.ObjectRef)element$iv$iv).element = null;
        $this$convertCodeToKotlin.process(new ElementsAndTextsProcessor(originalCodeBuilder, (List)results2, (Ref.IntRef)resultIndex, convertedCodeBuilder, (Ref.ObjectRef)parseContext, importsToAdd){
            final /* synthetic */ StringBuilder $originalCodeBuilder;
            final /* synthetic */ List $results;
            final /* synthetic */ Ref.IntRef $resultIndex;
            final /* synthetic */ StringBuilder $convertedCodeBuilder;
            final /* synthetic */ Ref.ObjectRef $parseContext;
            final /* synthetic */ LinkedHashSet $importsToAdd;

            public void processElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                String originalText = element3.getText();
                this.$originalCodeBuilder.append(originalText);
                int n = this.$resultIndex.element;
                this.$resultIndex.element = n + 1;
                ElementResult result2 = (ElementResult)this.$results.get(n);
                if (result2 != null) {
                    this.$convertedCodeBuilder.append(result2.getText());
                    if ((ParseContext)((Object)this.$parseContext.element) == null) {
                        this.$parseContext.element = result2.getParseContext();
                    }
                    this.$importsToAdd.addAll((Collection)result2.getImportsToAdd());
                } else {
                    this.$convertedCodeBuilder.append(originalText);
                }
            }

            public void processText(@NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
                this.$originalCodeBuilder.append(string);
                this.$convertedCodeBuilder.append(string);
            }
            {
                this.$originalCodeBuilder = $captured_local_variable$0;
                this.$results = $captured_local_variable$1;
                this.$resultIndex = $captured_local_variable$2;
                this.$convertedCodeBuilder = $captured_local_variable$3;
                this.$parseContext = $captured_local_variable$4;
                this.$importsToAdd = $captured_local_variable$5;
            }
        });
        String string = convertedCodeBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"convertedCodeBuilder.toString()");
        String convertedCode = string;
        String string2 = originalCodeBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"originalCodeBuilder.toString()");
        String originalCode = string2;
        ParseContext parseContext2 = (ParseContext)((Object)parseContext.element);
        if (parseContext2 == null) {
            parseContext2 = ParseContext.CODE_BLOCK;
        }
        return new ConversionResult(convertedCode, parseContext2, importsToAdd, Intrinsics.areEqual((Object)convertedCode, (Object)originalCode) ^ true, converterContext);
    }

    public static final boolean isNoConversionPosition(@NotNull KtFile file2, int offset2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (offset2 == 0) {
            return false;
        }
        PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(offset - 1)!!");
        PsiElement token = psiElement2;
        if (!(token instanceof PsiWhiteSpace) && PsiUtilsKt.getEndOffset(token) != offset2) {
            return true;
        }
        for (PsiElement element3 : PsiUtilsKt.getParentsWithSelf(token)) {
            if (element3 instanceof PsiComment) {
                ASTNode aSTNode = ((PsiComment)element3).getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
                return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.EOL_COMMENT)) || offset2 != PsiUtilsKt.getEndOffset(element3);
            }
            if (element3 instanceof KtStringTemplateEntryWithExpression) {
                return false;
            }
            if (!(element3 instanceof KtStringTemplateExpression)) continue;
            return true;
        }
        return false;
    }

    public static final boolean confirmConvertJavaOnPaste(@NotNull Project project, boolean isPlainText) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KotlinEditorOptions kotlinEditorOptions = KotlinEditorOptions.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinEditorOptions, (String)"KotlinEditorOptions.getInstance()");
        if (kotlinEditorOptions.isDonTShowConversionDialog()) {
            return true;
        }
        KotlinPasteFromJavaDialog dialog2 = new KotlinPasteFromJavaDialog(project, isPlainText);
        dialog2.show();
        return dialog2.isOK();
    }
}

