/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolveInWriteActionManagerKt;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.ShortenReferences$ShortenQualifiedExpressionsProcessor$WhenMappings;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ImportDescriptorResult;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.ShadowedDeclarationsFilter;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \u001c2\u00020\u0001:\u000b\u001b\u001c\u001d\u001e\u001f !\"#$%B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0003H\u0007J&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0003H\u0007J\u001e\u0010\r\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J8\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0003H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "", "options", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "(Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Lkotlin/jvm/functions/Function1;", "dropNestedElements", "Ljava/util/LinkedHashSet;", "elements", "", "process", "", "", "elementFilter", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "element", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "shortenReferencesInFile", "CollectElementsVisitor", "Companion", "ElementToAnalyze", "FilterResult", "Options", "QualifiedExpressionShorteningProcessor", "RemoveExplicitCompanionObjectReferenceProcessor", "ShortenQualifiedExpressionsProcessor", "ShortenThisExpressionsProcessor", "ShortenTypesProcessor", "ShorteningProcessor", "idea-core"})
public final class ShortenReferences {
    @NotNull
    private final Function1<KtElement, Options> options;
    @JvmField
    @NotNull
    public static final ShortenReferences DEFAULT;
    @NotNull
    private static final ShortenReferences RETAIN_COMPANION;
    public static final Companion Companion;

    @JvmOverloads
    @NotNull
    public final KtElement process(@NotNull KtElement element3, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
        return (KtElement)CollectionsKt.single((Iterable)this.process(CollectionsKt.listOf((Object)element3), elementFilter));
    }

    public static /* synthetic */ KtElement process$default(ShortenReferences shortenReferences2, KtElement ktElement, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = process.1.INSTANCE;
        }
        return shortenReferences2.process(ktElement, (Function1<? super PsiElement, ? extends FilterResult>)function1);
    }

    @JvmOverloads
    @NotNull
    public final KtElement process(@NotNull KtElement element3) {
        return ShortenReferences.process$default(this, element3, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull KtFile file2, int startOffset, int endOffset) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
        FileViewProvider fileViewProvider = file2.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"file.viewProvider.document!!");
        Document document2 = document;
        if (!documentManager.isCommitted(document2)) {
            throw (Throwable)new IllegalStateException("Document should be committed to shorten references in range");
        }
        RangeMarker rangeMarker = document2.createRangeMarker(startOffset, endOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"document.createRangeMarker(startOffset, endOffset)");
        RangeMarker rangeMarker2 = rangeMarker;
        rangeMarker2.setGreedyToLeft(true);
        rangeMarker2.setGreedyToRight(true);
        try {
            this.process(CollectionsKt.listOf((Object)file2), (Function1<? super PsiElement, ? extends FilterResult>)((Function1)new Function1<PsiElement, FilterResult>(rangeMarker2){
                final /* synthetic */ RangeMarker $rangeMarker;

                @NotNull
                public final FilterResult invoke(@NotNull PsiElement element3) {
                    FilterResult filterResult;
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    if (this.$rangeMarker.isValid()) {
                        TextRange range = new TextRange(this.$rangeMarker.getStartOffset(), this.$rangeMarker.getEndOffset());
                        TextRange textRange = element3.getTextRange();
                        if (textRange == null) {
                            Intrinsics.throwNpe();
                        }
                        TextRange elementRange = textRange;
                        if (range.contains(elementRange)) {
                            filterResult = FilterResult.PROCESS;
                        } else if (range.intersects(elementRange)) {
                            KtExpression calleeExpression2;
                            PsiElement psiElement2 = element3;
                            if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                                psiElement2 = null;
                            }
                            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
                            KtExpression ktExpression = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
                            if (!(ktExpression instanceof KtCallExpression)) {
                                ktExpression = null;
                            }
                            KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
                            KtExpression ktExpression2 = calleeExpression2 = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
                            if (calleeExpression2 != null) {
                                TextRange rangeWithoutParenthesis;
                                int n = elementRange.getStartOffset();
                                TextRange textRange2 = calleeExpression2.getTextRange();
                                if (textRange2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                filterResult = range.contains(rangeWithoutParenthesis = new TextRange(n, textRange2.getEndOffset())) ? FilterResult.PROCESS : FilterResult.GO_INSIDE;
                            } else {
                                filterResult = FilterResult.GO_INSIDE;
                            }
                        } else {
                            filterResult = FilterResult.SKIP;
                        }
                    } else {
                        filterResult = FilterResult.SKIP;
                    }
                    return filterResult;
                }
                {
                    this.$rangeMarker = rangeMarker;
                    super(1);
                }
            }));
        }
        finally {
            rangeMarker2.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Collection<KtElement> process(@NotNull Iterable<? extends KtElement> elements2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
        void $this$flatMapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
        Iterable<? extends KtElement> $this$groupBy$iv = elements2;
        boolean $i$f$groupBy = false;
        Iterable<? extends KtElement> iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            KtElement p1 = (KtElement)element$iv$iv;
            boolean bl = false;
            KtFile key$iv$iv = p1.getContainingKtFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator2 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator3 = iterator2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl3 = false;
            Object k = it.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
            Iterable list$iv$iv = this.shortenReferencesInFile((KtFile)k, (List)it.getValue(), elementFilter);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ Collection process$default(ShortenReferences shortenReferences2, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = process.3.INSTANCE;
        }
        return shortenReferences2.process(iterable, (Function1<? super PsiElement, ? extends FilterResult>)function1);
    }

    @JvmOverloads
    @NotNull
    public final Collection<KtElement> process(@NotNull Iterable<? extends KtElement> elements2) {
        return ShortenReferences.process$default(this, elements2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtElement> shortenReferencesInFile(KtFile file2, List<? extends KtElement> elements2, Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
        boolean anyChange;
        LinkedHashSet<KtElement> elementsToUse = this.dropNestedElements(elements2);
        Project project = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        ImportInsertHelper helper2 = ImportInsertHelper.Companion.getInstance(project);
        LinkedHashSet<DeclarationDescriptor> failedToImportDescriptors = new LinkedHashSet<DeclarationDescriptor>();
        Function1 companionElementFilter2 = (Function1)new Function1<PsiElement, FilterResult>(this, elementFilter){
            final /* synthetic */ ShortenReferences this$0;
            final /* synthetic */ Function1 $elementFilter;

            @NotNull
            public final FilterResult invoke(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return element3 instanceof KtElement && !((Options)this.this$0.getOptions().invoke((Object)element3)).getRemoveExplicitCompanion() ? FilterResult.SKIP : (FilterResult)((Object)this.$elementFilter.invoke((Object)element3));
            }
            {
                this.this$0 = shortenReferences2;
                this.$elementFilter = function1;
                super(1);
            }
        };
        do {
            void $this$flatMapTo$iv$iv;
            ShorteningProcessor it;
            void $this$flatMapTo$iv$iv2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            List processors = CollectionsKt.listOf((Object[])new ShorteningProcessor[]{new ShortenTypesProcessor(file2, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors), new ShortenThisExpressionsProcessor(file2, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors), new ShortenQualifiedExpressionsProcessor(file2, elementFilter, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors), new RemoveExplicitCompanionObjectReferenceProcessor(file2, (Function1<? super PsiElement, ? extends FilterResult>)companionElementFilter2, (Set<? extends DeclarationDescriptor>)failedToImportDescriptors)});
            Iterable $this$map$iv = processors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it2;
                ShorteningProcessor shorteningProcessor = (ShorteningProcessor)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CollectElementsVisitor collectElementsVisitor2 = it2.getCollectElementsVisitor();
                collection.add(collectElementsVisitor2);
            }
            List visitors = (List)destination$iv$iv;
            for (CollectElementsVisitor visitor2 : visitors) {
                destination$iv$iv = elementsToUse.iterator();
                while (destination$iv$iv.hasNext()) {
                    KtElement element3;
                    KtElement ktElement = element3 = (KtElement)destination$iv$iv.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"element");
                    visitor2.setOptions((Options)this.options.invoke((Object)ktElement));
                    element3.accept(visitor2);
                }
            }
            Iterable $this$flatMap$iv = visitors;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Iterator destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            item$iv$iv2 = $this$flatMapTo$iv$iv2.iterator();
            while (item$iv$iv2.hasNext()) {
                void $this$mapTo$iv$iv2;
                Object element$iv$iv = item$iv$iv2.next();
                CollectElementsVisitor visitor3 = (CollectElementsVisitor)((Object)element$iv$iv);
                boolean bl = false;
                Iterable $this$map$iv2 = visitor3.getElementsToAnalyze();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    void it3;
                    ElementToAnalyze elementToAnalyze = (ElementToAnalyze)item$iv$iv3;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    KtElement ktElement = (KtElement)it3.getElement();
                    collection.add(ktElement);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll(destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List allElementsToAnalyze = (List)((Object)destination$iv$iv2);
            BindingContext bindingContext2 = (BindingContext)ResolveInWriteActionManagerKt.allowResolveInWriteAction((Function0)new Function0<BindingContext>(file2, allElementsToAnalyze){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ List $allElementsToAnalyze;

                @NotNull
                public final BindingContext invoke() {
                    return ResolutionUtils.getResolutionFacade(this.$file).analyze(this.$allElementsToAnalyze, BodyResolveMode.PARTIAL_WITH_CFA);
                }
                {
                    this.$file = ktFile2;
                    this.$allElementsToAnalyze = list2;
                    super(0);
                }
            });
            Iterable $this$forEach$iv = processors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ShorteningProcessor)element$iv;
                boolean bl = false;
                it.analyzeCollectedElements(bindingContext2);
            }
            $this$forEach$iv = processors;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ShorteningProcessor)element$iv;
                boolean bl = false;
                it.shortenElements((Set<KtElement>)elementsToUse, this.options);
            }
            Iterable $this$flatMap$iv2 = processors;
            boolean $i$f$flatMap2 = false;
            Iterable element$iv = $this$flatMap$iv2;
            Collection destination$iv$iv42 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ShorteningProcessor it4 = (ShorteningProcessor)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it4.getDescriptorsToImport();
                CollectionsKt.addAll((Collection)destination$iv$iv42, (Iterable)list$iv$iv);
            }
            Set descriptorsToImport = CollectionsKt.toSet((Iterable)((List)destination$iv$iv42));
            anyChange = false;
            for (DeclarationDescriptor descriptor2 : descriptorsToImport) {
                boolean destination$iv$iv42 = !failedToImportDescriptors.contains(descriptor2);
                boolean bl = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !destination$iv$iv42) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                ImportDescriptorResult result2 = ImportInsertHelper.importDescriptor$default(helper2, file2, descriptor2, false, 4, null);
                if (result2 != ImportDescriptorResult.ALREADY_IMPORTED) {
                    anyChange = true;
                }
                if (result2 != ImportDescriptorResult.FAIL) continue;
                failedToImportDescriptors.add(descriptor2);
            }
        } while (anyChange);
        return elementsToUse;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashSet<KtElement> dropNestedElements(List<? extends KtElement> elements2) {
        void $this$filterTo$iv;
        Set elementSet = CollectionsKt.toSet((Iterable)elements2);
        Iterable iterable = elementSet;
        Collection destination$iv = new LinkedHashSet(elementSet.size());
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            boolean bl;
            block2: {
                KtElement element3 = (KtElement)element$iv;
                boolean bl2 = false;
                Sequence<PsiElement> $this$none$iv = PsiUtilsKt.getParents((PsiElement)element3);
                boolean $i$f$none = false;
                for (Object element$iv2 : $this$none$iv) {
                    PsiElement it = (PsiElement)element$iv2;
                    boolean bl3 = false;
                    if (!CollectionsKt.contains((Iterable)elementSet, (Object)it)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv.add(element$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    @NotNull
    public final Function1<KtElement, Options> getOptions() {
        return this.options;
    }

    public ShortenReferences(@NotNull Function1<? super KtElement, Options> options2) {
        Intrinsics.checkParameterIsNotNull(options2, (String)"options");
        this.options = options2;
    }

    public /* synthetic */ ShortenReferences(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super KtElement, Options>)function1);
    }

    public ShortenReferences() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new ShortenReferences(null, 1, null);
        RETAIN_COMPANION = new ShortenReferences((Function1<? super KtElement, Options>)((Function1)Companion.RETAIN_COMPANION.1.INSTANCE));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "", "removeThisLabels", "", "removeThis", "removeExplicitCompanion", "dropBracesInStringTemplates", "(ZZZZ)V", "getDropBracesInStringTemplates", "()Z", "getRemoveExplicitCompanion", "getRemoveThis", "getRemoveThisLabels", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "idea-core"})
    public static final class Options {
        private final boolean removeThisLabels;
        private final boolean removeThis;
        private final boolean removeExplicitCompanion;
        private final boolean dropBracesInStringTemplates;
        @NotNull
        private static final Options DEFAULT;
        @NotNull
        private static final Options ALL_ENABLED;
        public static final Companion Companion;

        public final boolean getRemoveThisLabels() {
            return this.removeThisLabels;
        }

        public final boolean getRemoveThis() {
            return this.removeThis;
        }

        public final boolean getRemoveExplicitCompanion() {
            return this.removeExplicitCompanion;
        }

        public final boolean getDropBracesInStringTemplates() {
            return this.dropBracesInStringTemplates;
        }

        public Options(boolean removeThisLabels, boolean removeThis, boolean removeExplicitCompanion, boolean dropBracesInStringTemplates) {
            this.removeThisLabels = removeThisLabels;
            this.removeThis = removeThis;
            this.removeExplicitCompanion = removeExplicitCompanion;
            this.dropBracesInStringTemplates = dropBracesInStringTemplates;
        }

        public /* synthetic */ Options(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this(bl, bl2, bl3, bl4);
        }

        public Options() {
            this(false, false, false, false, 15, null);
        }

        static {
            Companion = new Companion(null);
            DEFAULT = new Options(false, false, false, false, 15, null);
            ALL_ENABLED = new Options(true, true, false, false, 12, null);
        }

        public final boolean component1() {
            return this.removeThisLabels;
        }

        public final boolean component2() {
            return this.removeThis;
        }

        public final boolean component3() {
            return this.removeExplicitCompanion;
        }

        public final boolean component4() {
            return this.dropBracesInStringTemplates;
        }

        @NotNull
        public final Options copy(boolean removeThisLabels, boolean removeThis, boolean removeExplicitCompanion, boolean dropBracesInStringTemplates) {
            return new Options(removeThisLabels, removeThis, removeExplicitCompanion, dropBracesInStringTemplates);
        }

        public static /* synthetic */ Options copy$default(Options options2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options2.removeThisLabels;
            }
            if ((n & 2) != 0) {
                bl2 = options2.removeThis;
            }
            if ((n & 4) != 0) {
                bl3 = options2.removeExplicitCompanion;
            }
            if ((n & 8) != 0) {
                bl4 = options2.dropBracesInStringTemplates;
            }
            return options2.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Options(removeThisLabels=" + this.removeThisLabels + ", removeThis=" + this.removeThis + ", removeExplicitCompanion=" + this.removeExplicitCompanion + ", dropBracesInStringTemplates=" + this.dropBracesInStringTemplates + ")";
        }

        public int hashCode() {
            int n = this.removeThisLabels ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.removeThis ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            int n4 = (n2 + n3) * 31;
            int n5 = this.removeExplicitCompanion ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            int n6 = (n4 + n5) * 31;
            int n7 = this.dropBracesInStringTemplates ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Options)) break block3;
                    Options options2 = (Options)object;
                    if (!(this.removeThisLabels == options2.removeThisLabels) || !(this.removeThis == options2.removeThis) || !(this.removeExplicitCompanion == options2.removeExplicitCompanion) || !(this.dropBracesInStringTemplates == options2.dropBracesInStringTemplates)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options$Companion;", "", "()V", "ALL_ENABLED", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "getALL_ENABLED", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "DEFAULT", "getDEFAULT", "idea-core"})
        public static final class Companion {
            @NotNull
            public final Options getDEFAULT() {
                return DEFAULT;
            }

            @NotNull
            public final Options getALL_ENABLED() {
                return ALL_ENABLED;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "", "(Ljava/lang/String;I)V", "SKIP", "GO_INSIDE", "PROCESS", "idea-core"})
    public static final class FilterResult
    extends Enum<FilterResult> {
        public static final /* enum */ FilterResult SKIP;
        public static final /* enum */ FilterResult GO_INSIDE;
        public static final /* enum */ FilterResult PROCESS;
        private static final /* synthetic */ FilterResult[] $VALUES;

        static {
            FilterResult[] filterResultArray = new FilterResult[3];
            FilterResult[] filterResultArray2 = filterResultArray;
            filterResultArray[0] = SKIP = new FilterResult();
            filterResultArray[1] = GO_INSIDE = new FilterResult();
            filterResultArray[2] = PROCESS = new FilterResult();
            $VALUES = filterResultArray;
        }

        public static FilterResult[] values() {
            return (FilterResult[])$VALUES.clone();
        }

        public static FilterResult valueOf(String string) {
            return Enum.valueOf(FilterResult.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ElementToAnalyze;", "TElement", "", "element", "level", "", "(Ljava/lang/Object;I)V", "getElement", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getLevel", "()I", "component1", "component2", "copy", "(Ljava/lang/Object;I)Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ElementToAnalyze;", "equals", "", "other", "hashCode", "toString", "", "idea-core"})
    private static final class ElementToAnalyze<TElement> {
        private final TElement element;
        private final int level;

        public final TElement getElement() {
            return this.element;
        }

        public final int getLevel() {
            return this.level;
        }

        public ElementToAnalyze(TElement element3, int level) {
            this.element = element3;
            this.level = level;
        }

        public final TElement component1() {
            return this.element;
        }

        public final int component2() {
            return this.level;
        }

        @NotNull
        public final ElementToAnalyze<TElement> copy(TElement element3, int level) {
            return new ElementToAnalyze<TElement>(element3, level);
        }

        public static /* synthetic */ ElementToAnalyze copy$default(ElementToAnalyze elementToAnalyze, Object object, int n, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = elementToAnalyze.element;
            }
            if ((n2 & 2) != 0) {
                n = elementToAnalyze.level;
            }
            return elementToAnalyze.copy(object, n);
        }

        @NotNull
        public String toString() {
            return "ElementToAnalyze(element=" + this.element + ", level=" + this.level + ")";
        }

        public int hashCode() {
            TElement TElement = this.element;
            return (TElement != null ? TElement.hashCode() : 0) * 31 + Integer.hashCode(this.level);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ElementToAnalyze)) break block3;
                    ElementToAnalyze elementToAnalyze = (ElementToAnalyze)object;
                    if (!Intrinsics.areEqual(this.element, elementToAnalyze.element) || !(this.level == elementToAnalyze.level)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u001bJ\b\u0010\u001c\u001a\u00020\u0017H\u0004J\b\u0010\u001d\u001a\u00020\u0017H\u0004J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "TElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "(Lkotlin/jvm/functions/Function1;)V", "getElementFilter", "()Lkotlin/jvm/functions/Function1;", "elementsToAnalyze", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ElementToAnalyze;", "level", "", "options", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "getOptions", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "setOptions", "(Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;)V", "addQualifiedElementToAnalyze", "", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getElementsToAnalyze", "", "nextLevel", "prevLevel", "visitElement", "idea-core"})
    private static abstract class CollectElementsVisitor<TElement extends KtElement>
    extends KtVisitorVoid {
        @NotNull
        private Options options;
        private final ArrayList<ElementToAnalyze<TElement>> elementsToAnalyze;
        private int level;
        @NotNull
        private final Function1<PsiElement, FilterResult> elementFilter;

        @NotNull
        public final Options getOptions() {
            return this.options;
        }

        public final void setOptions(@NotNull Options options2) {
            Intrinsics.checkParameterIsNotNull((Object)options2, (String)"<set-?>");
            this.options = options2;
        }

        protected final void nextLevel() {
            int n = this.level;
            this.level = n + 1;
        }

        protected final void prevLevel() {
            int n = this.level;
            this.level = n + -1;
            n = this.level >= 0 ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }

        protected final void addQualifiedElementToAnalyze(@NotNull TElement element3) {
            Intrinsics.checkParameterIsNotNull(element3, (String)"element");
            this.elementsToAnalyze.add(new ElementToAnalyze<TElement>(element3, this.level));
        }

        public void visitElement(@NotNull PsiElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if ((FilterResult)((Object)this.elementFilter.invoke((Object)element3)) != FilterResult.SKIP) {
                element3.acceptChildren((PsiElementVisitor)this);
            }
        }

        @NotNull
        public final List<ElementToAnalyze<TElement>> getElementsToAnalyze() {
            return this.elementsToAnalyze;
        }

        @NotNull
        protected final Function1<PsiElement, FilterResult> getElementFilter() {
            return this.elementFilter;
        }

        public CollectElementsVisitor(@NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            this.elementFilter = elementFilter;
            this.options = Options.Companion.getDEFAULT();
            this.elementsToAnalyze = new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001,B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001d\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001eH$\u00a2\u0006\u0002\u0010\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001d\u0010$\u001a\u00020\u00022\u0006\u0010!\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&H$\u00a2\u0006\u0002\u0010'J(\u0010(\u001a\u00020\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020&0+R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor;", "TElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/Set;)V", "collectElementsVisitor", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "getCollectElementsVisitor", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "descriptorsToImport", "Ljava/util/LinkedHashSet;", "elementsToShorten", "Ljava/util/ArrayList;", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFailedToImportDescriptors", "()Ljava/util/Set;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "getResolutionFacade", "()Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "analyzeCollectedElements", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "analyzeQualifiedElement", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "getDescriptorsToImport", "shortenElement", "options", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;)Lorg/jetbrains/kotlin/psi/KtElement;", "shortenElements", "elementSetToUpdate", "", "Lkotlin/Function1;", "AnalyzeQualifiedElementResult", "idea-core"})
    private static abstract class ShorteningProcessor<TElement extends KtElement> {
        @NotNull
        private final ResolutionFacade resolutionFacade;
        private final ArrayList<SmartPsiElementPointer<TElement>> elementsToShorten;
        private final LinkedHashSet<DeclarationDescriptor> descriptorsToImport;
        @NotNull
        private final KtFile file;
        @NotNull
        private final Set<DeclarationDescriptor> failedToImportDescriptors;

        @NotNull
        protected final ResolutionFacade getResolutionFacade() {
            return this.resolutionFacade;
        }

        @NotNull
        public abstract CollectElementsVisitor<TElement> getCollectElementsVisitor();

        /*
         * Unable to fully structure code
         */
        public final void analyzeCollectedElements(@NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
            elements = this.getCollectElementsVisitor().getElementsToAnalyze();
            index = 0;
            while (index < elements.size()) {
                block17: {
                    block18: {
                        block15: {
                            block14: {
                                block16: {
                                    var6_6 = elements.get(index++);
                                    var4_4 = (KtElement)var6_6.component1();
                                    level = var6_6.component2();
                                    result = this.analyzeQualifiedElement(element, bindingContext);
                                    toBeShortened = false;
                                    var8_8 = result;
                                    if (!Intrinsics.areEqual((Object)var8_8, (Object)AnalyzeQualifiedElementResult.ShortenNow.INSTANCE)) break block16;
                                    this.elementsToShorten.add(PsiUtilsKt.createSmartPointer((PsiElement)element));
                                    toBeShortened = true;
                                    break block17;
                                }
                                if (!(var8_8 instanceof AnalyzeQualifiedElementResult.ImportDescriptors)) break block18;
                                var10_10 = ((AnalyzeQualifiedElementResult.ImportDescriptors)result).getDescriptors();
                                var11_11 = false;
                                if (!(var10_10.isEmpty() == false)) ** GOTO lbl-1000
                                $this$none$iv = ((AnalyzeQualifiedElementResult.ImportDescriptors)result).getDescriptors();
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    v0 = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        it = (DeclarationDescriptor)element$iv;
                                        $i$a$-none-ShortenReferences$ShorteningProcessor$analyzeCollectedElements$tryImport$1 = false;
                                        if (!this.failedToImportDescriptors.contains(it)) continue;
                                        v0 = false;
                                        break block14;
                                    }
                                    v0 = true;
                                }
                            }
                            if (!v0) ** GOTO lbl-1000
                            $this$all$iv = ((AnalyzeQualifiedElementResult.ImportDescriptors)result).getDescriptors();
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                v1 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    it = (DeclarationDescriptor)element$iv;
                                    $i$a$-all-ShortenReferences$ShorteningProcessor$analyzeCollectedElements$tryImport$2 = false;
                                    if (org.jetbrains.kotlin.idea.core.ShortenReferences$Companion.access$mayImport(ShortenReferences.Companion, it, this.file)) continue;
                                    v1 = false;
                                    break block15;
                                }
                                v1 = true;
                            }
                        }
                        if (v1) {
                            v2 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v2 = tryImport = false;
                        }
                        if (tryImport) {
                            this.descriptorsToImport.addAll(((AnalyzeQualifiedElementResult.ImportDescriptors)result).getDescriptors());
                            v3 = true;
                        } else {
                            v3 = false;
                        }
                        toBeShortened = v3;
                        break block17;
                    }
                    if (Intrinsics.areEqual((Object)var8_8, (Object)AnalyzeQualifiedElementResult.Skip.INSTANCE)) {
                        toBeShortened = false;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (!toBeShortened) continue;
                while (index < elements.size() && elements.get(index).getLevel() > level) {
                    ++index;
                }
            }
        }

        @NotNull
        protected abstract AnalyzeQualifiedElementResult analyzeQualifiedElement(@NotNull TElement var1, @NotNull BindingContext var2);

        @NotNull
        protected abstract KtElement shortenElement(@NotNull TElement var1, @NotNull Options var2);

        /*
         * WARNING - void declaration
         */
        public final void shortenElements(@NotNull Set<KtElement> elementSetToUpdate, @NotNull Function1<? super KtElement, Options> options2) {
            Intrinsics.checkParameterIsNotNull(elementSetToUpdate, (String)"elementSetToUpdate");
            Intrinsics.checkParameterIsNotNull(options2, (String)"options");
            Iterator<SmartPsiElementPointer<TElement>> iterator2 = this.elementsToShorten.iterator();
            while (iterator2.hasNext()) {
                void newElement;
                KtElement element3;
                SmartPsiElementPointer<TElement> elementPointer;
                SmartPsiElementPointer<TElement> smartPsiElementPointer = elementPointer = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(smartPsiElementPointer, (String)"elementPointer");
                if ((KtElement)smartPsiElementPointer.getElement() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"elementPointer.element ?: continue");
                if (!element3.isValid()) continue;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                PostprocessReformattingAspect.getInstance((Project)element3.getProject()).disablePostprocessFormattingInside(new Runnable(this, (Ref.ObjectRef)newElement, element3, options2){
                    final /* synthetic */ ShorteningProcessor this$0;
                    final /* synthetic */ Ref.ObjectRef $newElement;
                    final /* synthetic */ KtElement $element;
                    final /* synthetic */ Function1 $options;

                    public final void run() {
                        this.$newElement.element = this.this$0.shortenElement(this.$element, (Options)this.$options.invoke((Object)this.$element));
                    }
                    {
                        this.this$0 = shorteningProcessor;
                        this.$newElement = objectRef;
                        this.$element = ktElement;
                        this.$options = function1;
                    }
                });
                if (!elementSetToUpdate.contains(element3) || !(Intrinsics.areEqual((Object)((KtElement)newElement.element), (Object)element3) ^ true)) continue;
                elementSetToUpdate.remove(element3);
                KtElement ktElement = (KtElement)newElement.element;
                if (ktElement == null) {
                    Intrinsics.throwNpe();
                }
                elementSetToUpdate.add(ktElement);
            }
        }

        @NotNull
        public final Set<DeclarationDescriptor> getDescriptorsToImport() {
            return this.descriptorsToImport;
        }

        @NotNull
        protected final KtFile getFile() {
            return this.file;
        }

        @NotNull
        protected final Set<DeclarationDescriptor> getFailedToImportDescriptors() {
            return this.failedToImportDescriptors;
        }

        public ShorteningProcessor(@NotNull KtFile file2, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            this.file = file2;
            this.failedToImportDescriptors = failedToImportDescriptors;
            this.resolutionFacade = ResolutionUtils.getResolutionFacade(this.file);
            this.elementsToShorten = new ArrayList();
            this.descriptorsToImport = new LinkedHashSet();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "", "()V", "ImportDescriptors", "ShortenNow", "Skip", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult$Skip;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult$ShortenNow;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult$ImportDescriptors;", "idea-core"})
        protected static abstract class AnalyzeQualifiedElementResult {
            private AnalyzeQualifiedElementResult() {
            }

            public /* synthetic */ AnalyzeQualifiedElementResult(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult$Skip;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "()V", "idea-core"})
            public static final class Skip
            extends AnalyzeQualifiedElementResult {
                public static final Skip INSTANCE;

                private Skip() {
                    super(null);
                }

                static {
                    Skip skip2;
                    INSTANCE = skip2 = new Skip();
                }
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult$ShortenNow;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "()V", "idea-core"})
            public static final class ShortenNow
            extends AnalyzeQualifiedElementResult {
                public static final ShortenNow INSTANCE;

                private ShortenNow() {
                    super(null);
                }

                static {
                    ShortenNow shortenNow;
                    INSTANCE = shortenNow = new ShortenNow();
                }
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult$ImportDescriptors;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Ljava/util/Collection;)V", "getDescriptors", "()Ljava/util/Collection;", "idea-core"})
            public static final class ImportDescriptors
            extends AnalyzeQualifiedElementResult {
                @NotNull
                private final Collection<DeclarationDescriptor> descriptors;

                @NotNull
                public final Collection<DeclarationDescriptor> getDescriptors() {
                    return this.descriptors;
                }

                public ImportDescriptors(@NotNull Collection<? extends DeclarationDescriptor> descriptors2) {
                    Intrinsics.checkParameterIsNotNull(descriptors2, (String)"descriptors");
                    super(null);
                    this.descriptors = descriptors2;
                }
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShortenTypesProcessor;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "collectElementsVisitor", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "getCollectElementsVisitor", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "analyzeQualifiedElement", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "element", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "options", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "idea-core"})
    private static final class ShortenTypesProcessor
    extends ShorteningProcessor<KtUserType> {
        @NotNull
        private final CollectElementsVisitor<KtUserType> collectElementsVisitor;

        @Override
        @NotNull
        public CollectElementsVisitor<KtUserType> getCollectElementsVisitor() {
            return this.collectElementsVisitor;
        }

        @Override
        @NotNull
        protected ShorteningProcessor.AnalyzeQualifiedElementResult analyzeQualifiedElement(@NotNull KtUserType element3, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            if (element3.getQualifier() == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            KtSimpleNameExpression ktSimpleNameExpression = element3.getReferenceExpression();
            if (ktSimpleNameExpression == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element.referenceExpress\u2026alifiedElementResult.Skip");
            KtSimpleNameExpression referenceExpression = ktSimpleNameExpression;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(referenceExpression, bindingContext2));
            if (declarationDescriptor == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            DeclarationDescriptor target = declarationDescriptor;
            LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)element3, bindingContext2, this.getResolutionFacade());
            Name name2 = target.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"target.name");
            Name name3 = name2;
            DeclarationDescriptor targetByName = null;
            boolean isDeprecated = false;
            if (target instanceof ClassifierDescriptor) {
                DescriptorWithDeprecation<ClassifierDescriptor> classifierWithDeprecation;
                DescriptorWithDeprecation<ClassifierDescriptor> descriptorWithDeprecation = classifierWithDeprecation = ScopeUtilsKt.findFirstClassifierWithDeprecationStatus(scope2, name3, NoLookupLocation.FROM_IDE);
                targetByName = descriptorWithDeprecation != null ? descriptorWithDeprecation.getDescriptor() : null;
                DescriptorWithDeprecation<ClassifierDescriptor> descriptorWithDeprecation2 = classifierWithDeprecation;
                isDeprecated = descriptorWithDeprecation2 != null ? descriptorWithDeprecation2.isDeprecated() : false;
            } else {
                targetByName = ScopeUtilsKt.findPackage(scope2, name3);
                isDeprecated = false;
            }
            DeclarationDescriptor declarationDescriptor2 = targetByName;
            boolean canShortenNow = Intrinsics.areEqual((Object)(declarationDescriptor2 != null ? Companion.asString(declarationDescriptor2) : null), (Object)Companion.asString(target)) && !isDeprecated;
            return canShortenNow ? (ShorteningProcessor.AnalyzeQualifiedElementResult)ShorteningProcessor.AnalyzeQualifiedElementResult.ShortenNow.INSTANCE : (ShorteningProcessor.AnalyzeQualifiedElementResult)new ShorteningProcessor.AnalyzeQualifiedElementResult.ImportDescriptors(CollectionsKt.listOfNotNull((Object)target));
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtUserType element3, @NotNull Options options2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
            element3.deleteQualifier();
            return element3;
        }

        public ShortenTypesProcessor(@NotNull KtFile file2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file2, failedToImportDescriptors);
            this.collectElementsVisitor = new CollectElementsVisitor<KtUserType>(elementFilter, elementFilter){
                final /* synthetic */ Function1 $elementFilter;

                public void visitUserType(@NotNull KtUserType userType2) {
                    Intrinsics.checkParameterIsNotNull((Object)userType2, (String)"userType");
                    FilterResult filterResult = (FilterResult)((Object)this.$elementFilter.invoke((Object)userType2));
                    if (filterResult == FilterResult.SKIP) {
                        return;
                    }
                    KtTypeArgumentList ktTypeArgumentList = userType2.getTypeArgumentList();
                    if (ktTypeArgumentList != null) {
                        ktTypeArgumentList.accept(this);
                    }
                    if (filterResult == FilterResult.PROCESS) {
                        this.addQualifiedElementToAnalyze((KtElement)userType2);
                        this.nextLevel();
                    }
                    KtUserType ktUserType2 = userType2.getQualifier();
                    if (ktUserType2 != null) {
                        ktUserType2.accept(this);
                    }
                    if (filterResult == FilterResult.PROCESS) {
                        this.prevLevel();
                    }
                }
                {
                    this.$elementFilter = $captured_local_variable$0;
                    super((Function1<? super PsiElement, ? extends FilterResult>)$super_call_param$1);
                }
            };
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "collectElementsVisitor", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor$MyVisitor;", "getCollectElementsVisitor", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor$MyVisitor;", "MyVisitor", "idea-core"})
    private static abstract class QualifiedExpressionShorteningProcessor
    extends ShorteningProcessor<KtDotQualifiedExpression> {
        @NotNull
        private final MyVisitor collectElementsVisitor;

        @NotNull
        public MyVisitor getCollectElementsVisitor() {
            return this.collectElementsVisitor;
        }

        public QualifiedExpressionShorteningProcessor(@NotNull KtFile file2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file2, failedToImportDescriptors);
            this.collectElementsVisitor = new MyVisitor(elementFilter);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor$MyVisitor;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "(Lkotlin/jvm/functions/Function1;)V", "visitDotQualifiedExpression", "", "expression", "idea-core"})
        protected static class MyVisitor
        extends CollectElementsVisitor<KtDotQualifiedExpression> {
            @Override
            public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                FilterResult filterResult = (FilterResult)((Object)this.getElementFilter().invoke((Object)expression2));
                if (filterResult == FilterResult.SKIP) {
                    return;
                }
                KtExpression ktExpression = expression2.getSelectorExpression();
                if (ktExpression != null) {
                    ktExpression.acceptChildren(this);
                }
                if (filterResult == FilterResult.PROCESS) {
                    this.addQualifiedElementToAnalyze((KtElement)expression2);
                    this.nextLevel();
                }
                expression2.getReceiverExpression().accept(this);
                if (filterResult == FilterResult.PROCESS) {
                    this.prevLevel();
                }
            }

            public MyVisitor(@NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter) {
                Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
                super(elementFilter);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0014J$\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0$H\u0002R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShortenQualifiedExpressionsProcessor;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "collectElementsVisitor", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor$MyVisitor;", "getCollectElementsVisitor", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor$MyVisitor;", "analyzeQualifiedElement", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "element", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "copyShortenAndAnalyze", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resolvedCallsMatch", "", "rc1", "Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "rc2", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "options", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "targetsMatch", "targets1", "", "targets2", "idea-core"})
    private static final class ShortenQualifiedExpressionsProcessor
    extends QualifiedExpressionShorteningProcessor {
        @NotNull
        private final QualifiedExpressionShorteningProcessor.MyVisitor collectElementsVisitor;

        @Override
        @NotNull
        public QualifiedExpressionShorteningProcessor.MyVisitor getCollectElementsVisitor() {
            return this.collectElementsVisitor;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        @NotNull
        protected ShorteningProcessor.AnalyzeQualifiedElementResult analyzeQualifiedElement(@NotNull KtDotQualifiedExpression element, @NotNull BindingContext bindingContext) {
            block47: {
                block44: {
                    block43: {
                        block46: {
                            block42: {
                                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
                                if (!ShortenReferences.Companion.canBePossibleToDropReceiver(element, bindingContext)) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), (Class[])new Class[]{KtImportDirective.class, KtPackageDirective.class}) != null) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                v0 = element.getSelectorExpression();
                                if (v0 == null) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                selector = v0;
                                v1 = CallUtilKt.getCalleeExpressionIfAny(selector);
                                if (!(v1 instanceof KtReferenceExpression)) {
                                    v1 = null;
                                }
                                v2 = (KtReferenceExpression)v1;
                                if (v2 == null) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                callee = v2;
                                targets = org.jetbrains.kotlin.idea.core.ShortenReferences$Companion.access$targets(ShortenReferences.Companion, callee, bindingContext);
                                resolvedCall = CallUtilKt.getResolvedCall(callee, bindingContext);
                                if (targets.isEmpty()) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                var9_7 = this.copyShortenAndAnalyze(element, bindingContext);
                                var7_8 = (BindingContext)var9_7.component1();
                                selectorAfterShortening = (KtExpression)var9_7.component2();
                                v3 = CallUtilKt.getCalleeExpressionIfAny(selectorAfterShortening);
                                if (v3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
                                }
                                newCallee = (KtReferenceExpression)v3;
                                targetsWhenShort = org.jetbrains.kotlin.idea.core.ShortenReferences$Companion.access$targets(ShortenReferences.Companion, newCallee, (BindingContext)newContext);
                                resolvedCallWhenShort = CallUtilKt.getResolvedCall(newCallee, (BindingContext)newContext);
                                if (!this.targetsMatch(targets, targetsWhenShort)) ** GOTO lbl-1000
                                if (!(resolvedCall instanceof VariableAsFunctionResolvedCall)) ** GOTO lbl-1000
                                v4 = resolvedCallWhenShort;
                                if ((v4 != null ? v4 instanceof VariableAsFunctionResolvedCall : true) && this.resolvedCallsMatch((VariableAsFunctionResolvedCall)resolvedCall, (VariableAsFunctionResolvedCall)resolvedCallWhenShort)) lbl-1000:
                                // 2 sources

                                {
                                    v5 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v5 = false;
                                }
                                targetsMatch = v5;
                                isShortenedReferenceResolvesToDeprecated = Intrinsics.areEqual((Object)((Boolean)newContext.get(BindingContext.DEPRECATED_SHORT_NAME_ACCESS, newCallee)), (Object)true);
                                if (isShortenedReferenceResolvesToDeprecated) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                if (resolvedCall != null && resolvedCallWhenShort != null) {
                                    v6 = Intrinsics.areEqual((Object)resolvedCall.getResultingDescriptor().getOriginal(), (Object)resolvedCallWhenShort.getResultingDescriptor().getOriginal());
                                } else {
                                    v7 = CallUtilKt.getCall(selector, bindingContext);
                                    if (v7 == null || (v7 = UtilsKt.resolveCandidates$default((Call)v7, bindingContext, this.getResolutionFacade(), null, false, false, 28, null)) == null) {
                                        v7 = CollectionsKt.emptyList();
                                    }
                                    resolvedCalls = v7;
                                    callWhenShort = CallUtilKt.getCall(selectorAfterShortening, (BindingContext)newContext);
                                    v8 = CallUtilKt.getCall(selectorAfterShortening, (BindingContext)newContext);
                                    if (v8 == null || (v8 = UtilsKt.resolveCandidates$default((Call)v8, (BindingContext)newContext, this.getResolutionFacade(), null, false, false, 28, null)) == null) {
                                        v8 = CollectionsKt.emptyList();
                                    }
                                    resolvedCallsWhenShort = v8;
                                    $this$map$iv = (Iterable)resolvedCallsWhenShort;
                                    $i$f$map = false;
                                    var21_21 = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        var26_35 = (ResolvedCall)item$iv$iv /* !! */ ;
                                        var28_39 = destination$iv$iv;
                                        $i$a$-map-ShortenReferences$ShortenQualifiedExpressionsProcessor$analyzeQualifiedElement$resolvedCallsMatch$descriptorsOfResolvedCallsWhenShort$1 = false;
                                        v9 = it.getResultingDescriptor();
                                        Intrinsics.checkExpressionValueIsNotNull(v9, (String)"it.resultingDescriptor");
                                        var29_40 = ((FunctionDescriptor)v9).getOriginal();
                                        var28_39.add(var29_40);
                                    }
                                    descriptorsOfResolvedCallsWhenShort = (List)destination$iv$iv;
                                    $i$f$map = (Iterable)resolvedCalls;
                                    $this$mapTo$iv$iv = false;
                                    destination$iv = new LinkedHashSet<E>();
                                    $i$f$mapTo = false;
                                    for (T item$iv : $this$mapTo$iv) {
                                        item$iv$iv /* !! */  = (ResolvedCall)item$iv;
                                        var28_39 = destination$iv;
                                        $i$a$-mapTo-ShortenReferences$ShortenQualifiedExpressionsProcessor$analyzeQualifiedElement$resolvedCallsMatch$descriptorsOfResolvedCalls$1 = false;
                                        v10 = it.getResultingDescriptor();
                                        Intrinsics.checkExpressionValueIsNotNull(v10, (String)"it.resultingDescriptor");
                                        var29_40 = ((FunctionDescriptor)v10).getOriginal();
                                        var28_39.add(var29_40);
                                    }
                                    descriptorsOfResolvedCalls = (Set)destination$iv;
                                    v11 = this.getResolutionFacade();
                                    v12 = (PsiElement)newCallee;
                                    v13 = callWhenShort;
                                    v14 = v13 != null ? v13.getExplicitReceiver() : null;
                                    if (!(v14 instanceof ReceiverValue)) {
                                        v14 = null;
                                    }
                                    filter = new ShadowedDeclarationsFilter((BindingContext)newContext, v11, v12, (ReceiverValue)v14);
                                    availableDescriptorsWhenShort = filter.filter(descriptorsOfResolvedCallsWhenShort);
                                    $this$any$iv = availableDescriptorsWhenShort;
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        v6 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            it = (FunctionDescriptor)element$iv;
                                            $i$a$-any-ShortenReferences$ShortenQualifiedExpressionsProcessor$analyzeQualifiedElement$resolvedCallsMatch$1 = false;
                                            if (!descriptorsOfResolvedCalls.contains(it)) continue;
                                            v6 = true;
                                            break block42;
                                        }
                                        v6 = false;
                                    }
                                }
                            }
                            resolvedCallsMatch = v6;
                            receiver = element.getReceiverExpression();
                            if (receiver instanceof KtThisExpression) {
                                if (!targetsMatch) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                v15 = CallUtilKt.getResolvedCall(selector, bindingContext);
                                if (v15 == null) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                originalCall = v15;
                                v16 = CallUtilKt.getResolvedCall(selectorAfterShortening, (BindingContext)newContext);
                                if (v16 == null) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                newCall = v16;
                                v17 = originalCall.getExplicitReceiverKind();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"originalCall.explicitReceiverKind");
                                receiverKind = v17;
                                switch (ShortenReferences$ShortenQualifiedExpressionsProcessor$WhenMappings.$EnumSwitchMapping$0[receiverKind.ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        v18 = newCall.getExtensionReceiver();
                                        break;
                                    }
                                    case 3: {
                                        v18 = newCall.getDispatchReceiver();
                                        break;
                                    }
                                    default: {
                                        return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                    }
                                }
                                v19 = v18;
                                if (!(v18 instanceof ImplicitReceiver)) {
                                    v19 = null;
                                }
                                v20 = (ImplicitReceiver)v19;
                                if (v20 == null) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                                newReceiver = v20;
                                v21 = ((KtThisExpression)receiver).getInstanceReference();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"receiver.instanceReference");
                                thisTarget = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)org.jetbrains.kotlin.idea.core.ShortenReferences$Companion.access$targets(ShortenReferences.Companion, v21, bindingContext));
                                v22 = thisTarget;
                                if (Intrinsics.areEqual((Object)org.jetbrains.kotlin.idea.core.ShortenReferences$Companion.access$asString(ShortenReferences.Companion, newReceiver.getDeclarationDescriptor()), (Object)(v22 != null ? org.jetbrains.kotlin.idea.core.ShortenReferences$Companion.access$asString(ShortenReferences.Companion, v22) : null)) ^ true) {
                                    return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                                }
                            }
                            if (!targetsMatch && !resolvedCallsMatch) break block46;
                            v23 = ShorteningProcessor.AnalyzeQualifiedElementResult.ShortenNow.INSTANCE;
                            break block47;
                        }
                        $this$all$iv = targets;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v24 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = (DeclarationDescriptor)element$iv;
                                $i$a$-all-ShortenReferences$ShortenQualifiedExpressionsProcessor$analyzeQualifiedElement$1 = false;
                                if (it instanceof FunctionDescriptor) continue;
                                v24 = false;
                                break block43;
                            }
                            v24 = true;
                        }
                    }
                    if (!v24) ** GOTO lbl-1000
                    $this$all$iv = targetsWhenShort;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v25 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (DeclarationDescriptor)element$iv;
                            $i$a$-all-ShortenReferences$ShortenQualifiedExpressionsProcessor$analyzeQualifiedElement$2 = false;
                            if (it instanceof PropertyDescriptor) continue;
                            v25 = false;
                            break block44;
                        }
                        v25 = true;
                    }
                }
                if (v25) {
                    v23 = new ShorteningProcessor.AnalyzeQualifiedElementResult.ImportDescriptors(targets);
                } else lbl-1000:
                // 2 sources

                {
                    block45: {
                        $this$any$iv = targetsWhenShort;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v26 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (DeclarationDescriptor)element$iv;
                                $i$a$-any-ShortenReferences$ShortenQualifiedExpressionsProcessor$analyzeQualifiedElement$3 = false;
                                if (!(it instanceof ClassifierDescriptorWithTypeParameters == false && it instanceof PackageViewDescriptor == false)) continue;
                                v26 = true;
                                break block45;
                            }
                            v26 = false;
                        }
                    }
                    v23 = v26 != false ? (ShorteningProcessor.AnalyzeQualifiedElementResult)ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE : (ShorteningProcessor.AnalyzeQualifiedElementResult)new ShorteningProcessor.AnalyzeQualifiedElementResult.ImportDescriptors(targets);
                }
            }
            return v23;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<BindingContext, KtExpression> copyShortenAndAnalyze(KtDotQualifiedExpression element3, BindingContext bindingContext2) {
            void $this$getParentOfType$iv;
            KtExpression ktExpression = element3.getSelectorExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression selector2 = ktExpression;
            PsiElement psiElement2 = (PsiElement)element3;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtDoubleColonExpression doubleColonExpression = (KtDoubleColonExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDoubleColonExpression.class, (boolean)strict$iv);
            if (doubleColonExpression != null && Intrinsics.areEqual((Object)doubleColonExpression.getReceiverExpression(), (Object)element3)) {
                KtDoubleColonExpression doubleColonExpressionCopy = (KtDoubleColonExpression)PsiModificationUtilsKt.copied((PsiElement)doubleColonExpression);
                KtExpression ktExpression2 = doubleColonExpressionCopy.getReceiverExpression();
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                ktExpression2.replace((PsiElement)selector2);
                BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)doubleColonExpressionCopy, (KtExpression)doubleColonExpression, bindingContext2, this.getResolutionFacade(), null, null, 24, null);
                KtExpression ktExpression3 = doubleColonExpressionCopy.getReceiverExpression();
                if (ktExpression3 == null) {
                    Intrinsics.throwNpe();
                }
                return TuplesKt.to((Object)newBindingContext, (Object)ktExpression3);
            }
            KtQualifiedExpression qualifiedAbove = KtPsiUtilKt.getQualifiedExpressionForReceiver(element3);
            if (qualifiedAbove != null) {
                KtQualifiedExpression qualifiedAboveCopy = (KtQualifiedExpression)PsiModificationUtilsKt.copied((PsiElement)qualifiedAbove);
                qualifiedAboveCopy.getReceiverExpression().replace((PsiElement)selector2);
                BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)qualifiedAboveCopy, (KtExpression)qualifiedAbove, bindingContext2, this.getResolutionFacade(), null, null, 24, null);
                return TuplesKt.to((Object)newBindingContext, (Object)qualifiedAboveCopy.getReceiverExpression());
            }
            KtExpression copied = (KtExpression)PsiModificationUtilsKt.copied((PsiElement)selector2);
            BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default(copied, (KtExpression)element3, bindingContext2, this.getResolutionFacade(), null, null, 24, null);
            return TuplesKt.to((Object)newBindingContext, (Object)copied);
        }

        private final boolean targetsMatch(Collection<? extends DeclarationDescriptor> targets1, Collection<? extends DeclarationDescriptor> targets2) {
            boolean bl;
            if (targets1.size() != targets2.size()) {
                return false;
            }
            if (targets1.size() == 1) {
                bl = Intrinsics.areEqual((Object)Companion.asString((DeclarationDescriptor)CollectionsKt.single((Iterable)targets1)), (Object)Companion.asString((DeclarationDescriptor)CollectionsKt.single((Iterable)targets2)));
            } else {
                Object object;
                DeclarationDescriptor it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = targets1;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    object = Companion.asString(it);
                    collection.add(object);
                }
                $this$map$iv = targets2;
                collection = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DeclarationDescriptor)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl3 = false;
                    String string = Companion.asString(it);
                    object.add(string);
                }
                object = (List)destination$iv$iv;
                bl = Intrinsics.areEqual((Object)collection, (Object)CollectionsKt.toSet((Iterable)((Iterable)object)));
            }
            return bl;
        }

        private final boolean resolvedCallsMatch(VariableAsFunctionResolvedCall rc1, VariableAsFunctionResolvedCall rc2) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = rc1;
            return Intrinsics.areEqual(object4 != null && (object4 = object4.getVariableCall()) != null && (object4 = (VariableDescriptor)object4.getCandidateDescriptor()) != null ? Companion.asString((DeclarationDescriptor)object4) : null, (object3 = rc2) != null && (object3 = object3.getVariableCall()) != null && (object3 = (VariableDescriptor)object3.getCandidateDescriptor()) != null ? Companion.asString((DeclarationDescriptor)object3) : null) && Intrinsics.areEqual((object2 = rc1) != null && (object2 = object2.getFunctionCall()) != null && (object2 = (FunctionDescriptor)object2.getCandidateDescriptor()) != null ? Companion.asString((DeclarationDescriptor)object2) : null, (object = rc2) != null && (object = object.getFunctionCall()) != null && (object = (FunctionDescriptor)object.getCandidateDescriptor()) != null ? Companion.asString((DeclarationDescriptor)object) : null);
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtDotQualifiedExpression element3, @NotNull Options options2) {
            KtParenthesizedExpression parens;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
            PsiElement psiElement2 = element3.getParent();
            if (!(psiElement2 instanceof KtParenthesizedExpression)) {
                psiElement2 = null;
            }
            boolean requiredParens = (parens = (KtParenthesizedExpression)psiElement2) != null && !KtPsiUtil.areParenthesesUseless(parens);
            KtExpression ktExpression = element3.getSelectorExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement3 = element3.replace((PsiElement)ktExpression);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            KtElement shortenedElement = (KtElement)psiElement3;
            PsiElement newParent = shortenedElement.getParent();
            if (requiredParens) {
                KtElement ktElement;
                PsiElement psiElement4 = newParent;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"newParent");
                PsiElement $this$replaced$iv = psiElement4;
                boolean $i$f$replaced = false;
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)shortenedElement);
                PsiElement psiElement5 = result$iv;
                if (!(psiElement5 instanceof KtElement)) {
                    psiElement5 = null;
                }
                if ((ktElement = (KtElement)psiElement5) == null) {
                    PsiElement psiElement6 = result$iv;
                    if (psiElement6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement6).getExpression();
                    if (ktExpression2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    }
                    ktElement = ktExpression2;
                }
                return ktElement;
            }
            if (options2.getDropBracesInStringTemplates() && newParent instanceof KtBlockStringTemplateEntry && PsiModificationUtilsKt.canDropBraces((KtBlockStringTemplateEntry)newParent)) {
                PsiModificationUtilsKt.dropBraces((KtBlockStringTemplateEntry)newParent);
            }
            return shortenedElement;
        }

        public ShortenQualifiedExpressionsProcessor(@NotNull KtFile file2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file2, elementFilter, failedToImportDescriptors);
            this.collectElementsVisitor = new QualifiedExpressionShorteningProcessor.MyVisitor(elementFilter, elementFilter){
                final /* synthetic */ Function1 $elementFilter;

                public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    if (expression2.getReceiverExpression() instanceof KtThisExpression && !this.getOptions().getRemoveThis()) {
                        FilterResult filterResult = (FilterResult)((Object)this.$elementFilter.invoke((Object)expression2));
                        if (filterResult == FilterResult.SKIP) {
                            return;
                        }
                        KtExpression ktExpression = expression2.getSelectorExpression();
                        if (ktExpression != null) {
                            ktExpression.acceptChildren(this);
                        }
                        return;
                    }
                    super.visitDotQualifiedExpression(expression2);
                }
                {
                    this.$elementFilter = $captured_local_variable$0;
                    super((Function1<? super PsiElement, ? extends FilterResult>)$super_call_param$1);
                }
            };
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShortenThisExpressionsProcessor;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor;", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "collectElementsVisitor", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "getCollectElementsVisitor", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences$CollectElementsVisitor;", "simpleThis", "analyzeQualifiedElement", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "element", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "options", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "idea-core"})
    private static final class ShortenThisExpressionsProcessor
    extends ShorteningProcessor<KtThisExpression> {
        private final KtThisExpression simpleThis;
        @NotNull
        private final CollectElementsVisitor<KtThisExpression> collectElementsVisitor;

        @Override
        @NotNull
        public CollectElementsVisitor<KtThisExpression> getCollectElementsVisitor() {
            return this.collectElementsVisitor;
        }

        @Override
        @NotNull
        protected ShorteningProcessor.AnalyzeQualifiedElementResult analyzeQualifiedElement(@NotNull KtThisExpression element3, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            KtReferenceExpression ktReferenceExpression = element3.getInstanceReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktReferenceExpression, (String)"element.instanceReference");
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(ktReferenceExpression, bindingContext2));
            if (declarationDescriptor == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            DeclarationDescriptor targetBefore = declarationDescriptor;
            BindingContext newContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)this.simpleThis, (KtExpression)element3, bindingContext2, this.getResolutionFacade(), null, null, 24, null);
            KtReferenceExpression ktReferenceExpression2 = this.simpleThis.getInstanceReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktReferenceExpression2, (String)"simpleThis.instanceReference");
            DeclarationDescriptor targetAfter = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)Companion.targets(ktReferenceExpression2, newContext));
            return Intrinsics.areEqual((Object)targetBefore, (Object)targetAfter) ? (ShorteningProcessor.AnalyzeQualifiedElementResult)ShorteningProcessor.AnalyzeQualifiedElementResult.ShortenNow.INSTANCE : (ShorteningProcessor.AnalyzeQualifiedElementResult)ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtThisExpression element3, @NotNull Options options2) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
            PsiElement psiElement2 = element3.replace((PsiElement)this.simpleThis);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            return (KtElement)psiElement2;
        }

        public ShortenThisExpressionsProcessor(@NotNull KtFile file2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file2, failedToImportDescriptors);
            KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file2, false, 2, null).createExpression("this");
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThisExpression");
            }
            this.simpleThis = (KtThisExpression)ktExpression;
            this.collectElementsVisitor = new CollectElementsVisitor<KtThisExpression>(elementFilter, elementFilter){
                final /* synthetic */ Function1 $elementFilter;

                public void visitThisExpression(@NotNull KtThisExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    if (this.getOptions().getRemoveThisLabels() && (FilterResult)((Object)this.$elementFilter.invoke((Object)expression2)) == FilterResult.PROCESS && expression2.getTargetLabel() != null) {
                        this.addQualifiedElementToAnalyze((KtElement)expression2);
                    }
                }
                {
                    this.$elementFilter = $captured_local_variable$0;
                    super((Function1<? super PsiElement, ? extends FilterResult>)$super_call_param$1);
                }
            };
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\n*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$RemoveExplicitCompanionObjectReferenceProcessor;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$QualifiedExpressionShorteningProcessor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementFilter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$FilterResult;", "failedToImportDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "analyzeQualifiedElement", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$ShorteningProcessor$AnalyzeQualifiedElementResult;", "element", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "shortenElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "options", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Options;", "singleTarget", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "idea-core"})
    private static final class RemoveExplicitCompanionObjectReferenceProcessor
    extends QualifiedExpressionShorteningProcessor {
        private final DeclarationDescriptor singleTarget(@NotNull KtExpression $this$singleTarget, BindingContext context2) {
            Object object;
            KtExpression ktExpression = CallUtilKt.getCalleeExpressionIfAny($this$singleTarget);
            if (!(ktExpression instanceof KtReferenceExpression)) {
                ktExpression = null;
            }
            return (object = (KtReferenceExpression)ktExpression) != null && (object = Companion.targets((KtReferenceExpression)object, context2)) != null ? (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : null;
        }

        @Override
        @NotNull
        protected ShorteningProcessor.AnalyzeQualifiedElementResult analyzeQualifiedElement(@NotNull KtDotQualifiedExpression element3, @NotNull BindingContext bindingContext2) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            PsiElement parent2 = element3.getParent();
            if (parent2 instanceof KtCallableReferenceExpression && Intrinsics.areEqual((Object)((KtCallableReferenceExpression)parent2).getReceiverExpression(), (Object)element3)) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            KtExpression receiver2 = element3.getReceiverExpression();
            if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element3), (Class[])new Class[]{KtImportDirective.class, KtPackageDirective.class}) != null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            DeclarationDescriptor declarationDescriptor = this.singleTarget(receiver2, bindingContext2);
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor2 == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            ClassDescriptor receiverTarget = classDescriptor2;
            KtExpression ktExpression2 = element3.getSelectorExpression();
            if (ktExpression2 == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            KtExpression selectorExpression = ktExpression2;
            DeclarationDescriptor declarationDescriptor2 = this.singleTarget(selectorExpression, bindingContext2);
            if (declarationDescriptor2 == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            DeclarationDescriptor selectorTarget = declarationDescriptor2;
            if (Intrinsics.areEqual((Object)receiverTarget.getCompanionObjectDescriptor(), (Object)selectorTarget) ^ true) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            PsiElement psiElement2 = parent2;
            if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                psiElement2 = null;
            }
            if ((ktExpression = (KtDotQualifiedExpression)psiElement2) == null || (ktExpression = ktExpression.getSelectorExpression()) == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.ShortenNow.INSTANCE;
            }
            KtExpression selectorsSelector = ktExpression;
            DeclarationDescriptor declarationDescriptor3 = this.singleTarget(selectorsSelector, bindingContext2);
            if (declarationDescriptor3 == null) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            DeclarationDescriptor selectorsSelectorTarget = declarationDescriptor3;
            if (selectorsSelectorTarget instanceof ClassDescriptor) {
                return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
            }
            if (selectorsSelectorTarget instanceof PropertyDescriptor) {
                KtProperty source;
                SourceElement sourceElement = ((PropertyDescriptor)selectorsSelectorTarget).getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"selectorsSelectorTarget.source");
                PsiElement psiElement3 = KotlinSourceElementKt.getPsi(sourceElement);
                if (!(psiElement3 instanceof KtProperty)) {
                    psiElement3 = null;
                }
                if ((source = (KtProperty)psiElement3) != null) {
                    PsiElement psiElement4 = source;
                    String string = source.getName();
                    if (string == null) {
                        string = "";
                    }
                    if (UtilsKt.isEnumCompanionPropertyWithEntryConflict(psiElement4, string)) {
                        return ShorteningProcessor.AnalyzeQualifiedElementResult.Skip.INSTANCE;
                    }
                }
            }
            return ShorteningProcessor.AnalyzeQualifiedElementResult.ShortenNow.INSTANCE;
        }

        @Override
        @NotNull
        protected KtElement shortenElement(@NotNull KtDotQualifiedExpression element3, @NotNull Options options2) {
            KtElement ktElement;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
            KtExpression receiver2 = element3.getReceiverExpression();
            KtExpression ktExpression = element3.getSelectorExpression();
            if (ktExpression == null) {
                return element3;
            }
            KtExpression selector2 = ktExpression;
            KtExpression ktExpression2 = receiver2;
            if (ktExpression2 instanceof KtSimpleNameExpression) {
                KtSimpleNameExpression ktSimpleNameExpression;
                PsiElement psiElement2 = ((KtSimpleNameExpression)receiver2).getIdentifier();
                if (psiElement2 == null) {
                    return element3;
                }
                PsiElement identifier2 = psiElement2;
                KtExpression ktExpression3 = CallUtilKt.getCalleeExpressionIfAny(selector2);
                if (!(ktExpression3 instanceof KtSimpleNameExpression)) {
                    ktExpression3 = null;
                }
                if ((ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression3) != null && (ktSimpleNameExpression = ktSimpleNameExpression.getIdentifier()) != null) {
                    ktSimpleNameExpression.replace(identifier2);
                }
                PsiElement psiElement3 = element3.replace((PsiElement)selector2);
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                ktElement = (KtExpression)psiElement3;
            } else if (ktExpression2 instanceof KtQualifiedExpression) {
                KtSimpleNameExpression ktSimpleNameExpression;
                KtSimpleNameExpression ktSimpleNameExpression2;
                KtExpression ktExpression4 = ((KtQualifiedExpression)receiver2).getSelectorExpression();
                if (!(ktExpression4 instanceof KtSimpleNameExpression)) {
                    ktExpression4 = null;
                }
                if ((ktSimpleNameExpression2 = (KtSimpleNameExpression)ktExpression4) == null || (ktSimpleNameExpression2 = ktSimpleNameExpression2.getIdentifier()) == null) {
                    return element3;
                }
                KtSimpleNameExpression identifier3 = ktSimpleNameExpression2;
                KtExpression ktExpression5 = CallUtilKt.getCalleeExpressionIfAny(selector2);
                if (!(ktExpression5 instanceof KtSimpleNameExpression)) {
                    ktExpression5 = null;
                }
                if ((ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression5) != null && (ktSimpleNameExpression = ktSimpleNameExpression.getIdentifier()) != null) {
                    ktSimpleNameExpression.replace((PsiElement)identifier3);
                }
                KtExpression ktExpression6 = ((KtQualifiedExpression)receiver2).getSelectorExpression();
                if (ktExpression6 != null) {
                    ktExpression6.replace((PsiElement)selector2);
                }
                PsiElement psiElement4 = element3.replace((PsiElement)receiver2);
                if (psiElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                ktElement = (KtExpression)psiElement4;
            } else {
                ktElement = element3;
            }
            return ktElement;
        }

        public RemoveExplicitCompanionObjectReferenceProcessor(@NotNull KtFile file2, @NotNull Function1<? super PsiElement, ? extends FilterResult> elementFilter, @NotNull Set<? extends DeclarationDescriptor> failedToImportDescriptors) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(elementFilter, (String)"elementFilter");
            Intrinsics.checkParameterIsNotNull(failedToImportDescriptors, (String)"failedToImportDescriptors");
            super(file2, elementFilter, failedToImportDescriptors);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0010H\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/ShortenReferences$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "RETAIN_COMPANION", "getRETAIN_COMPANION", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "canBePossibleToDropReceiver", "", "element", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "mayImport", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "asString", "", "targets", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "context", "idea-core"})
    public static final class Companion {
        @NotNull
        public final ShortenReferences getRETAIN_COMPANION() {
            return RETAIN_COMPANION;
        }

        public final boolean canBePossibleToDropReceiver(@NotNull KtDotQualifiedExpression element3, @NotNull BindingContext bindingContext2) {
            DeclarationDescriptor targetDescriptor;
            KtNameReferenceExpression ktNameReferenceExpression;
            KtExpression receiver2;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            KtExpression ktExpression = receiver2 = element3.getReceiverExpression();
            if (ktExpression instanceof KtThisExpression) {
                return true;
            }
            if (ktExpression instanceof KtNameReferenceExpression) {
                ktNameReferenceExpression = (KtNameReferenceExpression)receiver2;
            } else if (ktExpression instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression2 = ((KtDotQualifiedExpression)receiver2).getSelectorExpression();
                if (!(ktExpression2 instanceof KtNameReferenceExpression)) {
                    ktExpression2 = null;
                }
                if ((ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression2) == null) {
                    return false;
                }
            } else {
                return false;
            }
            KtNameReferenceExpression nameRef = ktNameReferenceExpression;
            DeclarationDescriptor declarationDescriptor = targetDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, nameRef);
            if (declarationDescriptor instanceof ClassDescriptor) {
                if (((ClassDescriptor)targetDescriptor).getKind() != ClassKind.OBJECT) {
                    return true;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element3, bindingContext2);
                if (resolvedCall2 == null) {
                    return false;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                ExplicitReceiverKind explicitReceiverKind = resolvedCall3.getExplicitReceiverKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)explicitReceiverKind), (String)"resolvedCall.explicitReceiverKind");
                ExplicitReceiverKind receiverKind = explicitReceiverKind;
                return receiverKind == ExplicitReceiverKind.DISPATCH_RECEIVER || receiverKind == ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            }
            return declarationDescriptor instanceof PackageViewDescriptor;
        }

        private final String asString(@NotNull DeclarationDescriptor $this$asString) {
            return DescriptorRenderer.FQ_NAMES_IN_TYPES.render($this$asString);
        }

        private final Collection<DeclarationDescriptor> targets(@NotNull KtReferenceExpression $this$targets, BindingContext context2) {
            return ImportsUtils.getImportableTargets($this$targets, context2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean mayImport(DeclarationDescriptor descriptor2, KtFile file2) {
            if (!ImportsUtils.canBeReferencedViaImport(descriptor2)) return false;
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            if (!ImportInsertHelper.Companion.getInstance(project).mayImportOnShortenReferences(descriptor2)) return false;
            return true;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$mayImport(Companion $this, DeclarationDescriptor descriptor2, KtFile file2) {
            return $this.mayImport(descriptor2, file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

